/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.surface.client.gui.screen.tome.render;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_8000;
import net.minecraft.class_8001;

public class AnvilRecipe {
    private final class_2960 ANVIL_RECIPE = new class_2960("surface", "textures/gui/gameplay/tome/anvil_recipe.png");
    private final List<class_1799> first;
    private final List<class_1799> second;
    private final List<class_1799> output;
    private class_1799 currentFirstStack;
    private float firstStackAnimationProgress = 0.0f;
    private class_1799 currentSecondStack;
    private float secondStackAnimationProgress = 0.0f;
    private class_1799 currentOutputStack;
    private float outputStackAnimationProgress = 0.0f;

    private AnvilRecipe(List<class_1799> first, List<class_1799> second, List<class_1799> output) {
        this.first = first;
        this.second = second;
        this.output = output;
        this.currentFirstStack = this.first.isEmpty() ? class_1799.field_8037 : this.first.get(0);
        this.currentSecondStack = this.second.isEmpty() ? class_1799.field_8037 : this.second.get(0);
        this.currentOutputStack = this.output.isEmpty() ? class_1799.field_8037 : this.output.get(0);
    }

    public void render(class_332 context, class_327 textRenderer, int x, int y, double mouseX, double mouseY, float delta) {
        context.method_25290(this.ANVIL_RECIPE, x, y, 0.0f, 0.0f, 101, 20, 101, 20);
        this.renderItem(this.currentFirstStack, context, textRenderer, x + 2, y + 2);
        this.renderItem(this.currentSecondStack, context, textRenderer, x + 38, y + 2);
        this.renderItem(this.currentOutputStack, context, textRenderer, x + 83, y + 2);
        this.updateCurrentStacks(delta);
        this.updateTooltips(x, y, mouseX, mouseY);
    }

    private void renderItem(class_1799 stack, class_332 context, class_327 renderer, int x, int y) {
        context.method_51427(stack, x, y);
        context.method_51431(renderer, stack, x, y);
    }

    private void updateTooltips(int x, int y, double mouseX, double mouseY) {
        if (this.isHoveringOver(mouseX, mouseY, x + 2, y + 2)) {
            this.setTooltip(this.currentFirstStack);
        } else if (this.isHoveringOver(mouseX, mouseY, x + 38, y + 2)) {
            this.setTooltip(this.currentSecondStack);
        } else if (this.isHoveringOver(mouseX, mouseY, x + 83, y + 2)) {
            this.setTooltip(this.currentOutputStack);
        }
    }

    protected boolean isHoveringOver(double mouseX, double mouseY, int startX, int startY) {
        boolean blX = mouseX >= (double)startX && mouseX <= (double)(startX + 16);
        boolean blY = mouseY >= (double)startY && mouseY <= (double)(startY + 16);
        return blX && blY;
    }

    private void setTooltip(class_1799 itemStack) {
        class_8000 position = class_8001.field_41687;
        class_437 screen = class_310.method_1551().field_1755;
        if (screen == null) {
            return;
        }
        screen.method_47942(class_437.method_25408((class_310)class_310.method_1551(), (class_1799)itemStack).stream().map(class_2561::method_30937).toList(), position, true);
    }

    private void updateCurrentStacks(double delta) {
        int index;
        int lastIndex;
        if (this.first.size() > 1) {
            this.firstStackAnimationProgress = (float)((double)this.firstStackAnimationProgress + 0.5 * delta);
            if (this.firstStackAnimationProgress > 10.0f) {
                lastIndex = this.first.indexOf(this.currentFirstStack) + 1;
                index = lastIndex < this.first.size() ? lastIndex : 0;
                this.currentFirstStack = this.first.get(index);
                this.firstStackAnimationProgress = 0.0f;
            }
        }
        if (this.second.size() > 1) {
            this.secondStackAnimationProgress = (float)((double)this.secondStackAnimationProgress + 0.5 * delta);
            if (this.secondStackAnimationProgress > 10.0f) {
                lastIndex = this.second.indexOf(this.currentSecondStack) + 1;
                index = lastIndex < this.second.size() ? lastIndex : 0;
                this.currentSecondStack = this.second.get(index);
                this.secondStackAnimationProgress = 0.0f;
            }
        }
        if (this.output.size() > 1) {
            this.outputStackAnimationProgress = (float)((double)this.outputStackAnimationProgress + 0.5 * delta);
            if (this.outputStackAnimationProgress > 10.0f) {
                lastIndex = this.output.indexOf(this.currentOutputStack) + 1;
                index = lastIndex < this.output.size() ? lastIndex : 0;
                this.currentOutputStack = this.output.get(index);
                this.outputStackAnimationProgress = 0.0f;
            }
        }
    }

    public static class AnvilRecipeGrid {
        private List<class_1799> first = new ArrayList<class_1799>();
        private List<class_1799> second = new ArrayList<class_1799>();
        private List<class_1799> output = new ArrayList<class_1799>();

        public AnvilRecipeGrid first(class_1935 ... convertibles) {
            return this.first(Arrays.stream(convertibles).map(class_1799::new).toList());
        }

        public AnvilRecipeGrid first(class_1799 ... first) {
            return this.first(List.of(first));
        }

        public AnvilRecipeGrid first(List<class_1799> first) {
            this.first = first;
            return this;
        }

        public AnvilRecipeGrid second(class_1935 ... convertibles) {
            return this.second(Arrays.stream(convertibles).map(class_1799::new).toList());
        }

        public AnvilRecipeGrid second(class_1799 ... second) {
            return this.second(List.of(second));
        }

        public AnvilRecipeGrid second(List<class_1799> second) {
            this.second = second;
            return this;
        }

        public AnvilRecipeGrid output(class_1935 ... convertibles) {
            return this.output(Arrays.stream(convertibles).map(class_1799::new).toList());
        }

        public AnvilRecipeGrid output(class_1799 ... output) {
            return this.output(List.of(output));
        }

        public AnvilRecipeGrid output(List<class_1799> output) {
            this.output = output;
            return this;
        }

        public AnvilRecipe build() {
            return new AnvilRecipe(this.first, this.second, this.output);
        }
    }
}

