/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.surface.item;

import com.manchick.surface.entity.SurfaceEntityTags;
import com.manchick.surface.world.SurfaceGameRules;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3483;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7430;
import net.minecraft.class_7444;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BattleHornItem
extends class_7430 {
    private static final String INSTRUMENT_KEY = "instrument";
    private static final String TARGET_KEY = "Target";
    private static final String TARGETING_KEY = "isTargeting";
    private final class_6862<class_7444> instrumentTag;

    public BattleHornItem(class_1792.class_1793 settings, class_6862<class_7444> instrumentTag) {
        super(settings, instrumentTag);
        this.instrumentTag = instrumentTag;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack;
        Optional<? extends class_6880<class_7444>> optional;
        class_1799 stack = user.method_5998(hand);
        class_2338 blockPos = user.method_24515();
        class_238 box = new class_238(blockPos).method_1014((double)this.getRange(stack));
        List hearingEntities = world.method_18467(class_1309.class, box);
        if (!world.field_9236) {
            for (class_1309 livingEntity : hearingEntities) {
                if (!livingEntity.method_5805() || livingEntity.method_31481() || livingEntity == user || !world.method_8450().method_8355(SurfaceGameRules.TARGET_PLAYERS) && livingEntity.method_31747() || !this.shouldGlow(stack, livingEntity)) continue;
                BattleHornItem.glowEntity(livingEntity);
            }
        }
        if ((optional = this.getInstrument(itemStack = user.method_5998(hand))).isPresent()) {
            class_7444 instrument = (class_7444)optional.get().comp_349();
            user.method_6019(hand);
            this.playSound(world, user, instrument);
            user.method_7357().method_7906((class_1792)this, 500);
            user.method_7259(class_3468.field_15372.method_14956((Object)this));
            return class_1271.method_22428((Object)itemStack);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    private int getRange(class_1799 stack) {
        return stack.method_7948().method_10545(TARGET_KEY) ? 32 : 24;
    }

    private Optional<? extends class_6880<class_7444>> getInstrument(class_1799 stack) {
        class_2960 identifier;
        class_2487 nbtCompound = stack.method_7969();
        if (nbtCompound != null && nbtCompound.method_10573(INSTRUMENT_KEY, 8) && (identifier = class_2960.method_12829((String)nbtCompound.method_10558(INSTRUMENT_KEY))) != null) {
            return class_7923.field_41166.method_40264(class_5321.method_29179((class_5321)class_7924.field_41275, (class_2960)identifier));
        }
        Iterator iterator = class_7923.field_41166.method_40286(this.instrumentTag).iterator();
        if (iterator.hasNext()) {
            return Optional.of((class_6880)iterator.next());
        }
        return Optional.empty();
    }

    public boolean shouldGlow(class_1799 stack, class_1309 entity) {
        class_2487 compound = stack.method_7948();
        if (!compound.method_10545(TARGET_KEY)) {
            return true;
        }
        BattleHornTarget target = this.fromTarget(compound);
        return entity.method_5864().method_20210(target.getAssociatedTag());
    }

    public static class_1799 withTarget(class_1799 stack, BattleHornTarget target) {
        class_2487 compound = stack.method_7948();
        compound.method_10582(TARGET_KEY, target.toString().toLowerCase());
        compound.method_10556(TARGETING_KEY, true);
        class_1799 returnStack = stack.method_7972();
        returnStack.method_7980(compound);
        return returnStack;
    }

    @NotNull
    private BattleHornTarget fromTarget(class_2487 compound) {
        String str = compound.method_10558(TARGET_KEY);
        return BattleHornTarget.valueOf(str.toUpperCase());
    }

    private static void glowEntity(class_1309 entity) {
        entity.method_6092(new class_1293(class_1294.field_5912, 300));
        entity.method_6092(new class_1293(class_1294.field_5909, 300, 1));
    }

    private void playSound(class_1937 world, class_1657 player, class_7444 instrument) {
        class_3414 soundEvent = (class_3414)instrument.comp_772().comp_349();
        float f = instrument.comp_774() / 16.0f;
        world.method_8396(null, player.method_24515(), soundEvent, class_3419.field_15247, f, 1.0f);
        world.method_32888(class_5712.field_39415, player.method_19538(), class_5712.class_7397.method_43285((class_1297)player));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        class_5250 baseText = class_2561.method_43471((String)"item.surface.battle_horn.targeting").method_10852((class_2561)class_2561.method_43470((String)": ")).method_27692(class_124.field_1080);
        class_2487 compound = stack.method_7948();
        if (compound.method_10545(TARGET_KEY)) {
            BattleHornTarget target = this.fromTarget(compound);
            class_5250 targetText = class_2561.method_43471((String)BattleHornTarget.getTranslation(target)).method_10862(class_2583.field_24360.method_36139(8821423));
            class_5250 toolipText = baseText.method_10852((class_2561)targetText);
            tooltip.add((class_2561)toolipText);
        }
        super.method_7851(stack, world, tooltip, context);
    }

    public static enum BattleHornTarget {
        ZOMBIE(SurfaceEntityTags.ZOMBIE),
        SKELETON(class_3483.field_15507),
        ANIMALS(SurfaceEntityTags.ANIMALS),
        PEACEFUL(SurfaceEntityTags.PEACEFUL),
        ILLAGERS(SurfaceEntityTags.ILLAGERS),
        ENDER(SurfaceEntityTags.ENDER),
        NETHER(SurfaceEntityTags.NETHER),
        BOUNCY(SurfaceEntityTags.BOUNCY),
        AQUATIC(SurfaceEntityTags.AQUATIC),
        BEARS(SurfaceEntityTags.BEARS);

        private final class_6862<class_1299<?>> associatedTag;

        private BattleHornTarget(class_6862<class_1299<?>> associatedTag) {
            this.associatedTag = associatedTag;
        }

        public class_6862<class_1299<?>> getAssociatedTag() {
            return this.associatedTag;
        }

        public static String getTranslation(BattleHornTarget ofTarget) {
            return "item.surface.battle_horn.targets." + ofTarget.toString().toLowerCase();
        }

        public static class_2561 appendTranslation(String replacer, String translatable, BattleHornTarget target) {
            String translated = class_2561.method_43471((String)translatable).getString();
            String translation = class_2561.method_43471((String)BattleHornTarget.getTranslation(target)).getString();
            translated = translated.replace(replacer, translation);
            return class_2561.method_43470((String)translated);
        }

        public static class_2561 appendTranslation(String replacer, String translatable, BattleHornTarget target, Object ... args) {
            String translated = class_2561.method_43469((String)translatable, (Object[])args).getString();
            String translation = class_2561.method_43471((String)BattleHornTarget.getTranslation(target)).getString();
            translated = translated.replace(replacer, translation);
            return class_2561.method_43470((String)translated);
        }

        public static BattleHornTarget ofItem(class_1792 item) {
            if (item == class_1802.field_8511) {
                return ZOMBIE;
            }
            if (item == class_1802.field_8606) {
                return SKELETON;
            }
            if (item == class_1802.field_8745) {
                return ANIMALS;
            }
            if (item == class_1802.field_8861) {
                return PEACEFUL;
            }
            if (item == class_1802.field_8687) {
                return ILLAGERS;
            }
            if (item == class_1802.field_8634) {
                return ENDER;
            }
            if (item == class_1802.field_8790) {
                return NETHER;
            }
            if (item == class_1802.field_8777) {
                return BOUNCY;
            }
            if (item == class_1802.field_8429) {
                return AQUATIC;
            }
            if (item == class_1802.field_8209) {
                return BEARS;
            }
            return null;
        }
    }
}

