/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.surface.recipe;

import com.manchick.surface.recipe.CauldronRecipeManager;
import com.manchick.surface.util.PotionEncoder;
import java.util.Arrays;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class CauldronRecipe {
    public static final CauldronRecipe EMPTY = new CauldronRecipe(class_1799.field_8037, class_1847.field_8984, class_2960.method_43902((String)"minecraft", (String)"empty"), class_1802.field_8162, 0);
    private final class_1799 stack;
    private final class_1799 secondaryStack;
    private final class_1792 output;
    private final class_1842[] potions;
    private final int brewingTime;
    private final class_2960 id;

    public CauldronRecipe(class_1799 stack, class_1842 potion, class_2960 id, class_1792 output, int brewingTime) {
        this(stack, class_1799.field_8037, potion, id, output, brewingTime);
    }

    public CauldronRecipe(class_1799 stack, class_1799 secondaryStack, class_1842 potion, class_2960 id, class_1792 output, int brewingTime) {
        this(stack, secondaryStack, new class_1842[]{potion}, id, output, brewingTime);
    }

    public CauldronRecipe(class_1799 stack, class_1799 secondaryStack, class_1842[] potions, class_2960 id, class_1792 output, int brewingTime) {
        this.stack = stack;
        this.secondaryStack = secondaryStack;
        this.potions = potions;
        this.output = output;
        this.id = id;
        this.brewingTime = brewingTime;
    }

    public static CauldronRecipe get(class_2960 identifier) {
        return CauldronRecipeManager.cauldronRecipes.getOrDefault(identifier, EMPTY);
    }

    public boolean hasSecondaryStack() {
        return this.secondaryStack != class_1799.field_8037;
    }

    @NotNull
    public class_1799 getSecondaryStack() {
        return this.secondaryStack != null ? this.secondaryStack : class_1799.field_8037;
    }

    public class_1799 getInput() {
        return this.stack;
    }

    public class_1792 getOutput() {
        return this.output;
    }

    public class_1842[] getPotions() {
        return this.potions;
    }

    public boolean isEmpty() {
        boolean bl = this.getOutput() == class_1802.field_8162;
        boolean bl2 = this.getInput() == class_1799.field_8037;
        boolean bl3 = Arrays.equals(this.getPotions(), new class_1842[]{class_1847.field_8984});
        return bl && bl2 && bl3;
    }

    public int getBrewingTime() {
        return this.brewingTime;
    }

    public boolean requiresWater() {
        if (this.potions.length > 0) {
            return this.potions[0] == class_1847.field_8991;
        }
        return false;
    }

    public class_2960 getIdentifier() {
        return this.id;
    }

    public boolean equals(Object obj) {
        CauldronRecipe recipe = (CauldronRecipe)obj;
        boolean stack = this.stack.method_7909() == recipe.stack.method_7909();
        boolean secondary = this.getSecondaryStack().method_7909() == recipe.getSecondaryStack().method_7909();
        boolean potion = this.getPotions() == recipe.getPotions();
        return stack && secondary && potion;
    }

    public String toString() {
        String str = this.potions.length == 1 ? PotionEncoder.getIdentifier(this.potions[0]) : Arrays.toString(this.potions);
        return "CauldronRecipe{stack=" + this.stack + ", secondaryStack=" + this.secondaryStack + ", output=" + this.output + ", potions=" + str + ", brewingTime=" + this.brewingTime + "}";
    }
}

