/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.surface.world.feature;

import com.manchick.surface.block.SurfaceBlocks;
import com.manchick.surface.util.BlockPalettes;
import com.manchick.surface.world.SurfaceBiomes;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_3443;
import net.minecraft.class_3481;
import net.minecraft.class_39;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6862;
import org.slf4j.Logger;

public class SpawnerFeature
extends class_3031<class_3111>
implements class_3037 {
    private static final Logger LOGGER = LogUtils.getLogger();
    Predicate<class_2680> predicate = class_3031.method_36999((class_6862)class_3481.field_33757);

    public SpawnerFeature(Codec<class_3111> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821 context) {
        int z;
        int z2;
        int y;
        int x;
        class_2338 pos = context.method_33655();
        class_2338 p = pos.method_10069(-4, -3, -4);
        class_2338 j = pos.method_10069(-3, -2, -3);
        class_2338 n = pos.method_10069(0, 1, -3);
        class_2338 s = pos.method_10069(0, 1, 3);
        class_2338 w = pos.method_10069(-3, 1, 0);
        class_2338 e = pos.method_10069(3, 1, 0);
        class_5281 world = context.method_33652();
        class_5819 random = context.method_33654();
        class_5321 key = class_1972.field_9451;
        if (world.method_23753(pos).method_40230().isPresent()) {
            key = (class_5321)world.method_23753(pos).method_40230().get();
        }
        class_2680 BRICK_STATE = this.getBrickState(world, pos);
        class_2680 WALL_STATE = class_2246.field_10252.method_9564();
        class_2680 STAIR_STATE = class_2246.field_10392.method_9564();
        class_2680 AIR = class_2246.field_10543.method_9564();
        if (!this.check(random, pos, world)) {
            return false;
        }
        class_2680[] TO_AVOID = new class_2680[]{class_2246.field_10260.method_9564(), BRICK_STATE, STAIR_STATE, class_2246.field_10034.method_9564(), WALL_STATE, class_2246.field_28680.method_9564(), class_2246.field_23985.method_9564()};
        class_2680[] TO_AVOID_NO_BRICKS = new class_2680[]{class_2246.field_10260.method_9564(), STAIR_STATE, class_2246.field_10034.method_9564(), WALL_STATE, class_2246.field_28680.method_9564(), class_2246.field_23985.method_9564()};
        this.method_36998(world, pos, class_2246.field_10260.method_9564(), this.predicate);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof class_2636) {
            class_2636 mobSpawnerBlockEntity = (class_2636)blockEntity;
            mobSpawnerBlockEntity.method_46408(this.getMobSpawnerEntity(world, pos, random), random);
        } else {
            LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()});
        }
        for (x = 0; x < 9; ++x) {
            for (y = 0; y < 9; ++y) {
                for (z2 = 0; z2 < 9; ++z2) {
                    if (!world.method_8320(p.method_10069(x, y, z2)).method_26212((class_1922)world, p.method_10069(x, y, z2)) || world.method_8320(p.method_10069(x, y, z2)).method_27852(class_2246.field_10260)) continue;
                    world.method_8652(p.method_10069(x, y, z2), BlockPalettes.getRandomEntry((class_5321<class_1959>)key, random), 3);
                }
            }
        }
        for (x = 0; x < 7; ++x) {
            for (z = 0; z < 7; ++z) {
                if (!world.method_8320(j.method_10069(x, 6, z)).method_26212((class_1922)world, j.method_10069(x, 6, z)) || world.method_8320(j.method_10069(x, 6, z)).method_27852(class_2246.field_10260)) continue;
                world.method_8652(j.method_10069(x, 6, z), BRICK_STATE, 3);
            }
        }
        for (int y2 = 0; y2 < 7; ++y2) {
            for (int x2 = 0; x2 < 7; x2 += 6) {
                for (z2 = 0; z2 < 7; z2 += 6) {
                    if (!world.method_8320(j.method_10069(x2, y2, z2)).method_26212((class_1922)world, j.method_10069(x2, y2, z2)) || world.method_8320(j.method_10069(x2, y2, z2)).method_27852(class_2246.field_10260)) continue;
                    world.method_8652(j.method_10069(x2, y2, z2), BRICK_STATE, 3);
                }
            }
        }
        this.placeArch(world, n, class_2350.field_11043);
        this.placeArch(world, s, class_2350.field_11035);
        this.placeArch(world, w, class_2350.field_11039);
        this.placeArch(world, e, class_2350.field_11034);
        for (x = 0; x < 5; ++x) {
            for (z = 0; z < 5; ++z) {
                if (!world.method_8320(j.method_10069(x + 1, 6, z + 1)).method_26212((class_1922)world, j.method_10069(x + 1, 6, z + 1)) || BlockPalettes.isIn(world, j.method_10069(x + 1, 6, z + 1), TO_AVOID_NO_BRICKS)) continue;
                world.method_8652(j.method_10069(x + 1, 6, z + 1), AIR, 3);
            }
        }
        world.method_8652(n.method_10069(-2, 3, 1), BRICK_STATE, 3);
        world.method_8652(s.method_10069(-2, 3, -1), BRICK_STATE, 3);
        world.method_8652(n.method_10069(2, 3, 1), BRICK_STATE, 3);
        world.method_8652(s.method_10069(2, 3, -1), BRICK_STATE, 3);
        world.method_8652(w.method_10069(1, 3, 2), BRICK_STATE, 3);
        world.method_8652(w.method_10069(1, 3, -2), BRICK_STATE, 3);
        world.method_8652(e.method_10069(-1, 3, 2), BRICK_STATE, 3);
        world.method_8652(e.method_10069(-1, 3, -2), BRICK_STATE, 3);
        for (x = 0; x < 7; ++x) {
            for (y = 0; y < 7; ++y) {
                for (z2 = 0; z2 < 7; ++z2) {
                    if (!world.method_8320(j.method_10069(x, y, z2)).method_26212((class_1922)world, j.method_10069(x, y, z2)) || BlockPalettes.isIn(world, j.method_10069(x, y, z2), TO_AVOID)) continue;
                    world.method_8652(j.method_10069(x, y, z2), AIR, 3);
                }
            }
        }
        this.placeChain(world, pos);
        this.placeChests(world, pos, random);
        for (x = 0; x < 7; ++x) {
            for (z = 0; z < 7; ++z) {
                world.method_8652(j.method_10069(x, -1, z), BlockPalettes.getRandomEntry((class_5321<class_1959>)key, random), 3);
                BlockPalettes.applyMoss(world, j.method_10069(x, -1, z), 30, random, true);
            }
        }
        return true;
    }

    private class_1299<?> getMobSpawnerEntity(class_5281 world, class_2338 pos, class_5819 random) {
        return (class_1299)class_156.method_27173((Object[])this.getSpawnerEntities(world, pos), (class_5819)random);
    }

    private void placeChests(class_5281 world, class_2338 pos, class_5819 random) {
        for (int i = 0; i < 2; ++i) {
            int chestPos = random.method_43048(4) + 1;
            class_2338 spawnPos = switch (chestPos) {
                case 2 -> pos.method_10069(0, -2, 3);
                case 3 -> pos.method_10069(-3, -2, 0);
                case 4 -> pos.method_10069(3, -2, 0);
                default -> pos.method_10069(0, -2, -3);
            };
            this.method_36998(world, spawnPos, class_3443.method_14916((class_1922)world, (class_2338)spawnPos, (class_2680)class_2246.field_10034.method_9564()), this.predicate);
            class_2621.method_11287((class_1922)world, (class_5819)random, (class_2338)spawnPos, (class_2960)class_39.field_356);
        }
    }

    private boolean check(class_5819 random, class_2338 pos, class_5281 world) {
        int c = random.method_43048(2) + 2;
        int k = -c - 1;
        int l = c + 1;
        int o = random.method_43048(2) + 2;
        int m = -o - 1;
        int q = o + 1;
        int r = 0;
        for (int i = k; i <= l; ++i) {
            for (int t = -1; t <= 4; ++t) {
                for (int u = m; u <= q; ++u) {
                    class_2338 blockPos2 = pos.method_10069(i, t, u);
                    boolean bl = world.method_8320(blockPos2).method_51367();
                    if (t == -1 && !bl) {
                        return false;
                    }
                    if (t == 4 && !bl) {
                        return false;
                    }
                    if (i != k && i != l && u != m && u != q || t != 0 || !world.method_22347(blockPos2) || !world.method_22347(blockPos2.method_10084())) continue;
                    ++r;
                }
            }
        }
        return r >= 1 && r <= 5;
    }

    private void placeArch(class_5281 world, class_2338 pos, class_2350 dir) {
        int i;
        class_2680 WALL_STATE = this.getWallState(world, pos);
        class_2680 STAIRS_STATE = this.getStairsState(world, pos);
        class_2680 BRICKS_STATE = this.getBrickState(world, pos);
        if ((switch (dir) {
            case class_2350.field_11035 -> {
                i = 2;
                yield 1;
            }
            case class_2350.field_11034 -> {
                i = 3;
                yield 2;
            }
            case class_2350.field_11039 -> {
                i = 4;
                yield 2;
            }
            default -> {
                i = 1;
                yield 1;
            }
        }) == 1) {
            if (world.method_8320(pos.method_10069(-2, 0, 0)).method_26212((class_1922)world, pos.method_10069(-2, 0, 0))) {
                world.method_8652(pos.method_10069(-2, 0, 0), WALL_STATE, 3);
            }
            if (world.method_8320(pos.method_10069(2, 0, 0)).method_26212((class_1922)world, pos.method_10069(2, 0, 0))) {
                world.method_8652(pos.method_10069(2, 0, 0), WALL_STATE, 3);
            }
            if (world.method_8320(pos.method_10069(-2, 1, 0)).method_26212((class_1922)world, pos.method_10069(-2, 1, 0))) {
                world.method_8652(pos.method_10069(-2, 1, 0), BRICKS_STATE, 3);
            }
            if (world.method_8320(pos.method_10069(2, 1, 0)).method_26212((class_1922)world, pos.method_10069(2, 1, 0))) {
                world.method_8652(pos.method_10069(2, 1, 0), BRICKS_STATE, 3);
            }
            if (world.method_8320(pos.method_10069(-2, 2, 0)).method_26212((class_1922)world, pos.method_10069(-2, 2, 0))) {
                world.method_8652(pos.method_10069(-2, 2, 0), BRICKS_STATE, 3);
            }
            if (world.method_8320(pos.method_10069(2, 2, 0)).method_26212((class_1922)world, pos.method_10069(2, 2, 0))) {
                world.method_8652(pos.method_10069(2, 2, 0), BRICKS_STATE, 3);
            }
            if (world.method_8320(pos.method_10069(-1, 2, 0)).method_26212((class_1922)world, pos.method_10069(-1, 2, 0))) {
                world.method_8652(pos.method_10069(-1, 2, 0), (class_2680)((class_2680)STAIRS_STATE.method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11039)).method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12619), 3);
            }
            if (world.method_8320(pos.method_10069(1, 2, 0)).method_26212((class_1922)world, pos.method_10069(1, 2, 0))) {
                world.method_8652(pos.method_10069(1, 2, 0), (class_2680)((class_2680)STAIRS_STATE.method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11034)).method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12619), 3);
            }
            if (i == 1) {
                if (world.method_8320(pos.method_10069(-2, 2, 1)).method_26212((class_1922)world, pos.method_10069(-2, 2, 1))) {
                    world.method_8652(pos.method_10069(-2, 2, 1), WALL_STATE, 3);
                }
                if (world.method_8320(pos.method_10069(2, 2, 1)).method_26212((class_1922)world, pos.method_10069(2, 2, 1))) {
                    world.method_8652(pos.method_10069(2, 2, 1), WALL_STATE, 3);
                }
                if (world.method_8320(pos.method_10069(-2, 3, 1)).method_26212((class_1922)world, pos.method_10069(-2, 3, 1))) {
                    world.method_8652(pos.method_10069(-2, 3, 1), BRICKS_STATE, 3);
                }
                if (world.method_8320(pos.method_10069(2, 3, 1)).method_26212((class_1922)world, pos.method_10069(2, 3, 1))) {
                    world.method_8652(pos.method_10069(2, 3, 1), BRICKS_STATE, 3);
                }
                if (world.method_8320(pos.method_10069(1, 3, 1)).method_26212((class_1922)world, pos.method_10069(1, 3, 1))) {
                    world.method_8652(pos.method_10069(1, 3, 1), (class_2680)((class_2680)STAIRS_STATE.method_11657((class_2769)class_2741.field_12481, (Comparable)dir)).method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12619), 3);
                }
                if (world.method_8320(pos.method_10069(-1, 3, 1)).method_26212((class_1922)world, pos.method_10069(-1, 3, 1))) {
                    world.method_8652(pos.method_10069(-1, 3, 1), (class_2680)((class_2680)STAIRS_STATE.method_11657((class_2769)class_2741.field_12481, (Comparable)dir)).method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12619), 3);
                }
            } else {
                if (world.method_8320(pos.method_10069(-2, 2, -1)).method_26212((class_1922)world, pos.method_10069(-2, 2, -1))) {
                    world.method_8652(pos.method_10069(-2, 2, -1), WALL_STATE, 3);
                }
                if (world.method_8320(pos.method_10069(2, 2, -1)).method_26212((class_1922)world, pos.method_10069(2, 2, -1))) {
                    world.method_8652(pos.method_10069(2, 2, -1), WALL_STATE, 3);
                }
                if (world.method_8320(pos.method_10069(-2, 3, -1)).method_26212((class_1922)world, pos.method_10069(-2, 3, -1))) {
                    world.method_8652(pos.method_10069(-2, 3, -1), BRICKS_STATE, 3);
                }
                if (world.method_8320(pos.method_10069(2, 3, -1)).method_26212((class_1922)world, pos.method_10069(2, 3, -1))) {
                    world.method_8652(pos.method_10069(2, 3, -1), BRICKS_STATE, 3);
                }
                if (world.method_8320(pos.method_10069(1, 3, -1)).method_26212((class_1922)world, pos.method_10069(1, 3, -1))) {
                    world.method_8652(pos.method_10069(1, 3, -1), (class_2680)((class_2680)STAIRS_STATE.method_11657((class_2769)class_2741.field_12481, (Comparable)dir)).method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12619), 3);
                }
                if (world.method_8320(pos.method_10069(-1, 3, -1)).method_26212((class_1922)world, pos.method_10069(-1, 3, -1))) {
                    world.method_8652(pos.method_10069(-1, 3, -1), (class_2680)((class_2680)STAIRS_STATE.method_11657((class_2769)class_2741.field_12481, (Comparable)dir)).method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12619), 3);
                }
            }
        } else {
            if (world.method_8320(pos.method_10069(0, 0, -2)).method_26212((class_1922)world, pos.method_10069(0, 0, -2))) {
                world.method_8652(pos.method_10069(0, 0, -2), WALL_STATE, 3);
            }
            if (world.method_8320(pos.method_10069(0, 0, 2)).method_26212((class_1922)world, pos.method_10069(0, 0, 2))) {
                world.method_8652(pos.method_10069(0, 0, 2), WALL_STATE, 3);
            }
            if (world.method_8320(pos.method_10069(0, 1, -2)).method_26212((class_1922)world, pos.method_10069(0, 1, -2))) {
                world.method_8652(pos.method_10069(0, 1, -2), BRICKS_STATE, 3);
            }
            if (world.method_8320(pos.method_10069(0, 1, 2)).method_26212((class_1922)world, pos.method_10069(0, 1, 2))) {
                world.method_8652(pos.method_10069(0, 1, 2), BRICKS_STATE, 3);
            }
            if (world.method_8320(pos.method_10069(0, 2, -2)).method_26212((class_1922)world, pos.method_10069(0, 2, -2))) {
                world.method_8652(pos.method_10069(0, 2, -2), BRICKS_STATE, 3);
            }
            if (world.method_8320(pos.method_10069(0, 2, 2)).method_26212((class_1922)world, pos.method_10069(0, 2, 2))) {
                world.method_8652(pos.method_10069(0, 2, 2), BRICKS_STATE, 3);
            }
            if (world.method_8320(pos.method_10069(0, 2, -1)).method_26212((class_1922)world, pos.method_10069(0, 2, -1))) {
                world.method_8652(pos.method_10069(0, 2, -1), (class_2680)((class_2680)STAIRS_STATE.method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043)).method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12619), 3);
            }
            if (world.method_8320(pos.method_10069(0, 2, 1)).method_26212((class_1922)world, pos.method_10069(0, 2, 1))) {
                world.method_8652(pos.method_10069(0, 2, 1), (class_2680)((class_2680)STAIRS_STATE.method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11035)).method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12619), 3);
            }
            if (i == 4) {
                if (world.method_8320(pos.method_10069(1, 2, -2)).method_26212((class_1922)world, pos.method_10069(1, 2, -2))) {
                    world.method_8652(pos.method_10069(1, 2, -2), WALL_STATE, 3);
                }
                if (world.method_8320(pos.method_10069(1, 2, 2)).method_26212((class_1922)world, pos.method_10069(1, 2, 2))) {
                    world.method_8652(pos.method_10069(1, 2, 2), WALL_STATE, 3);
                }
                if (world.method_8320(pos.method_10069(1, 3, -2)).method_26212((class_1922)world, pos.method_10069(1, 3, -2))) {
                    world.method_8652(pos.method_10069(1, 3, -2), BRICKS_STATE, 3);
                }
                if (world.method_8320(pos.method_10069(1, 3, 2)).method_26212((class_1922)world, pos.method_10069(1, 3, 2))) {
                    world.method_8652(pos.method_10069(1, 3, 2), BRICKS_STATE, 3);
                }
                if (world.method_8320(pos.method_10069(1, 3, 1)).method_26212((class_1922)world, pos.method_10069(1, 3, 1))) {
                    world.method_8652(pos.method_10069(1, 3, 1), (class_2680)((class_2680)STAIRS_STATE.method_11657((class_2769)class_2741.field_12481, (Comparable)dir)).method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12619), 3);
                }
                if (world.method_8320(pos.method_10069(1, 3, -1)).method_26212((class_1922)world, pos.method_10069(1, 3, -1))) {
                    world.method_8652(pos.method_10069(1, 3, -1), (class_2680)((class_2680)STAIRS_STATE.method_11657((class_2769)class_2741.field_12481, (Comparable)dir)).method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12619), 3);
                }
            } else {
                if (world.method_8320(pos.method_10069(-1, 2, -2)).method_26212((class_1922)world, pos.method_10069(-1, 2, -2))) {
                    world.method_8652(pos.method_10069(-1, 2, -2), WALL_STATE, 3);
                }
                if (world.method_8320(pos.method_10069(-1, 2, 2)).method_26212((class_1922)world, pos.method_10069(-1, 2, 2))) {
                    world.method_8652(pos.method_10069(-1, 2, 2), WALL_STATE, 3);
                }
                if (world.method_8320(pos.method_10069(-1, 3, -2)).method_26212((class_1922)world, pos.method_10069(-1, 3, -2))) {
                    world.method_8652(pos.method_10069(-1, 3, -2), BRICKS_STATE, 3);
                }
                if (world.method_8320(pos.method_10069(-1, 3, 2)).method_26212((class_1922)world, pos.method_10069(-1, 3, 2))) {
                    world.method_8652(pos.method_10069(-1, 3, 2), BRICKS_STATE, 3);
                }
                if (world.method_8320(pos.method_10069(-1, 3, 1)).method_26212((class_1922)world, pos.method_10069(-1, 3, 1))) {
                    world.method_8652(pos.method_10069(-1, 3, 1), (class_2680)((class_2680)STAIRS_STATE.method_11657((class_2769)class_2741.field_12481, (Comparable)dir)).method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12619), 3);
                }
                if (world.method_8320(pos.method_10069(-1, 3, -1)).method_26212((class_1922)world, pos.method_10069(-1, 3, -1))) {
                    world.method_8652(pos.method_10069(-1, 3, -1), (class_2680)((class_2680)STAIRS_STATE.method_11657((class_2769)class_2741.field_12481, (Comparable)dir)).method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12619), 3);
                }
            }
        }
    }

    private void placeChain(class_5281 world, class_2338 pos) {
        class_2680 BRICK_STATE = this.getBrickState(world, pos);
        class_2680 WALL_STATE = this.getWallState(world, pos);
        class_2680 CHAIN = class_2246.field_23985.method_9564();
        world.method_8652(pos.method_10069(0, 1, 0), CHAIN, 3);
        world.method_8652(pos.method_10069(0, 2, 0), CHAIN, 3);
        world.method_8652(pos.method_10069(0, 3, 0), WALL_STATE, 3);
        world.method_8652(pos.method_10069(0, 4, 0), BRICK_STATE, 3);
        world.method_8652(pos.method_10069(0, -1, 0), CHAIN, 3);
        world.method_8652(pos.method_10069(0, -2, 0), WALL_STATE, 3);
    }

    private class_2680 getBrickState(class_5281 world, class_2338 pos) {
        if (world.method_23753(pos).method_40230().isPresent()) {
            class_5321 key = (class_5321)world.method_23753(pos).method_40230().get();
            if (key == class_1972.field_9424) {
                return SurfaceBlocks.LIMESTONE_BRICKS.method_9564();
            }
            if (key == class_1972.field_9478 || key == class_1972.field_35117 || key == class_1972.field_9454 || key == SurfaceBiomes.FROZEN_CAVES) {
                return SurfaceBlocks.ICE_BRICKS.method_9564();
            }
        }
        return class_2246.field_10056.method_9564();
    }

    private class_2680 getStairsState(class_5281 world, class_2338 pos) {
        if (world.method_23753(pos).method_40230().isPresent()) {
            class_5321 key = (class_5321)world.method_23753(pos).method_40230().get();
            if (key == class_1972.field_9424) {
                return SurfaceBlocks.LIMESTONE_BRICK_STAIRS.method_9564();
            }
            if (key == class_1972.field_9478 || key == class_1972.field_35117 || key == class_1972.field_9454 || key == SurfaceBiomes.FROZEN_CAVES) {
                return SurfaceBlocks.ICE_STAIRS.method_9564();
            }
        }
        return class_2246.field_10392.method_9564();
    }

    private class_2680 getSlabState(class_5281 world, class_2338 pos) {
        if (world.method_23753(pos).method_40230().isPresent()) {
            class_5321 key = (class_5321)world.method_23753(pos).method_40230().get();
            if (key == class_1972.field_9424) {
                return SurfaceBlocks.LIMESTONE_BRICK_SLAB.method_9564();
            }
            if (key == class_1972.field_9478 || key == class_1972.field_35117 || key == class_1972.field_9454 || key == SurfaceBiomes.FROZEN_CAVES) {
                return SurfaceBlocks.ICE_SLAB.method_9564();
            }
        }
        return class_2246.field_10131.method_9564();
    }

    private class_2680 getWallState(class_5281 world, class_2338 pos) {
        if (world.method_23753(pos).method_40230().isPresent()) {
            class_5321 key = (class_5321)world.method_23753(pos).method_40230().get();
            if (key == class_1972.field_9424) {
                return SurfaceBlocks.LIMESTONE_BRICK_WALL.method_9564();
            }
            if (key == class_1972.field_9478 || key == class_1972.field_35117 || key == class_1972.field_9454 || key == SurfaceBiomes.FROZEN_CAVES) {
                return SurfaceBlocks.ICE_WALL.method_9564();
            }
        }
        return class_2246.field_10252.method_9564();
    }

    private class_1299<?>[] getSpawnerEntities(class_5281 world, class_2338 pos) {
        if (world.method_23753(pos).method_40230().isPresent()) {
            class_5321 key = (class_5321)world.method_23753(pos).method_40230().get();
            if (key == class_1972.field_9424) {
                return new class_1299[]{class_1299.field_6137, class_1299.field_6071, class_1299.field_6071, class_1299.field_6079};
            }
            if (key == class_1972.field_9478 || key == class_1972.field_35117 || key == class_1972.field_9454 || key == SurfaceBiomes.FROZEN_CAVES) {
                return new class_1299[]{class_1299.field_6051, class_1299.field_6098, class_1299.field_6098, class_1299.field_6079};
            }
        }
        return new class_1299[]{class_1299.field_6137, class_1299.field_6051, class_1299.field_6051, class_1299.field_6079};
    }
}

