/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.surface.world.trunk;

import com.google.common.collect.Lists;
import com.manchick.surface.util.ConditionalInteger;
import com.manchick.surface.util.SurfaceUtil;
import com.manchick.surface.world.SurfaceTrunkPlacerType;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;

public class SwampTrunkPlacer
extends class_5141 {
    public static final Codec<SwampTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> SwampTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, SwampTrunkPlacer::new));
    class_2350 lastDirectionIGaveYouMyHeart;

    public SwampTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
    }

    protected class_5142<?> method_28903() {
        return SurfaceTrunkPlacerType.SWAMP_TRUNK_PLACER;
    }

    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        ArrayList list = Lists.newArrayList();
        int trunkHeight = 4;
        boolean shouldAdditionalBranchGenerate = random.method_43048(4) == 0;
        class_2338 branchPos = startPos.method_10086(trunkHeight - 1);
        for (int i = 1; i < trunkHeight; ++i) {
            this.method_35375(world, replacer, random, startPos.method_10086(i), config);
        }
        this.generateRoots(world, replacer, random, startPos.method_10074(), config);
        class_2350 smallBranchDirection = this.getRandomDirection(random);
        class_2338 smallBranchFoliagePos = this.generateBranch(world, replacer, random, branchPos.method_10093(smallBranchDirection), config, 2, new ConditionalInteger(0, 0), smallBranchDirection);
        class_2350 branchDirection = this.getRandomDirection(random);
        class_2338 branchFoliagePos = this.generateBranch(world, replacer, random, branchPos.method_10093(branchDirection), config, 2, new ConditionalInteger(random.method_43048(3) + 2, 0), branchDirection);
        list.add(new class_4647.class_5208(smallBranchFoliagePos.method_10084(), 0, false));
        list.add(new class_4647.class_5208(branchFoliagePos.method_10084(), 1, false));
        if (shouldAdditionalBranchGenerate) {
            class_2350 additionalBranchDirection = this.getRandomDirection(random);
            class_2338 additionalBranchFoliagePos = this.generateBranch(world, replacer, random, branchPos.method_10093(additionalBranchDirection), config, 2, new ConditionalInteger(random.method_43048(4) + 3, 0), smallBranchDirection);
            list.add(new class_4647.class_5208(additionalBranchFoliagePos.method_10084(), 2, false));
        }
        return list;
    }

    protected void generateRoots(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338 startPos, class_4643 config) {
        class_2338 pos;
        int y;
        double d;
        double radians;
        int i;
        int radius = 4;
        class_4656 provider = class_4651.method_38432((class_2248)class_2246.field_37546);
        for (i = 0; i <= 180; i += 5) {
            radians = Math.toRadians(i);
            d = random.method_43058();
            int x = (int)(((double)radius - d) * Math.cos(radians));
            pos = startPos.method_10069(x, y = (int)(((double)radius - d) * Math.sin(radians)), 0);
            if (!this.method_43196(world, pos)) continue;
            replacer.accept(pos, provider.method_23455(random, pos));
        }
        for (i = 0; i <= 180; i += 5) {
            radians = Math.toRadians(i);
            d = random.method_43058();
            int z = (int)(((double)radius - d) * Math.cos(radians));
            y = (int)(((double)radius - d) * Math.sin(radians));
            pos = startPos.method_10069(0, y, z);
            if (!this.method_43196(world, pos)) continue;
            replacer.accept(pos, provider.method_23455(random, pos));
        }
    }

    protected class_2338 generateBranch(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338 startPos, class_4643 config, int branchSize, ConditionalInteger additionalBranchSize, class_2350 direction) {
        int branchHeight = 2;
        class_2338 pos = startPos;
        for (int x = 0; x < branchSize; ++x) {
            int height = branchHeight + additionalBranchSize.getInteger(x);
            for (int i = 0; i < height; ++i) {
                pos = pos.method_10084();
                if (i % 2 == 0) {
                    this.generateMushrooms(world, replacer, pos, random, direction, 15);
                }
                this.method_35375(world, replacer, random, pos, config);
            }
            if (x == branchSize - 1) continue;
            pos = this.stepFurther(pos, direction);
        }
        this.method_35375(world, replacer, random, pos.method_10084(), config);
        return pos.method_10084();
    }

    protected class_2338 stepFurther(class_2338 pos, class_2350 direction) {
        switch (direction) {
            case field_11043: {
                return pos.method_10069(SurfaceUtil.floating(1), 0, -1);
            }
            case field_11035: {
                return pos.method_10069(SurfaceUtil.floating(1), 0, 1);
            }
            case field_11039: {
                return pos.method_10069(-1, 0, SurfaceUtil.floating(1));
            }
            case field_11034: {
                return pos.method_10069(1, 0, SurfaceUtil.floating(1));
            }
        }
        return pos.method_10069(SurfaceUtil.floating(1), 0, -1);
    }

    protected void generateMushrooms(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_2338 centerPos, class_5819 random, class_2350 direction, int chance) {
        class_2338 pos;
        int i = random.method_43048(2) + 1;
        class_4656 provider = i == 2 ? class_4651.method_38432((class_2248)class_2246.field_10240) : class_4651.method_38432((class_2248)class_2246.field_10580);
        int j = random.method_43048(100) + 1;
        class_2338 secondPos = pos = centerPos;
        class_2338 thirdPos = pos;
        switch (direction) {
            case field_11043: {
                pos = pos.method_10095();
                secondPos = pos.method_10069(1, 0, 0);
                thirdPos = pos.method_10069(1, 0, 1);
                break;
            }
            case field_11035: {
                pos = pos.method_10072();
                secondPos = pos.method_10069(-1, 0, 0);
                thirdPos = pos.method_10069(-1, 0, -1);
                break;
            }
            case field_11039: {
                pos = pos.method_10067();
                secondPos = pos.method_10069(0, 0, -1);
                thirdPos = pos.method_10069(1, 0, -1);
                break;
            }
            case field_11034: {
                pos = pos.method_10078();
                secondPos = pos.method_10069(0, 0, 1);
                thirdPos = pos.method_10069(-1, 0, 1);
            }
        }
        if (j <= chance) {
            this.generateStates(world, replacer, (class_4651)provider, random, pos, secondPos, thirdPos);
        }
    }

    protected void generateStates(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_4651 stateProvider, class_5819 random, class_2338 ... poses) {
        for (class_2338 pos : poses) {
            if (!this.method_43196(world, pos)) continue;
            replacer.accept(pos, stateProvider.method_23455(random, pos));
        }
    }

    protected class_2350 getRandomDirection(class_5819 random) {
        int i = random.method_43048(4) + 1;
        class_2350 direction = class_2350.field_11043;
        switch (i) {
            case 2: {
                direction = class_2350.field_11035;
                break;
            }
            case 3: {
                direction = class_2350.field_11039;
                break;
            }
            case 4: {
                direction = class_2350.field_11034;
            }
        }
        if (direction == this.lastDirectionIGaveYouMyHeart) {
            return this.getRandomDirection(random);
        }
        this.lastDirectionIGaveYouMyHeart = direction;
        return direction;
    }
}

