/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.surface;

import com.manchick.surface.SurfaceCommand;
import com.manchick.surface.SurfaceSoundEvents;
import com.manchick.surface.block.SurfaceBlocks;
import com.manchick.surface.block.entity.SurfaceBlockEntities;
import com.manchick.surface.client.gui.screen.SurfaceScreenHandlers;
import com.manchick.surface.client.particle.SurfaceParticles;
import com.manchick.surface.criterion.SurfaceCriteria;
import com.manchick.surface.effect.SurfaceStatusEffects;
import com.manchick.surface.enchantment.SurfaceEnchantments;
import com.manchick.surface.entity.SurfaceEntities;
import com.manchick.surface.entity.surface.EnchanterEntity;
import com.manchick.surface.entity.surface.GrizzlyBearEntity;
import com.manchick.surface.entity.surface.RhinoEntity;
import com.manchick.surface.entity.surface.SnailEntity;
import com.manchick.surface.entity.surface.TumbleweedEntity;
import com.manchick.surface.item.BattleTargetArgumentType;
import com.manchick.surface.item.SurfaceItemGroups;
import com.manchick.surface.item.SurfaceItems;
import com.manchick.surface.networking.SurfacePackets;
import com.manchick.surface.potion.SurfacePotions;
import com.manchick.surface.recipe.CauldronRecipeManager;
import com.manchick.surface.recipe.SurfaceRecipeSerializer;
import com.manchick.surface.util.SurfaceRegistries;
import com.manchick.surface.util.SurfaceUtil;
import com.manchick.surface.world.SurfaceFeatures;
import com.manchick.surface.world.SurfaceFoliagePlacerType;
import com.manchick.surface.world.SurfaceGameRules;
import com.manchick.surface.world.SurfaceTrunkPlacerType;
import com.manchick.surface.world.SurfaceWorldGeneration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_117;
import net.minecraft.class_125;
import net.minecraft.class_1299;
import net.minecraft.class_141;
import net.minecraft.class_159;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_5132;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_73;
import net.minecraft.class_77;
import net.minecraft.class_79;

public class Surface
implements ModInitializer {
    private static final class_2960 WITCH_LOOT_TABLE = class_1299.field_6145.method_16351();
    private static final class_2960 DUNGEON_LOOT_TABLE = new class_2960("minecraft", "chests/simple_dungeon");
    private static final class_2960 NETHER_FORTRESS_LOOT_TABLE = new class_2960("minecraft", "chests/nether_bridge");
    private static final class_2960 UNDERWATER_RUIN_LOOT_TABLE_BIG = new class_2960("minecraft", "chests/underwater_ruin_big");
    private static final class_2960 UNDERWATER_RUIN_LOOT_TABLE_SMALL = new class_2960("minecraft", "chests/underwater_ruin_small");
    private static final class_2960 PILLAGER_OUTPOST_LOOT_TABLE = new class_2960("minecraft", "chests/pillager_outpost");

    public void onInitialize() {
        FabricDefaultAttributeRegistry.register(SurfaceEntities.SNAIL, (class_5132.class_5133)SnailEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(SurfaceEntities.GRIZZLY, (class_5132.class_5133)GrizzlyBearEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(SurfaceEntities.TUMBLEWEED, (class_5132.class_5133)TumbleweedEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(SurfaceEntities.ENCHANTER, (class_5132.class_5133)EnchanterEntity.setAttributes());
        FabricDefaultAttributeRegistry.register(SurfaceEntities.RHINO, (class_5132.class_5133)RhinoEntity.setAttributes());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(new IdentifiableResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("surface", "cauldron_recipes");
            }

            public CompletableFuture<Void> method_25931(class_3302.class_4045 synchronizer, class_3300 manager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
                return new CauldronRecipeManager().method_25931(synchronizer, manager, prepareProfiler, applyProfiler, prepareExecutor, applyExecutor);
            }
        });
        SurfaceWorldGeneration.generateSurfaceWorldGen();
        SurfaceFeatures.registerFeatures();
        SurfaceTrunkPlacerType.registerTrunkPlacerTypes();
        SurfaceFoliagePlacerType.registerFoliagePlacerType();
        SurfaceParticles.registerParticles();
        SurfaceBlocks.registerBlocks();
        SurfaceBlocks.registerFlammableBlocks();
        SurfaceItems.registerItems();
        SurfacePotions.registerPotions();
        SurfacePotions.registerPotionsRecipes();
        SurfaceItemGroups.registerItemGroups();
        SurfacePackets.registerC2SPackets();
        SurfaceRecipeSerializer.registerSerializers();
        SurfaceEnchantments.registerEnchantments();
        SurfaceRegistries.registerFuels();
        SurfaceRegistries.registerVillagerTrades();
        SurfaceScreenHandlers.registerScreenHandlers();
        SurfaceStatusEffects.registerStatusEffects();
        SurfaceBlockEntities.registerBlockEntities();
        SurfaceCriteria.registerCriteria();
        SurfaceGameRules.initialize();
        SurfaceSoundEvents.registerSoundEvents();
        Surface.registerLootTableModifiers();
        ArgumentTypeRegistry.registerArgumentType((class_2960)new class_2960("surface", "target"), BattleTargetArgumentType.class, (class_2314)class_2319.method_41999(BattleTargetArgumentType::target));
        SurfaceCommand.register();
    }

    private static void registerLootTableModifiers() {
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            class_55.class_56 poolBuilder;
            if (source.isBuiltin() && WITCH_LOOT_TABLE.equals((Object)id)) {
                poolBuilder = class_55.method_347().method_351((class_79.class_80)class_77.method_411((class_1935)SurfaceItems.MANDRAKE)).method_353((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)-1.0f, (float)2.0f))).method_353((class_117.class_118)class_125.method_547((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f)));
                tableBuilder.method_336(poolBuilder);
            }
            if (source.isBuiltin() && DUNGEON_LOOT_TABLE.equals((Object)id)) {
                poolBuilder = class_55.method_347().with(Surface.createRecipeEntry(SurfaceItems.COMBAT_WITCH_RECIPE, "leather")).with(Surface.createRecipeEntry(SurfaceItems.MINING_WITCH_RECIPE, "redstone")).with(Surface.createRecipeEntry(SurfaceItems.MINING_WITCH_RECIPE, "glowstone_dust")).method_351((class_79.class_80)class_73.method_401().method_437(4));
                tableBuilder.method_336(poolBuilder);
            }
            if (source.isBuiltin() && NETHER_FORTRESS_LOOT_TABLE.equals((Object)id)) {
                poolBuilder = class_55.method_347().with(Surface.createRecipeEntry(SurfaceItems.MINING_WITCH_RECIPE, "redstone")).with(Surface.createRecipeEntry(SurfaceItems.MINING_WITCH_RECIPE, "glowstone_dust")).method_351((class_79.class_80)class_73.method_401().method_437(2));
                tableBuilder.method_336(poolBuilder);
            }
            if (source.isBuiltin() && (UNDERWATER_RUIN_LOOT_TABLE_BIG.equals((Object)id) || UNDERWATER_RUIN_LOOT_TABLE_SMALL.equals((Object)id))) {
                poolBuilder = class_55.method_347().with(Surface.createRecipeEntry(SurfaceItems.COMBAT_WITCH_RECIPE, "pufferfish")).method_351((class_79.class_80)class_73.method_401().method_437(2));
                tableBuilder.method_336(poolBuilder);
            }
            if (source.isBuiltin() && PILLAGER_OUTPOST_LOOT_TABLE.equals((Object)id)) {
                poolBuilder = class_55.method_347().with(Surface.createRecipeEntry(SurfaceItems.COMBAT_WITCH_RECIPE, "regeneration_from_rhino_horn")).method_351((class_79.class_80)class_73.method_401().method_437(1));
                tableBuilder.method_336(poolBuilder);
            }
        });
    }

    private static class_79 createRecipeEntry(class_1792 item, String recipe) {
        return class_77.method_411((class_1935)item).method_438((class_117.class_118)class_159.method_677((class_2487)SurfaceUtil.as(new class_2487(), nbtCompound -> {
            nbtCompound.method_10582("Recipe", "surface:" + recipe);
            return nbtCompound;
        }))).method_437(1).method_419();
    }
}

