/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.surface.block.entity;

import com.manchick.surface.block.entity.SurfaceBlockEntities;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_5281;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FragileIceBlockEntity
extends class_2586 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String LOOT_TABLE_NBT_KEY = "LootTable";
    private static final String LOOT_TABLE_SEED_NBT_KEY = "LootTableSeed";
    private static final String ITEM_NBT_KEY = "fragile_ice_item";
    private static final class_2960 DEFAULT_LOOT_TABLE = new class_2960("surface", "archeology/fragile_ice");
    private class_1799 item = class_1799.field_8037;
    @Nullable
    private class_2960 lootTable;
    private long lootTableSeed;

    public FragileIceBlockEntity(class_2338 pos, class_2680 state) {
        super(SurfaceBlockEntities.FRAGILE_ICE, pos, state);
        this.generateItem(this.field_11863);
    }

    public void generateItem(class_1937 world) {
        if (this.lootTable == null || world == null || world.method_8608()) {
            return;
        }
        if (world.method_8503() == null) {
            return;
        }
        this.generateLoot(world.method_8503().method_3857().getLootTable(this.lootTable), world);
    }

    public void generateItem(class_5281 world) {
        if (this.lootTable == null || world == null || world.method_8608()) {
            return;
        }
        this.generateLoot(world.method_8410().method_8503().method_3857().getLootTable(this.lootTable), world);
    }

    private void generateLoot(class_52 table, class_1937 world) {
        if (world.method_8503() == null) {
            return;
        }
        class_8567 lootContextParameterSet = new class_8567.class_8568((class_3218)world).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)this.field_11867)).method_51875(class_173.field_1179);
        ObjectArrayList loot = table.method_51879(lootContextParameterSet, this.lootTableSeed);
        this.item = switch (loot.size()) {
            case 0 -> class_1799.field_8037;
            case 1 -> (class_1799)loot.get(0);
            default -> {
                LOGGER.warn("Expected max 1 loot from loot table " + this.lootTable + " got " + loot.size());
                yield (class_1799)loot.get(0);
            }
        };
        this.lootTable = null;
        this.method_5431();
    }

    private void generateLoot(class_52 table, class_5281 world) {
        class_8567 lootContextParameterSet = new class_8567.class_8568(world.method_8410()).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)this.field_11867)).method_51875(class_173.field_1179);
        ObjectArrayList loot = table.method_51879(lootContextParameterSet, this.lootTableSeed);
        this.item = switch (loot.size()) {
            case 0 -> class_1799.field_8037;
            case 1 -> (class_1799)loot.get(0);
            default -> {
                LOGGER.warn("Expected max 1 loot from loot table " + this.lootTable + " got " + loot.size());
                yield (class_1799)loot.get(0);
            }
        };
        this.lootTable = null;
        this.method_5431();
    }

    private boolean readLootTableFromNbt(class_2487 nbt) {
        if (nbt.method_10573(LOOT_TABLE_NBT_KEY, 8)) {
            this.lootTable = new class_2960(nbt.method_10558(LOOT_TABLE_NBT_KEY));
            this.lootTableSeed = nbt.method_10537(LOOT_TABLE_SEED_NBT_KEY);
            return true;
        }
        return false;
    }

    private boolean writeLootTableToNbt(class_2487 nbt) {
        if (this.lootTable == null) {
            return false;
        }
        nbt.method_10582(LOOT_TABLE_NBT_KEY, this.lootTable.toString());
        if (this.lootTableSeed != 0L) {
            nbt.method_10544(LOOT_TABLE_SEED_NBT_KEY, this.lootTableSeed);
        }
        return true;
    }

    public class_2487 method_16887() {
        class_2487 nbtCompound = super.method_16887();
        nbtCompound.method_10566(ITEM_NBT_KEY, (class_2520)this.item.method_7953(new class_2487()));
        return nbtCompound;
    }

    public void method_11014(class_2487 nbt) {
        if (!this.readLootTableFromNbt(nbt) && nbt.method_10545(ITEM_NBT_KEY)) {
            this.item = class_1799.method_7915((class_2487)nbt.method_10562(ITEM_NBT_KEY));
        }
        this.generateItem(this.field_11863);
    }

    protected void method_11007(class_2487 nbt) {
        if (!this.writeLootTableToNbt(nbt)) {
            nbt.method_10566(ITEM_NBT_KEY, (class_2520)this.item.method_7953(new class_2487()));
        }
    }

    public void setLootTable(@Nullable class_2960 lootTable, class_5281 world) {
        this.lootTable = lootTable;
        this.generateItem(world);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_1799 getItem() {
        return this.item;
    }
}

