/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.surface.block.entity;

import com.manchick.surface.block.WitchCauldronBlock;
import com.manchick.surface.block.entity.SurfaceBlockEntities;
import com.manchick.surface.criterion.SurfaceCriteria;
import com.manchick.surface.item.SurfaceItems;
import com.manchick.surface.item.WitchRecipeItem;
import com.manchick.surface.recipe.CauldronRecipe;
import com.manchick.surface.recipe.CauldronRecipeManager;
import com.manchick.surface.util.Bundle;
import com.manchick.surface.util.PotionEncoder;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class WitchCauldronBlockEntity
extends class_2586 {
    private final PotionEncoder potionEncoder = new PotionEncoder();
    private int campfireTicks = 0;
    private int potion;

    public WitchCauldronBlockEntity(class_2338 pos, class_2680 state) {
        super(SurfaceBlockEntities.WITCH_CAULDRON, pos, state);
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10569("Potion", this.potion);
        nbt.method_10569("CampfireTicks", this.campfireTicks);
        super.method_11007(nbt);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.potion = nbt.method_10550("Potion");
        this.campfireTicks = nbt.method_10550("CampfireTicks");
    }

    @Nullable
    public Object getRenderData() {
        return this.getPotion();
    }

    public class_1842 getPotion() {
        return this.potionEncoder.getPotion(this.potion) != class_1847.field_8984 ? this.potionEncoder.getPotion(this.potion) : class_1847.field_8991;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void setPotion(class_1842 potion) {
        this.potion = this.potionEncoder.getID(potion);
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T blockEntity) {
        boolean shouldTick;
        if (!(blockEntity instanceof WitchCauldronBlockEntity)) {
            return;
        }
        WitchCauldronBlockEntity entity = (WitchCauldronBlockEntity)blockEntity;
        if (WitchCauldronBlockEntity.checkForEmpty(world, pos, state)) {
            return;
        }
        if (world.method_8608()) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        Bundle<class_1297, Bundle<class_1799, class_1799>> stacks = WitchCauldronBlockEntity.getStacks(world, pos);
        class_1297 thrower = stacks.getValue();
        class_1799 stack = stacks.getSecondaryValue().getValue();
        class_1799 secondaryStack = stacks.getSecondaryValue().getSecondaryValue();
        CauldronRecipe recipe = CauldronRecipeManager.getByInput(stack.method_7909(), secondaryStack.method_7909(), entity.getPotion());
        boolean bl = shouldTick = !stack.method_7960();
        if (!WitchCauldronBlockEntity.hasRecipe(thrower, recipe)) {
            shouldTick = false;
        }
        if (recipe.hasSecondaryStack() && secondaryStack.method_7960()) {
            shouldTick = false;
        }
        if (!shouldTick) {
            if (((Boolean)state.method_11654((class_2769)WitchCauldronBlock.IS_BOILING)).booleanValue()) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)WitchCauldronBlock.IS_BOILING, (Comparable)Boolean.valueOf(false)));
            }
            entity.campfireTicks = 0;
            if (!WitchCauldronBlockEntity.canCraft(serverWorld, pos, state, recipe)) {
                return;
            }
        } else if (entity.campfireTicks > 0 && !((Boolean)state.method_11654((class_2769)WitchCauldronBlock.IS_BOILING)).booleanValue()) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)WitchCauldronBlock.IS_BOILING, (Comparable)Boolean.valueOf(true)));
        }
        WitchCauldronBlockEntity.handleCampfireTick(entity, pos, serverWorld, recipe);
        if (!recipe.isEmpty() && entity.campfireTicks >= recipe.getBrewingTime() * 20) {
            world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 1.0f, 1.0f);
            WitchCauldronBlockEntity.incrementCriteria(thrower, recipe);
            WitchCauldronBlockEntity.handleCraft(serverWorld, pos, state, entity.getPotion(), recipe, stack, secondaryStack);
        }
    }

    private static boolean hasRecipe(class_1297 entity, CauldronRecipe recipe) {
        if (!(entity instanceof class_3222)) {
            return false;
        }
        class_3222 player = (class_3222)entity;
        return WitchRecipeItem.hasRecipe((class_1657)player, recipe);
    }

    private static void handleCampfireTick(WitchCauldronBlockEntity entity, class_2338 pos, class_3218 world, CauldronRecipe recipe) {
        boolean hasCampfireBelow = world.method_8320(pos.method_10074()).method_27852(class_2246.field_17350);
        if (hasCampfireBelow) {
            int campfireTicks;
            if ((campfireTicks = entity.campfireTicks++) < recipe.getBrewingTime() * 20) {
                // empty if block
            }
        } else if (entity.campfireTicks > 0) {
            entity.campfireTicks -= 2;
        }
    }

    private static Bundle<class_1297, Bundle<class_1799, class_1799>> getStacks(class_1937 world, class_2338 pos) {
        Bundle<class_1297, Bundle<class_1799, class_1799>> emptyBundle = new Bundle<class_1297, Bundle<class_1799, class_1799>>(null, new Bundle<class_1799, class_1799>(class_1799.field_8037, class_1799.field_8037));
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof WitchCauldronBlockEntity)) {
            return emptyBundle;
        }
        WitchCauldronBlockEntity blockEntity = (WitchCauldronBlockEntity)class_25862;
        class_1842 entityPotion = blockEntity.getPotion();
        List entities = world.method_18467(class_1542.class, new class_238(pos).method_1014(0.5));
        return switch (entities.size()) {
            case 1 -> {
                class_1297 thrower = ((class_1542)entities.get(0)).method_24921();
                class_1799 stack = ((class_1542)entities.get(0)).method_6983();
                if (CauldronRecipeManager.isRecipe(stack, class_1799.field_8037, entityPotion)) {
                    yield new Bundle<class_1297, Bundle<class_1799, class_1799>>(thrower, new Bundle<class_1799, class_1799>(stack, class_1799.field_8037));
                }
                yield emptyBundle;
            }
            case 2 -> {
                class_1799 secondStack;
                class_1297 thrower = ((class_1542)entities.get(0)).method_24921();
                class_1799 stack = ((class_1542)entities.get(0)).method_6983();
                class_1799 secondaryStack = ((class_1542)entities.get(1)).method_6983();
                int stackAge = ((class_1542)entities.get(0)).method_6985();
                int secondaryAge = ((class_1542)entities.get(1)).method_6985();
                class_1799 firstStack = Math.max(stackAge, secondaryAge) == stackAge ? stack : secondaryStack;
                class_1799 v1 = secondStack = Math.min(stackAge, secondaryAge) == stackAge ? stack : secondaryStack;
                if (CauldronRecipeManager.isRecipe(firstStack, secondStack, entityPotion)) {
                    yield new Bundle<class_1297, Bundle<class_1799, class_1799>>(thrower, new Bundle<class_1799, class_1799>(firstStack, secondStack));
                }
                if (CauldronRecipeManager.isRecipe(secondStack, firstStack, entityPotion)) {
                    yield new Bundle<class_1297, Bundle<class_1799, class_1799>>(thrower, new Bundle<class_1799, class_1799>(secondStack, firstStack));
                }
                yield emptyBundle;
            }
            default -> emptyBundle;
        };
    }

    private static boolean checkForEmpty(class_1937 world, class_2338 pos, class_2680 state) {
        boolean isEmpty = ((WitchCauldronBlock)state.method_26204()).isEmpty(state);
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof WitchCauldronBlockEntity)) {
            return false;
        }
        WitchCauldronBlockEntity entity = (WitchCauldronBlockEntity)class_25862;
        if (isEmpty) {
            if (((Boolean)state.method_11654((class_2769)WitchCauldronBlock.IS_BOILING)).booleanValue()) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)WitchCauldronBlock.IS_BOILING, (Comparable)Boolean.valueOf(false)));
            }
            entity.setPotion(class_1847.field_8984);
            entity.method_5431();
        }
        return isEmpty;
    }

    private static boolean isPresent(Object object) {
        if (object instanceof class_1799) {
            return object != class_1799.field_8037;
        }
        return object != null;
    }

    private static void incrementCriteria(class_1297 thrower, CauldronRecipe recipe) {
        if (!(thrower instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)thrower;
        SurfaceCriteria.RECIPE_TRANSMUTED.trigger(player, recipe.getIdentifier());
    }

    private static void handleCraft(class_3218 world, class_2338 pos, class_2680 state, class_1842 potion, CauldronRecipe recipe, class_1799 stack, class_1799 secondary) {
        if (recipe.isEmpty()) {
            return;
        }
        if (!WitchCauldronBlockEntity.canCraft(world, pos, state, recipe)) {
            return;
        }
        world.method_14199((class_2394)class_2398.field_11249, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, 5, 0.3, 0.3, 0.3, 0.1);
        stack.method_7934(1);
        if (WitchCauldronBlockEntity.isPresent(secondary)) {
            secondary.method_7934(1);
        }
        if (stack.method_31574(SurfaceItems.RHINO_HORN)) {
            WitchCauldronBlockEntity.handleHealing((class_1937)world, pos, potion);
        } else {
            world.method_8649((class_1297)new class_1542((class_1937)world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, new class_1799((class_1935)recipe.getOutput())));
        }
        if ((Integer)state.method_11654((class_2769)WitchCauldronBlock.LEVEL) == 1) {
            world.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)WitchCauldronBlock.LEVEL, (Comparable)Integer.valueOf(0))).method_11657((class_2769)WitchCauldronBlock.CONTENTS, (Comparable)Integer.valueOf(0)));
        } else {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)WitchCauldronBlock.LEVEL, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)WitchCauldronBlock.LEVEL) - 1)));
        }
        ((WitchCauldronBlockEntity)Objects.requireNonNull(world.method_8321((class_2338)pos))).campfireTicks = 0;
    }

    private static void handleHealing(class_1937 world, class_2338 pos, class_1842 potion) {
        List entities = world.method_18467(class_1309.class, new class_238(pos).method_1014(7.0));
        class_1291 type = ((class_1293)potion.method_8049().get(0)).method_5579();
        int duration = (int)((double)((class_1293)potion.method_8049().get(0)).method_5584() / 1.5);
        int amplifier = ((class_1293)potion.method_8049().get(0)).method_5578();
        class_1293 instance = new class_1293(type, duration, amplifier);
        for (class_1309 entity : entities) {
            entity.method_6092(instance);
        }
    }

    private static boolean canCraft(class_3218 world, class_2338 pos, class_2680 state, CauldronRecipe recipe) {
        WitchCauldronBlockEntity entity = (WitchCauldronBlockEntity)world.method_8321(pos);
        if (entity == null) {
            return false;
        }
        if ((Integer)state.method_11654((class_2769)WitchCauldronBlock.CONTENTS) == 1 && recipe.requiresWater()) {
            return true;
        }
        if ((Integer)state.method_11654((class_2769)WitchCauldronBlock.CONTENTS) == 2) {
            class_1842[] requiredPotions;
            for (class_1842 pot : requiredPotions = recipe.getPotions()) {
                if (pot != entity.getPotion()) continue;
                return true;
            }
        }
        return false;
    }
}

