/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.surface.client.gui.screen.tome.page;

import com.manchick.surface.client.gui.screen.tome.page.TomePage;
import com.manchick.surface.client.gui.screen.tome.render.AnvilRecipe;
import com.manchick.surface.client.gui.screen.tome.render.ItemPreview;
import com.manchick.surface.client.gui.screen.tome.render.ItemRecipe;
import com.manchick.surface.client.gui.screen.tome.render.ItemStackPreview;
import com.manchick.surface.util.Bundle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public class SimpleItemPage
extends TomePage {
    private final List<Bundle<ItemPreview, ItemRecipe>> displays;
    private final Optional<class_2561> text;
    private final Optional<ItemPreview> preview;
    private final Optional<AnvilRecipe> anvilRecipe;

    @SafeVarargs
    public SimpleItemPage(@Nullable TomePage parent, Optional<class_2561> text, Optional<ItemPreview> preview, Optional<AnvilRecipe> anvilRecipe, Bundle<ItemPreview, ItemRecipe> ... displays) {
        this(parent, text, preview, List.of(displays), anvilRecipe);
    }

    public SimpleItemPage(@Nullable TomePage parent, Optional<class_2561> text, Optional<ItemPreview> preview, List<Bundle<ItemPreview, ItemRecipe>> displays, Optional<AnvilRecipe> anvilRecipe) {
        super(parent, displays.size() / 2 + 1);
        this.displays = displays;
        this.text = text;
        this.preview = preview;
        this.anvilRecipe = anvilRecipe;
    }

    @Override
    public void render(class_310 client, class_332 context, int width, int height, double mouseX, double mouseY, float delta) {
        if (this.currentIndex != 0 || this.text.isEmpty() && this.displays.get(0).getSecondaryValue() != null) {
            this.renderSimple(context, client, width, height, mouseX, mouseY, delta);
        } else {
            this.renderWithText(context, client, width, height, mouseX, mouseY, delta);
        }
        super.render(client, context, width, height, mouseX, mouseY, delta);
    }

    private void renderWithText(class_332 context, class_310 client, int width, int height, double mouseX, double mouseY, float delta) {
        ItemPreview preview = this.displays.get(0).getValue();
        TomePage.ScreenPosition pos = this.getStartingPosition(width, height, true);
        TomePage.ScreenPosition screenPosition = this.renderItemPreview(context, client.field_1772, this.preview.orElse(preview), pos.width(), pos.height(), mouseY, mouseX, delta);
        TomePage.ScreenPosition textPos = this.renderText(context, client.field_1772, this.text.get(), screenPosition.width(), screenPosition.height(), width, height);
        if (this.displays.get(0).getSecondaryValue() != null && this.anvilRecipe.isEmpty()) {
            Bundle<ItemPreview, ItemRecipe> rightBundle = this.displays.get(0);
            TomePage.ScreenPosition rightPosition = this.getStartingPosition(width, height, false);
            TomePage.ScreenPosition rightPos = this.displays.size() > 1 ? this.renderItemPreview(context, client.field_1772, preview, rightPosition.width(), rightPosition.height(), mouseY, mouseX, delta) : new TomePage.ScreenPosition(rightPosition.width(), rightPosition.height() + 23);
            this.renderItemRecipe(context, client.field_1772, rightBundle.getSecondaryValue(), rightPos.width(), rightPos.height(), mouseX, mouseY, delta);
        }
        if (this.anvilRecipe.isPresent()) {
            this.renderAnvilRecipe(context, client.field_1772, this.anvilRecipe.get(), textPos.width(), textPos.height(), mouseX, mouseY, delta);
        }
    }

    private void renderSimple(class_332 context, class_310 client, int width, int height, double mouseX, double mouseY, float delta) {
        Bundle<ItemPreview, ItemRecipe> leftBundle = this.getBundle(true);
        Bundle<ItemPreview, ItemRecipe> rightBundle = this.getBundle(false);
        TomePage.ScreenPosition leftPosition = this.getStartingPosition(width, height, true);
        TomePage.ScreenPosition leftPos = this.renderItemPreview(context, client.field_1772, leftBundle.getValue(), leftPosition.width(), leftPosition.height(), mouseY, mouseX, delta);
        this.renderItemRecipe(context, client.field_1772, leftBundle.getSecondaryValue(), leftPos.width(), leftPos.height(), mouseX, mouseY, delta);
        if (this.displays.size() > 1 && !rightBundle.isEmpty()) {
            TomePage.ScreenPosition rightPosition = this.getStartingPosition(width, height, false);
            TomePage.ScreenPosition rightPos = this.renderItemPreview(context, client.field_1772, rightBundle.getValue(), rightPosition.width(), rightPosition.height(), mouseY, mouseX, delta);
            this.renderItemRecipe(context, client.field_1772, rightBundle.getSecondaryValue(), rightPos.width(), rightPos.height(), mouseX, mouseY, delta);
        }
    }

    private Bundle<ItemPreview, ItemRecipe> getBundle(boolean onLeft) {
        int index = (onLeft ? 2 * this.currentIndex : 2 * this.currentIndex + 1) - (this.text.isPresent() ? 1 : 0);
        if (index >= this.displays.size()) {
            return Bundle.EMPTY();
        }
        return this.displays.get(index);
    }

    public static class Builder {
        private Optional<class_2561> text;
        private final List<Bundle<ItemPreview, ItemRecipe>> displays = new ArrayList<Bundle<ItemPreview, ItemRecipe>>();
        private TomePage parent = null;
        private Optional<ItemPreview> preview = Optional.empty();
        private Optional<AnvilRecipe> anvilRecipe = Optional.empty();

        public Builder text(class_2561 text) {
            this.text = Optional.of(text);
            return this;
        }

        public Builder displays(class_1935 convertible, ItemRecipe recipe) {
            return this.displays(new ItemPreview(convertible), recipe);
        }

        public Builder anvilRecipe(AnvilRecipe recipe) {
            this.anvilRecipe = Optional.of(recipe);
            return this;
        }

        public Builder displays(ItemPreview preview, ItemRecipe recipe) {
            this.displays.add(new Bundle<ItemPreview, ItemRecipe>(preview, recipe));
            return this;
        }

        public Builder displays(class_1935 convertible) {
            return this.displays(new ItemPreview(convertible));
        }

        public Builder preview(ItemPreview preview) {
            this.preview = Optional.of(preview);
            return this;
        }

        public Builder displays(ItemPreview preview) {
            this.displays.add(new Bundle<ItemPreview, Object>(preview, null));
            return this;
        }

        public Builder parent(TomePage parent) {
            this.parent = parent;
            return this;
        }

        public SimpleItemPage build() {
            return new SimpleItemPage(this.parent, this.text, this.preview, this.displays, this.anvilRecipe);
        }

        public ItemPreview buildAsPreview() {
            ItemPreview itemPreview = this.preview.orElse(this.displays.get(0).getValue());
            if (itemPreview instanceof ItemStackPreview) {
                ItemStackPreview stackPreview = (ItemStackPreview)itemPreview;
                return new ItemStackPreview(itemPreview.orderedText, (TomePage)this.build(), stackPreview.stacks);
            }
            return new ItemPreview(itemPreview.orderedText, (TomePage)this.build(), itemPreview.convertibles);
        }
    }
}

