/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.surface.client.gui.screen.tome.page;

import com.manchick.surface.client.gui.screen.tome.SurfaceTomeScreen;
import com.manchick.surface.client.gui.screen.tome.render.AnvilRecipe;
import com.manchick.surface.client.gui.screen.tome.render.ItemPreview;
import com.manchick.surface.client.gui.screen.tome.render.ItemRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class TomePage {
    private final class_2960 ARROW_NEXT = new class_2960("surface", "textures/gui/gameplay/tome/arrow_next.png");
    private final class_2960 ARROW_NEXT_SELECTED = new class_2960("surface", "textures/gui/gameplay/tome/arrow_next_selected.png");
    private final class_2960 ARROW_PREVIOUS = new class_2960("surface", "textures/gui/gameplay/tome/arrow_previous.png");
    private final class_2960 ARROW_PREVIOUS_SELECTED = new class_2960("surface", "textures/gui/gameplay/tome/arrow_previous_selected.png");
    public TomePage parent;
    public boolean isRenderingPreviousArrow = false;
    public boolean isRenderingNextArrow = false;
    public final int pageAmount;
    public final int defaultColor = 5126702;
    public int currentIndex;

    public TomePage(@Nullable TomePage parent) {
        this(parent, 1);
    }

    public TomePage(@Nullable TomePage parent, int pageAmount) {
        this(parent, pageAmount, 0);
    }

    public TomePage(@Nullable TomePage parent, int pageAmount, int currentIndex) {
        this.parent = parent;
        this.pageAmount = pageAmount;
        this.currentIndex = currentIndex;
    }

    public void render(class_310 client, class_332 context, int width, int height, double mouseX, double mouseY, float delta) {
        if (this.parent == null) {
            if (this.currentIndex != 0) {
                this.renderPreviousArrow(context, width, height, mouseX, mouseY);
            }
        } else {
            this.renderPreviousArrow(context, width, height, mouseX, mouseY);
        }
        if (this.pageAmount > 1 && this.currentIndex != this.pageAmount - 1) {
            this.renderNextArrow(context, width, height, mouseX, mouseY);
        } else if (this.isRenderingNextArrow) {
            this.isRenderingNextArrow = false;
        }
    }

    public void renderNextArrow(class_332 context, int width, int height, double mouseX, double mouseY) {
        this.isRenderingNextArrow = true;
        int x = width / 2 + 100;
        int y = height / 2 + 68;
        class_2960 id = this.isInBounds(mouseX, mouseY, x, y, 18, 10) ? this.ARROW_NEXT_SELECTED : this.ARROW_NEXT;
        context.method_25290(id, x, y, 0.0f, 0.0f, 18, 10, 18, 10);
    }

    public void renderPreviousArrow(class_332 context, int width, int height, double mouseX, double mouseY) {
        this.isRenderingPreviousArrow = true;
        int x = width / 2 - 118;
        int y = height / 2 + 68;
        class_2960 id = this.isInBounds(mouseX, mouseY, x, y, 18, 10) ? this.ARROW_PREVIOUS_SELECTED : this.ARROW_PREVIOUS;
        context.method_25290(id, x, y, 0.0f, 0.0f, 18, 10, 18, 10);
    }

    public void renderItemRecipe(class_332 context, class_327 renderer, ItemRecipe recipe, int x, int y, double mouseX, double mouseY, float delta) {
        recipe.render(context, renderer, x + 24, y, mouseX, mouseY, delta);
    }

    public void renderAnvilRecipe(class_332 context, class_327 renderer, AnvilRecipe recipe, int x, int y, double mouseX, double mouseY, float delta) {
        recipe.render(context, renderer, x + 3, y + 4, mouseX, mouseY, delta);
    }

    public ScreenPosition renderItemPreview(class_332 context, class_327 textRenderer, ItemPreview preview, int x, int y, double mouseY, double mouseX, float delta) {
        preview.render(context, textRenderer, x, y, mouseY, mouseX, delta);
        return new ScreenPosition(x, y + 24);
    }

    public ScreenPosition renderText(class_332 context, class_327 renderer, class_2561 text, int x, int y, int screenWidth, int screenHeight) {
        String str = text.getString();
        String[] words = str.split(" ");
        List<String> orderedList = this.getAsOrderedList(words);
        int width = x;
        int height = y;
        for (String orderedStr : orderedList) {
            context.method_51433(renderer, orderedStr, width, height, 5126702, false);
            if ((height += 9) <= screenHeight / 2 + 60) continue;
            height = screenHeight / 2 - 70;
            width = screenWidth / 2 + 19;
        }
        return new ScreenPosition(width, height);
    }

    public void openNext() {
        ++this.currentIndex;
    }

    public void openParent(class_310 client) {
        if (this.currentIndex == 0) {
            client.method_1507((class_437)new SurfaceTomeScreen(this.parent));
        } else {
            --this.currentIndex;
        }
    }

    public void onMouseClicked(class_310 client, double mouseX, double mouseY, int width, int height) {
        int x;
        int y = height / 2 + 68;
        if (this.isRenderingPreviousArrow && this.isInBounds(mouseX, mouseY, x = width / 2 - 118, y, 18, 10)) {
            client.field_1724.method_5783(class_3417.field_17481, 1.0f, 1.0f);
            this.openParent(client);
        }
        if (this.isRenderingNextArrow && this.isInBounds(mouseX, mouseY, x = width / 2 + 100, y, 18, 10)) {
            client.field_1724.method_5783(class_3417.field_17481, 1.0f, 1.0f);
            this.openNext();
        }
    }

    private List<String> getAsOrderedList(String[] words) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        int lineLength = 0;
        for (String word : words) {
            if (lineLength + word.length() + 1 > 20) {
                result.add(currentLine.toString().trim());
                currentLine.setLength(0);
                lineLength = 0;
            }
            currentLine.append(word).append(" ");
            lineLength += word.length() + 1;
        }
        if (currentLine.length() > 0) {
            result.add(currentLine.toString().trim());
        }
        return result;
    }

    public boolean isInBounds(double mouseX, double mouseY, int x, int y, int width, int height) {
        boolean blY = mouseY >= (double)y && mouseY <= (double)(y + height);
        boolean blX = mouseX >= (double)x && mouseX <= (double)(x + width);
        return blY && blX;
    }

    public TomePage setParent(@Nullable TomePage parent) {
        if (parent != null) {
            this.parent = parent;
        }
        return this;
    }

    public ScreenPosition getStartingPosition(int width, int height, boolean isLeftSide) {
        int startingWidthLeft = width / 2 - 124;
        int startingWidthRight = width / 2 + 19;
        int startingHeight = height / 2 - 70;
        return new ScreenPosition(isLeftSide ? startingWidthLeft : startingWidthRight, startingHeight);
    }

    public record ScreenPosition(int width, int height) {
    }
}

