/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.surface.client.gui.screen.tome.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import net.minecraft.class_8000;
import net.minecraft.class_8001;

public class ItemRecipe {
    private final class_2960 RECIPE_GRID = new class_2960("surface", "textures/gui/gameplay/tome/recipe_grid.png");
    private final RecipeGrid grid;
    HashMap<Integer, Float> animationProgresses = new HashMap();
    HashMap<Integer, class_1935> currentConvertibles = new HashMap();
    float outputAnimationProgress = 0.0f;
    class_1935 currentOutput;

    public ItemRecipe(RecipeGrid grid) {
        this.grid = grid;
        this.currentOutput = grid.output.isEmpty() ? class_1802.field_8162 : grid.output.get(0);
        for (int i = 0; i < 9; ++i) {
            List<class_1935> list = this.grid.convertibles.get(i);
            this.setCurrentConvertible(i, list.get(0));
        }
    }

    public void render(class_332 context, class_327 textRenderer, int x, int y, double mouseX, double mouseY, float delta) {
        int i;
        context.method_25290(this.RECIPE_GRID, x, y, 0.0f, 0.0f, 58, 94, 58, 94);
        int currentY = y + 2;
        int currentX = x + 2;
        for (i = 0; i < 9; ++i) {
            List<class_1935> convertibles = this.grid.convertibles.get(i);
            if (convertibles.size() > 1) {
                this.increaseAnimationProgress(i, delta);
                if (this.getAnimationProgress(i) > 10.0f) {
                    int lastIndex = convertibles.indexOf(this.getCurrentConvertible(i)) + 1;
                    int index = lastIndex < convertibles.size() ? lastIndex : 0;
                    this.setCurrentConvertible(i, convertibles.get(index));
                    this.resetAnimationProgress(i);
                }
            }
            if (i == 3 || i == 6) {
                currentX = x + 2;
                currentY = y + (i == 3 ? 21 : 40);
            }
            class_1799 stack = new class_1799(this.getCurrentConvertible(i));
            context.method_51427(stack, currentX, currentY);
            if (this.isHoveringOver(mouseX, mouseY, currentX, currentY) && this.getCurrentConvertible(i) != class_1802.field_8162) {
                this.setTooltip(this.getCurrentConvertible(i));
            }
            currentX += 19;
        }
        if (this.grid.output.size() > 1) {
            this.outputAnimationProgress = (float)((double)this.outputAnimationProgress + 0.5 * (double)delta);
            if (this.outputAnimationProgress > 10.0f) {
                i = this.grid.output.indexOf(this.currentOutput) + 1;
                int index = i < this.grid.output.size() ? i : 0;
                this.currentOutput = this.grid.output.get(index);
                this.outputAnimationProgress = 0.0f;
            }
        }
        class_1799 stack = new class_1799(this.currentOutput, this.grid.count);
        context.method_51427(stack, x + 21, y + 76);
        context.method_51431(textRenderer, stack, x + 21, y + 76);
        if (this.isHoveringOver(mouseX, mouseY, x + 21, y + 76)) {
            this.setTooltip(this.currentOutput);
        }
    }

    private void setTooltip(class_1935 convertible) {
        class_8000 position = class_8001.field_41687;
        class_437 screen = class_310.method_1551().field_1755;
        if (screen == null) {
            return;
        }
        screen.method_47412(class_7919.method_47407((class_2561)convertible.method_8389().method_7848()), position, true);
    }

    protected boolean isHoveringOver(double mouseX, double mouseY, int startX, int startY) {
        boolean blX = mouseX >= (double)startX && mouseX <= (double)(startX + 16);
        boolean blY = mouseY >= (double)startY && mouseY <= (double)(startY + 16);
        return blX && blY;
    }

    public class_1935 getCurrentConvertible(int index) {
        return this.currentConvertibles.getOrDefault(index, (class_1935)class_1802.field_8162);
    }

    public float getAnimationProgress(int index) {
        return this.animationProgresses.getOrDefault(index, Float.valueOf(0.0f)).floatValue();
    }

    private void setCurrentConvertible(int index, class_1935 convertible) {
        this.currentConvertibles.put(index, convertible);
    }

    private void increaseAnimationProgress(int index, float delta) {
        float f = this.animationProgresses.getOrDefault(index, Float.valueOf(0.0f)).floatValue();
        f = (float)((double)f + 0.5 * (double)delta);
        this.animationProgresses.put(index, Float.valueOf(f));
    }

    private void resetAnimationProgress(int index) {
        this.animationProgresses.put(index, Float.valueOf(0.0f));
    }

    public record RecipeGrid(List<List<class_1935>> convertibles, List<class_1935> output, int count) {
        @Override
        public String toString() {
            return "RecipeGrid{convertibles=" + this.convertibles + ", output=" + this.output + ", count=" + this.count + "}";
        }

        public static class Builder {
            HashMap<Character, List<class_1935>> values = new HashMap();
            private List<class_1935> output;
            private int count = 1;
            private String pattern = "";

            public Builder pattern(String pattern) {
                if (pattern.isEmpty()) {
                    this.pattern = pattern;
                }
                this.pattern = this.pattern.concat(pattern);
                return this;
            }

            public Builder input(char c, class_1935 ... convertibles) {
                this.values.put(Character.valueOf(c), List.of(convertibles));
                return this;
            }

            public Builder output(int count, class_1935 ... convertibles) {
                this.output = List.of(convertibles);
                this.count = count;
                return this;
            }

            public RecipeGrid build() {
                ArrayList<List<class_1935>> list = new ArrayList<List<class_1935>>();
                if (this.pattern.length() != 9) {
                    throw new IllegalArgumentException("Pattern either doesn't cover all possible slots or is too big");
                }
                for (int i = 0; i < 9; ++i) {
                    char c = this.pattern.charAt(i);
                    list.add(c == ' ' ? List.of(class_1802.field_8162) : this.values.getOrDefault(Character.valueOf(c), List.of(class_1802.field_8162)));
                }
                return new RecipeGrid(list, this.output, this.count);
            }
        }
    }
}

