/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.surface.recipe;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.manchick.surface.item.WitchRecipeItem;
import com.manchick.surface.recipe.CauldronRecipe;
import com.manchick.surface.recipe.CauldronRecipeType;
import com.manchick.surface.util.SurfaceUtil;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class CauldronRecipeManager
extends class_4309 {
    public static final LinkedHashMap<class_2960, WitchRecipeItem.WitchRecipeType> defaultEntries = SurfaceUtil.as(new LinkedHashMap(), map -> {
        map.put(CauldronRecipeManager.of("spruce_sapling"), WitchRecipeItem.WitchRecipeType.FARMING);
        map.put(CauldronRecipeManager.of("birch_sapling"), WitchRecipeItem.WitchRecipeType.FARMING);
        map.put(CauldronRecipeManager.of("jungle_sapling"), WitchRecipeItem.WitchRecipeType.FARMING);
        map.put(CauldronRecipeManager.of("acacia_sapling"), WitchRecipeItem.WitchRecipeType.FARMING);
        map.put(CauldronRecipeManager.of("dark_oak_sapling"), WitchRecipeItem.WitchRecipeType.FARMING);
        map.put(CauldronRecipeManager.of("cherry_sapling"), WitchRecipeItem.WitchRecipeType.FARMING);
        map.put(CauldronRecipeManager.of("oak_sapling"), WitchRecipeItem.WitchRecipeType.FARMING);
        map.put(CauldronRecipeManager.of("wheat_seeds"), WitchRecipeItem.WitchRecipeType.FARMING);
        map.put(CauldronRecipeManager.of("glow_berries"), WitchRecipeItem.WitchRecipeType.FARMING);
        map.put(CauldronRecipeManager.of("sweet_berries"), WitchRecipeItem.WitchRecipeType.FARMING);
        map.put(CauldronRecipeManager.of("melon"), WitchRecipeItem.WitchRecipeType.FARMING);
        map.put(CauldronRecipeManager.of("pumpkin"), WitchRecipeItem.WitchRecipeType.FARMING);
        map.put(CauldronRecipeManager.of("leather_from_grizzlys_fur"), WitchRecipeItem.WitchRecipeType.FARMING);
        map.put(CauldronRecipeManager.of("grass_block"), WitchRecipeItem.WitchRecipeType.FARMING);
        map.put(CauldronRecipeManager.of("mycelium_from_brown_mushroom"), WitchRecipeItem.WitchRecipeType.FARMING);
        map.put(CauldronRecipeManager.of("mycelium_from_red_mushroom"), WitchRecipeItem.WitchRecipeType.FARMING);
        map.put(CauldronRecipeManager.of("pufferfish"), WitchRecipeItem.WitchRecipeType.COMBAT);
        map.put(CauldronRecipeManager.of("leather"), WitchRecipeItem.WitchRecipeType.COMBAT);
        map.put(CauldronRecipeManager.of("regeneration_from_rhino_horn"), WitchRecipeItem.WitchRecipeType.COMBAT);
        map.put(CauldronRecipeManager.of("mandrake_serum"), WitchRecipeItem.WitchRecipeType.COMBAT);
        map.put(CauldronRecipeManager.of("jar"), WitchRecipeItem.WitchRecipeType.COMBAT);
        map.put(CauldronRecipeManager.of("redstone"), WitchRecipeItem.WitchRecipeType.MINING);
        map.put(CauldronRecipeManager.of("glowstone_dust"), WitchRecipeItem.WitchRecipeType.MINING);
        map.put(CauldronRecipeManager.of("ice_crystal_from_ice"), WitchRecipeItem.WitchRecipeType.MINING);
        map.put(CauldronRecipeManager.of("ice_crystal_from_packed_ice"), WitchRecipeItem.WitchRecipeType.MINING);
        return map;
    });
    public static final HashMap<class_2960, Integer> FARMING_RECIPE_WEIGHTS = SurfaceUtil.as(new HashMap(), map -> {
        defaultEntries.keySet().stream().filter(identifier -> identifier.toString().contains("_sapling")).forEach(identifier -> map.put(identifier, 1));
        map.put(CauldronRecipeManager.of("wheat_seeds"), 1);
        map.put(CauldronRecipeManager.of("glow_berries"), 2);
        map.put(CauldronRecipeManager.of("sweet_berries"), 2);
        map.put(CauldronRecipeManager.of("melon"), 2);
        map.put(CauldronRecipeManager.of("pumpkin"), 2);
        map.put(CauldronRecipeManager.of("leather_from_grizzlys_fur"), 3);
        map.put(CauldronRecipeManager.of("grass_block"), 3);
        map.put(CauldronRecipeManager.of("mycelium_from_brown_mushroom"), 3);
        map.put(CauldronRecipeManager.of("mycelium_from_red_mushroom"), 3);
        return map;
    });
    public static final HashMap<class_2960, CauldronRecipe> cauldronRecipes = new HashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();

    public CauldronRecipeManager() {
        super(GSON, "cauldron_recipes");
    }

    private static class_2960 of(String str) {
        return new class_2960("surface", str);
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        for (Map.Entry<class_2960, JsonElement> recipes : map.entrySet()) {
            class_2960 identifier = recipes.getKey();
            cauldronRecipes.put(identifier, this.deserialize(identifier, class_3518.method_15295((JsonElement)recipes.getValue(), (String)"Element")));
        }
        LOGGER.info("Loaded " + cauldronRecipes.size() + " cauldron recipes");
    }

    public static CauldronRecipe fromIdentifier(class_2960 identifier) {
        return cauldronRecipes.getOrDefault(identifier, CauldronRecipe.EMPTY);
    }

    protected CauldronRecipe deserialize(class_2960 id, JsonObject json) {
        try {
            String typeField = class_3518.method_15265((JsonObject)json, (String)"type");
            JsonArray potions = class_3518.method_15261((JsonObject)json, (String)"potions");
            int brewingTime = class_3518.method_15260((JsonObject)json, (String)"duration");
            class_1792 item = class_3518.method_15288((JsonObject)json, (String)"input").method_8389();
            class_1792 output = class_3518.method_15288((JsonObject)json, (String)"output").method_8389();
            class_1842[] potionArray = this.getPotions(potions);
            CauldronRecipeType type = CauldronRecipeType.fromJsonString(typeField);
            if (type == CauldronRecipeType.DOUBLE) {
                class_1792 secondary = class_3518.method_15288((JsonObject)json, (String)"secondary").method_8389();
                this.validateRecipe(id, item, secondary, potionArray);
                return new CauldronRecipe(item.method_7854(), secondary.method_7854(), potionArray, id, output, brewingTime);
            }
            this.validateRecipe(id, item, class_1802.field_8162, potionArray);
            return new CauldronRecipe(item.method_7854(), class_1799.field_8037, potionArray, id, output, brewingTime);
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Parsing error loading cauldron recipe {}", (Object)id, (Object)e);
            return CauldronRecipe.EMPTY;
        }
    }

    private void validateRecipe(class_2960 identifier, class_1792 item, class_1792 secondaryItem, class_1842[] potions) throws JsonSyntaxException {
        List<CauldronRecipe> recipeList = this.getAsList();
        for (CauldronRecipe recipe : recipeList) {
            if (this.getIdentifier(recipe).equals((Object)identifier)) continue;
            class_1799 stack = recipe.getInput();
            class_1799 secondary = recipe.getSecondaryStack();
            List<class_1842> potionList = List.of(recipe.getPotions());
            boolean bl = stack.method_31574(item) && secondary.method_31574(secondaryItem);
            boolean bl2 = CauldronRecipeManager.containsAny(potionList, potions);
            if (!bl || !bl2) continue;
            throw new JsonSyntaxException("Found recipe duplicates in: " + identifier + " and: " + this.getIdentifier(recipe));
        }
    }

    public static boolean containsAny(List<?> list, Object[] array) {
        List<Object> arrayList = List.of(array);
        for (Object object : list) {
            if (!arrayList.contains(object)) continue;
            return true;
        }
        return false;
    }

    private class_1842[] getPotions(JsonArray potions) throws JsonSyntaxException {
        ArrayList<class_1842> potionList = new ArrayList<class_1842>();
        for (JsonElement potionElement : potions) {
            String potion = potionElement.getAsString();
            if (potion.contains(":")) {
                String[] split = potion.split(":");
                if (split.length != 2) {
                    throw new JsonSyntaxException("Unknown or invalid identifier: " + potion);
                }
                potionList.add((class_1842)class_7923.field_41179.method_10223(new class_2960(split[0], split[1])));
                continue;
            }
            potionList.add((class_1842)class_7923.field_41179.method_10223(new class_2960(potion)));
        }
        return this.toPotionArray(potionList);
    }

    private class_2960 getIdentifier(CauldronRecipe recipe) {
        for (Map.Entry<class_2960, CauldronRecipe> entry : cauldronRecipes.entrySet()) {
            if (entry.getValue() != recipe) continue;
            return entry.getKey();
        }
        return new class_2960("minecraft", "empty");
    }

    private List<CauldronRecipe> getAsList() {
        return new ArrayList<CauldronRecipe>(cauldronRecipes.values());
    }

    private class_1842[] toPotionArray(List<class_1842> potionList) {
        class_1842[] potions = new class_1842[potionList.size()];
        for (int i = 0; i < potions.length; ++i) {
            potions[i] = potionList.get(i);
        }
        return potions;
    }

    public static CauldronRecipe getByInput(class_1792 input, class_1792 secondary, class_1842 potion) {
        for (CauldronRecipe recipe : cauldronRecipes.values()) {
            List<class_1842> potionList = List.of(recipe.getPotions());
            boolean bl = recipe.getInput().method_31574(input);
            boolean bl2 = recipe.getSecondaryStack().method_31574(secondary);
            boolean bl3 = potionList.contains(potion);
            if (!bl || !bl2 || !bl3) continue;
            return recipe;
        }
        return CauldronRecipe.EMPTY;
    }

    public static boolean isRecipe(class_1799 stack, class_1799 secondary, class_1842 potion) {
        return CauldronRecipeManager.isRecipe(stack.method_7909(), secondary.method_7909(), potion);
    }

    public static boolean isRecipe(class_1792 item, class_1792 secondary, class_1842 potion) {
        for (CauldronRecipe recipe : cauldronRecipes.values()) {
            List<class_1842> potionList = List.of(recipe.getPotions());
            boolean bl = recipe.getInput().method_31574(item);
            boolean bl2 = recipe.getSecondaryStack().method_31574(secondary);
            boolean bl3 = potionList.contains(potion);
            if (!bl || !bl2 || !bl3) continue;
            return true;
        }
        return false;
    }
}

