/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.surface.world.feature;

import com.manchick.surface.util.SurfaceUtil;
import com.manchick.surface.world.feature.config.FungusFeatureConfig;
import com.mojang.serialization.Codec;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class FungusFeature
extends class_3031<FungusFeatureConfig> {
    class_2350 lastDirectionIGaveYouMyHeart;

    public FungusFeature(Codec<FungusFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<FungusFeatureConfig> context) {
        FungusFeatureConfig config = (FungusFeatureConfig)context.method_33656();
        class_5281 world = context.method_33652();
        class_2338 pos = context.method_33655();
        class_5819 random = context.method_33654();
        class_2680 stemState = config.stemProvider();
        class_2680 capState = config.capProvider();
        int height = config.height();
        height = SurfaceUtil.floating(height, 2);
        int branchChance = config.branchChance();
        class_2338 capPos = pos.method_10069(0, height, 0);
        this.generateCap(world, capPos, capState, random);
        for (int i = 0; i < height; ++i) {
            world.method_8652(pos.method_10069(0, i, 0), stemState, 3);
            if (i <= 1 || this.canPlaceBranch(world, pos.method_10069(0, i, 0), capState)) continue;
            this.generateBranch(world, pos.method_10069(0, i, 0), capState, random, branchChance);
        }
        return true;
    }

    protected void generateCap(class_5281 world, class_2338 centerPos, class_2680 capState, class_5819 random) {
        class_2338 pos = centerPos.method_10069(-1, 0, -1);
        this.generateSquare(world, pos, capState, 3, 2, 3);
        this.generateStates(world, capState, centerPos.method_10069(2, 0, 0), centerPos.method_10069(-2, 0, 0), centerPos.method_10069(0, 0, 2), centerPos.method_10069(0, 0, -2));
        this.generateSide(world, centerPos.method_10069(2, -1, 0), capState, class_2350.field_11034, 4, random);
        this.generateSide(world, centerPos.method_10069(-2, -1, 0), capState, class_2350.field_11039, 4, random);
        this.generateSide(world, centerPos.method_10069(0, -1, 2), capState, class_2350.field_11035, 4, random);
        this.generateSide(world, centerPos.method_10069(0, -1, -2), capState, class_2350.field_11043, 4, random);
    }

    protected void generateSide(class_5281 world, class_2338 topCenterPos, class_2680 capState, class_2350 generativeDirection, int capHeight, class_5819 random) {
        class_2338 pos;
        class_2338 patternPos = pos = topCenterPos;
        FungusPattern pattern = this.getRandomPattern(random);
        int height = capHeight - 1;
        int length = 3;
        int width = 1;
        switch (generativeDirection) {
            case field_11043: 
            case field_11035: {
                pos = pos.method_10069(-1, -height, 0);
                patternPos = pos.method_10069(1, -1, 0);
                break;
            }
            case field_11039: 
            case field_11034: {
                pos = pos.method_10069(0, -height, -1);
                patternPos = pos.method_10069(0, -1, 1);
                length = 1;
                width = 3;
            }
        }
        this.generateSquare(world, pos, capState, length, capHeight, width);
        this.generatePattern(pattern, world, patternPos, capState, generativeDirection);
    }

    protected FungusPattern getRandomPattern(class_5819 random) {
        int i = random.method_43048(3) + 1;
        switch (i) {
            case 1: {
                return FungusPattern.SINGLE_PIN;
            }
            case 2: {
                return FungusPattern.DOUBLE_PINS;
            }
            case 3: {
                return FungusPattern.RELIEF;
            }
        }
        return FungusPattern.SINGLE_PIN;
    }

    protected boolean canPlaceBranch(class_5281 world, class_2338 pos, class_2680 capState) {
        class_2248 block = capState.method_26204();
        class_2338 minPos = pos.method_10069(-2, -1, -2);
        return SurfaceUtil.checkForBlockState(world, block, minPos, 5, 3, 5);
    }

    protected void generateBranch(class_5281 world, class_2338 centerPos, class_2680 capState, class_5819 random, int branchChance) {
        class_2338 pos;
        class_2338 secondPos = pos = centerPos;
        class_2338 thirdPos = pos;
        class_2350 direction = this.getRandomDirection(random);
        switch (direction) {
            case field_11043: {
                pos = pos.method_10095();
                secondPos = pos.method_10069(1, 0, 0);
                thirdPos = pos.method_10069(1, 0, 1);
                break;
            }
            case field_11035: {
                pos = pos.method_10072();
                secondPos = pos.method_10069(-1, 0, 0);
                thirdPos = pos.method_10069(-1, 0, -1);
                break;
            }
            case field_11039: {
                pos = pos.method_10067();
                secondPos = pos.method_10069(0, 0, -1);
                thirdPos = pos.method_10069(1, 0, -1);
                break;
            }
            case field_11034: {
                pos = pos.method_10078();
                secondPos = pos.method_10069(0, 0, 1);
                thirdPos = pos.method_10069(-1, 0, 1);
            }
        }
        this.generateStates(world, capState, pos, secondPos, thirdPos);
    }

    protected void setBlockState(class_5281 world, class_2338 pos, class_2680 state, class_5819 random, int chance) {
        boolean bl;
        int i = random.method_43048(100) + 1;
        boolean bl2 = bl = i <= chance;
        if (bl) {
            world.method_8652(pos, state, 3);
        }
    }

    protected void generatePattern(FungusPattern pattern, class_5281 world, class_2338 centerPos, class_2680 state, class_2350 generativeDirection) {
        class_2338 secondPos = centerPos;
        class_2338 thirdPos = centerPos;
        switch (generativeDirection) {
            case field_11043: 
            case field_11035: {
                secondPos = secondPos.method_10069(-1, 0, 0);
                thirdPos = thirdPos.method_10069(1, 0, 0);
                break;
            }
            case field_11039: 
            case field_11034: {
                secondPos = secondPos.method_10069(0, 0, 1);
                thirdPos = thirdPos.method_10069(0, 0, -1);
            }
        }
        if (pattern == FungusPattern.SINGLE_PIN) {
            world.method_8652(centerPos, state, 3);
        }
        if (pattern == FungusPattern.DOUBLE_PINS) {
            world.method_8652(secondPos, state, 3);
            world.method_8652(thirdPos, state, 3);
        }
        if (pattern == FungusPattern.RELIEF) {
            world.method_8652(secondPos, state, 3);
            this.generateStates(world, state, centerPos, centerPos.method_10074());
        }
    }

    protected void generateSquare(class_5281 world, class_2338 pos, class_2680 state, int length, int height, int width) {
        for (int x = 0; x < length; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < width; ++z) {
                    world.method_8652(pos.method_10069(x, y, z), state, 3);
                }
            }
        }
    }

    protected void generateStates(class_5281 world, class_2680 state, class_2338 ... poses) {
        for (class_2338 pos : poses) {
            world.method_8652(pos, state, 3);
        }
    }

    protected class_2350 getRandomDirection(class_5819 random) {
        int i = random.method_43048(4) + 1;
        class_2350 direction = class_2350.field_11043;
        switch (i) {
            case 1: {
                direction = class_2350.field_11043;
                break;
            }
            case 2: {
                direction = class_2350.field_11035;
                break;
            }
            case 3: {
                direction = class_2350.field_11039;
                break;
            }
            case 4: {
                direction = class_2350.field_11034;
            }
        }
        if (direction == this.lastDirectionIGaveYouMyHeart) {
            return this.getRandomDirection(random);
        }
        this.lastDirectionIGaveYouMyHeart = direction;
        return direction;
    }

    public static enum FungusPattern {
        DOUBLE_PINS,
        SINGLE_PIN,
        RELIEF;

    }
}

