/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.surface.world.trunk;

import com.google.common.collect.Lists;
import com.manchick.surface.world.SurfaceTrunkPlacerType;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;

public class CherryTrunkPlacer
extends class_5141 {
    class_2350 lastDirectionIGaveYouMyHeart;
    public static final Codec<CherryTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> CherryTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CherryTrunkPlacer::new));

    public CherryTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
    }

    protected class_5142<?> method_28903() {
        return SurfaceTrunkPlacerType.CHERRY_TRUNK_PLACER;
    }

    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        ArrayList list = Lists.newArrayList();
        class_2338 pos = startPos;
        this.generateTreeBase(replacer, random, pos, config);
        for (int i = 0; i < height; ++i) {
            pos = startPos.method_10086(i);
            this.method_35375(world, replacer, random, pos, config);
        }
        class_2350 firstRandomDir = this.getRandomDirection(random);
        class_2350 secondRandomDir = this.getRandomDirection(random);
        class_2338 firstFoliagePos = this.generateBranch(world, replacer, random, this.offset(pos, firstRandomDir), firstRandomDir, 4, config);
        class_2338 secondFoliagePos = this.generateBranch(world, replacer, random, this.offset(pos, secondRandomDir), secondRandomDir, 3, config);
        list.add(new class_4647.class_5208(firstFoliagePos, 1, false));
        list.add(new class_4647.class_5208(secondFoliagePos, 1, false));
        return list;
    }

    protected void generateTreeBase(BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338 pos, class_4643 config) {
        class_2350 firstDir = this.getRandomDirection(random);
        class_2350 secondDir = this.getRandomDirection(random);
        this.resetRandom();
        int i = random.method_43048(2) + 1;
        for (int j = 0; j < i; ++j) {
            replacer.accept(pos.method_10093(firstDir).method_10086(j), config.field_21288.method_23455(random, pos.method_10093(firstDir).method_10086(j)));
        }
        replacer.accept(pos.method_10093(secondDir), config.field_21288.method_23455(random, pos.method_10093(secondDir)));
    }

    protected class_2338 generateBranch(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338 pos, class_2350 direction, int size, class_4643 config) {
        int i;
        class_2338 trackingPos = pos;
        int h = size + random.method_43048(2);
        for (i = 0; i < h; ++i) {
            trackingPos = trackingPos.method_10084();
            this.method_35375(world, replacer, random, trackingPos, config);
        }
        if (random.method_43048(2) == 0) {
            trackingPos = this.offset(trackingPos, direction);
            i = random.method_43048(2) + 1;
            for (int b = 0; b < i; ++b) {
                trackingPos = trackingPos.method_10084();
                this.method_35375(world, replacer, random, trackingPos, config);
            }
        }
        return trackingPos;
    }

    protected class_2338 offset(class_2338 pos, class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11035 -> pos.method_10069(1, 0, 1);
            case class_2350.field_11039 -> pos.method_10069(-1, 0, 1);
            case class_2350.field_11034 -> pos.method_10069(1, 0, -1);
            default -> pos.method_10069(-1, 0, -1);
        };
    }

    protected void resetRandom() {
        this.lastDirectionIGaveYouMyHeart = null;
    }

    protected class_2350 getRandomDirection(class_5819 random) {
        int i = random.method_43048(4) + 1;
        class_2350 direction = switch (i) {
            case 2 -> class_2350.field_11035;
            case 3 -> class_2350.field_11039;
            case 4 -> class_2350.field_11034;
            default -> class_2350.field_11043;
        };
        if (this.lastDirectionIGaveYouMyHeart != null && direction == this.lastDirectionIGaveYouMyHeart) {
            return this.getRandomDirection(random);
        }
        this.lastDirectionIGaveYouMyHeart = direction;
        return direction;
    }
}

