/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.soulbinding.events;

import com.coldspell.soulbinding.item.ModItems;
import com.coldspell.soulbinding.item.items.BindingChains;
import com.coldspell.soulbinding.util.ConfigHandler;
import com.coldspell.soulbinding.util.SoulboundHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="soulbinding")
public class SoulbindEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void retrievalEvent(LivingDropsEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            SoulboundHelper.getOrCreateSoulboundHelper(player).retainDrops(event.getDrops());
        }
    }

    @SubscribeEvent
    public static void itemTransferEvent(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            Player oldPlayer = event.getOriginal();
            Player newPlayer = event.getEntity();
            if (SoulboundHelper.hasStoredDrops(oldPlayer)) {
                SoulboundHelper.getOrCreateSoulboundHelper(oldPlayer).transferItems(newPlayer);
            } else if (SoulboundHelper.hasStoredDrops(newPlayer)) {
                SoulboundHelper.getOrCreateSoulboundHelper(newPlayer).transferItems(newPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void anvilEvent(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (right.m_150930_((Item)ModItems.BINDING_CHAINS.get())) {
            event.setCost(((Integer)ConfigHandler.SETTINGS.anvilCost.get()).intValue());
            event.setMaterialCost(1);
            ItemStack outStack = left.m_41777_();
            CompoundTag tag = outStack.m_41784_();
            tag.m_128379_("soulbindingSoulboundItems", true);
            event.setOutput(outStack);
        }
    }

    @SubscribeEvent
    public static void tooltips(ItemTooltipEvent event) {
        CompoundTag tag;
        ItemStack itemStack = event.getItemStack();
        if (itemStack.m_41782_() && (tag = itemStack.m_41784_()).m_128471_("soulbindingSoulboundItems")) {
            if (Screen.m_96638_()) {
                event.getToolTip().add(Component.m_237115_((String)"tooltip.soulbinding.soulbound.desc").m_130940_(ChatFormatting.GOLD));
            } else {
                event.getToolTip().add(Component.m_237115_((String)"tooltip.soulbinding.soulbound").m_130940_(ChatFormatting.GOLD));
            }
        }
    }

    @SubscribeEvent
    public static void tradeEvent(VillagerTradesEvent event) {
        VillagerProfession profession = event.getType();
        if (SoulbindEvents.canSell(profession)) {
            Item costItem;
            Int2ObjectMap trades = event.getTrades();
            int level = (Integer)ConfigHandler.SETTINGS.sellLevel.get();
            int sellCost = (Integer)ConfigHandler.SETTINGS.sellCost.get();
            ItemStack buyItem = new ItemStack((ItemLike)ModItems.BINDING_CHAINS.get(), 1);
            int maxSales = (Integer)ConfigHandler.SETTINGS.sellMax.get();
            ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)((String)ConfigHandler.SETTINGS.sellItem.get()));
            if (resourceLocation != null && (costItem = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation)) != null) {
                ((List)trades.get(level)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)costItem, sellCost), buyItem, maxSales, 0, 0.0f));
            }
        }
    }

    @SubscribeEvent
    public static void wanderingTradeEvent(WandererTradesEvent event) {
        if (((Boolean)ConfigHandler.SETTINGS.wanderingTrader.get()).booleanValue()) {
            Item costItem;
            int sellCost = (Integer)ConfigHandler.SETTINGS.wanderingTradersellCost.get();
            ItemStack buyItem = new ItemStack((ItemLike)ModItems.BINDING_CHAINS.get(), 1);
            int maxSales = (Integer)ConfigHandler.SETTINGS.wanderingTradersellMax.get();
            ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)((String)ConfigHandler.SETTINGS.wanderingTradersellItem.get()));
            if (resourceLocation != null && (costItem = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation)) != null) {
                if (((Boolean)ConfigHandler.SETTINGS.wanderingTraderRare.get()).booleanValue()) {
                    event.getRareTrades().add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)costItem, sellCost), buyItem, maxSales, 0, 0.0f));
                }
                if (((Boolean)ConfigHandler.SETTINGS.wanderingTraderGeneric.get()).booleanValue()) {
                    event.getGenericTrades().add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)costItem, sellCost), buyItem, maxSales, 0, 0.0f));
                }
            }
        }
    }

    @SubscribeEvent
    public static void livingDeathEvent(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Witch && livingEntity.m_217043_().m_188501_() <= ((Double)ConfigHandler.SETTINGS.witchDropChance.get()).floatValue()) {
            SoulbindEvents.dropChains(livingEntity.m_9236_(), livingEntity.m_20183_());
        }
        if (livingEntity instanceof Evoker && livingEntity.m_217043_().m_188501_() <= ((Double)ConfigHandler.SETTINGS.evokerDropChance.get()).floatValue()) {
            SoulbindEvents.dropChains(livingEntity.m_9236_(), livingEntity.m_20183_());
        }
        if (livingEntity instanceof PiglinBrute && livingEntity.m_217043_().m_188501_() <= ((Double)ConfigHandler.SETTINGS.bruteDropChance.get()).floatValue()) {
            SoulbindEvents.dropChains(livingEntity.m_9236_(), livingEntity.m_20183_());
        }
    }

    @SubscribeEvent
    public static void livingTickEvent(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Mob) {
            ItemEntity itemEntity;
            List entityList;
            Mob mob = (Mob)entity;
            if (!(entity instanceof Animal) && !(entity instanceof WaterAnimal) && !(entity instanceof Villager) && ((Boolean)ConfigHandler.SETTINGS.bindMobs.get()).booleanValue() && !(entityList = mob.m_9236_().m_45976_(ItemEntity.class, mob.m_20191_().m_82400_(2.0))).isEmpty() && (itemEntity = (ItemEntity)entityList.get(mob.m_217043_().m_188503_(entityList.size()))).m_32055_().m_41720_() instanceof BindingChains && mob.m_21206_().m_41619_()) {
                mob.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)ModItems.BINDING_CHAINS.get()));
                mob.m_21409_(EquipmentSlot.OFFHAND, ((Double)ConfigHandler.SETTINGS.bindMobsDropChance.get()).floatValue());
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, -1, 10, false, false, false));
                itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public static boolean canSell(VillagerProfession profession) {
        if (profession == VillagerProfession.f_35586_ && ((Boolean)ConfigHandler.SETTINGS.armorer.get()).booleanValue()) {
            return true;
        }
        if (profession == VillagerProfession.f_35587_ && ((Boolean)ConfigHandler.SETTINGS.butcher.get()).booleanValue()) {
            return true;
        }
        if (profession == VillagerProfession.f_35588_ && ((Boolean)ConfigHandler.SETTINGS.cartographer.get()).booleanValue()) {
            return true;
        }
        if (profession == VillagerProfession.f_35589_ && ((Boolean)ConfigHandler.SETTINGS.cleric.get()).booleanValue()) {
            return true;
        }
        if (profession == VillagerProfession.f_35590_ && ((Boolean)ConfigHandler.SETTINGS.farmer.get()).booleanValue()) {
            return true;
        }
        if (profession == VillagerProfession.f_35591_ && ((Boolean)ConfigHandler.SETTINGS.fisherman.get()).booleanValue()) {
            return true;
        }
        if (profession == VillagerProfession.f_35592_ && ((Boolean)ConfigHandler.SETTINGS.fletcher.get()).booleanValue()) {
            return true;
        }
        if (profession == VillagerProfession.f_35593_ && ((Boolean)ConfigHandler.SETTINGS.leatherworker.get()).booleanValue()) {
            return true;
        }
        if (profession == VillagerProfession.f_35595_ && ((Boolean)ConfigHandler.SETTINGS.mason.get()).booleanValue()) {
            return true;
        }
        if (profession == VillagerProfession.f_35586_ && ((Boolean)ConfigHandler.SETTINGS.armorer.get()).booleanValue()) {
            return true;
        }
        if (profession == VillagerProfession.f_35597_ && ((Boolean)ConfigHandler.SETTINGS.shepherd.get()).booleanValue()) {
            return true;
        }
        if (profession == VillagerProfession.f_35598_ && ((Boolean)ConfigHandler.SETTINGS.toolsmith.get()).booleanValue()) {
            return true;
        }
        return profession == VillagerProfession.f_35599_ && (Boolean)ConfigHandler.SETTINGS.weaponsmith.get() != false;
    }

    public static void dropChains(Level level, BlockPos pos) {
        if (!level.f_46443_) {
            ItemEntity drop = new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + 0.5f), new ItemStack((ItemLike)ModItems.BINDING_CHAINS.get()));
            level.m_7967_((Entity)drop);
        }
    }
}

