/*
 * Decompiled with CFR 0.152.
 */
package com.coldspell.soulbinding.util;

import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigHandler$Settings {
    public final ForgeConfigSpec.BooleanValue armorer;
    public final ForgeConfigSpec.BooleanValue butcher;
    public final ForgeConfigSpec.BooleanValue cartographer;
    public final ForgeConfigSpec.BooleanValue cleric;
    public final ForgeConfigSpec.BooleanValue farmer;
    public final ForgeConfigSpec.BooleanValue fisherman;
    public final ForgeConfigSpec.BooleanValue fletcher;
    public final ForgeConfigSpec.BooleanValue leatherworker;
    public final ForgeConfigSpec.BooleanValue librarian;
    public final ForgeConfigSpec.BooleanValue mason;
    public final ForgeConfigSpec.BooleanValue shepherd;
    public final ForgeConfigSpec.BooleanValue toolsmith;
    public final ForgeConfigSpec.BooleanValue weaponsmith;
    public final ForgeConfigSpec.IntValue sellLevel;
    public final ForgeConfigSpec.IntValue sellMax;
    public final ForgeConfigSpec.ConfigValue<String> sellItem;
    public final ForgeConfigSpec.IntValue sellCost;
    public final ForgeConfigSpec.BooleanValue wanderingTrader;
    public final ForgeConfigSpec.BooleanValue wanderingTraderRare;
    public final ForgeConfigSpec.BooleanValue wanderingTraderGeneric;
    public final ForgeConfigSpec.IntValue wanderingTradersellMax;
    public final ForgeConfigSpec.ConfigValue<String> wanderingTradersellItem;
    public final ForgeConfigSpec.IntValue wanderingTradersellCost;
    public final ForgeConfigSpec.IntValue anvilCost;
    public final ForgeConfigSpec.DoubleValue witchDropChance;
    public final ForgeConfigSpec.DoubleValue evokerDropChance;
    public final ForgeConfigSpec.DoubleValue bruteDropChance;
    public final ForgeConfigSpec.BooleanValue bindMobs;
    public final ForgeConfigSpec.DoubleValue bindMobsDropChance;
    public final ForgeConfigSpec.BooleanValue piglinCurrency;
    public final ForgeConfigSpec.BooleanValue enchantedEffect;

    ConfigHandler$Settings(ForgeConfigSpec.Builder builder) {
        builder.push("Professions that can sell Binding Chains");
        this.armorer = builder.define("Armorer", false);
        this.butcher = builder.define("Butcher", false);
        this.cartographer = builder.define("Cartographer", false);
        this.cleric = builder.define("Cleric", true);
        this.farmer = builder.define("Farmer", false);
        this.fisherman = builder.define("Fisherman", false);
        this.fletcher = builder.define("Fletcher", false);
        this.leatherworker = builder.define("Leatherworker", false);
        this.librarian = builder.define("Librarian", false);
        this.mason = builder.define("Mason", false);
        this.shepherd = builder.define("Shepherd", false);
        this.toolsmith = builder.define("Toolsmith", false);
        this.weaponsmith = builder.define("Weaponsmith", false);
        builder.pop();
        builder.push("Profession Settings");
        this.sellLevel = builder.defineInRange("Profession Level needed to sell Binding Chains", 1, 0, 5);
        this.sellMax = builder.defineInRange("Max Binding Chains that a Villager can sell per day", 10, 0, 999999);
        builder.comment("Item Needed must be lowercase and spelt correctly.  If not, the Binding Chains WILL NOT appear in trades.");
        this.sellItem = builder.define("Item needed for Trade", (Object)"minecraft:emerald");
        this.sellCost = builder.defineInRange("Amount of Trade Items Needed", 16, 0, 64);
        builder.pop();
        builder.push("Wandering Trader Settings");
        this.wanderingTrader = builder.define("Wandering Trader can Sell Binding Chains", true);
        builder.comment("The Wandering Trader randomly picks a few trades from the Generic Trade List and a single trade from Rare List.");
        this.wanderingTraderRare = builder.define("Binding Chains are in the Rare List", true);
        this.wanderingTraderGeneric = builder.define("Binding Chains are in the Generic List", false);
        this.wanderingTradersellMax = builder.defineInRange("Max Binding Chains that the Trader can sell", 3, 0, 999999);
        builder.comment("Item Needed must be lowercase and spelt correctly.  If not, the Binding Chains WILL NOT appear in trades.");
        this.wanderingTradersellItem = builder.define("Item needed for Trade", (Object)"minecraft:emerald");
        this.wanderingTradersellCost = builder.defineInRange("Amount of Trade Items Needed", 16, 0, 64);
        builder.pop();
        builder.push("Anvil Settings");
        builder.comment("The way that the Anvil is coded requires at least 1 Experience Level to successfully alter an item outside of Creative Mode!");
        this.anvilCost = builder.defineInRange("Experience Levels Needed to Attach Binding Chains to an Item", 1, 1, 999999);
        builder.pop();
        builder.push("Drop Settings");
        builder.comment("Chances are set as decimals.  1.0 is the same as 100%, 0.01 is the same as 1%");
        this.witchDropChance = builder.defineInRange("Chance for the Witch to drop Binding Chains", 0.02, 0.0, 1.0);
        this.evokerDropChance = builder.defineInRange("Chance for the Evoker to drop Binding Chains", 0.15, 0.0, 1.0);
        this.bruteDropChance = builder.defineInRange("Chance for the Piglin Brute to drop Binding Chains", 0.15, 0.0, 1.0);
        builder.pop();
        builder.push("Misc Settings");
        this.bindMobs = builder.define("Binding Chains will Bind and Greatly SLOW Mobs when tossed to them", true);
        builder.comment("Chances are set as decimals.  1.0 is the same as 100%, 0.01 is the same as 1%");
        this.bindMobsDropChance = builder.defineInRange("Chance for the Bound Mob to drop Binding Chains when killed", 1.0, 0.0, 1.0);
        this.piglinCurrency = builder.define("Binding Chains can be used as Piglin Currency", true);
        this.enchantedEffect = builder.define("The Binding Chains ICON has a Foil Effect making it shimmer as if it is enchanted", true);
        builder.pop();
    }
}

