/*
 * Decompiled with CFR 0.152.
 */
package roughly_mod.block;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class CaltropBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty DIRECTION = BlockStateProperties.field_208155_H;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public CaltropBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151646_E).func_200946_b().func_200947_a(SoundType.field_185852_e).func_200942_a());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DIRECTION, (Comparable)Direction.UP)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DIRECTION, WATERLOGGED});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Boolean fluid = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        Direction direction = context.func_196000_l();
        BlockState blockstate = (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)DIRECTION, (Comparable)direction)).func_206870_a((Property)WATERLOGGED, (Comparable)fluid);
        if (blockstate.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) {
            return blockstate;
        }
        return null;
    }

    @ParametersAreNonnullByDefault
    public boolean func_196260_a(BlockState blockState, IWorldReader reader, BlockPos pos) {
        return super.func_196260_a(blockState, reader, pos);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld world, BlockPos pos, BlockPos pos2) {
        if (((Boolean)blockState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(blockState, direction, blockState2, world, pos, pos2);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    @ParametersAreNonnullByDefault
    public void func_196262_a(BlockState blockState, World world, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity && (blockState.func_177229_b((Property)DIRECTION) == Direction.DOWN && !((LivingEntity)entity).func_190630_a(EquipmentSlotType.HEAD) && entity.func_226278_cu_() - (double)pos.func_177956_o() <= -1.0 || blockState.func_177229_b((Property)DIRECTION) != Direction.DOWN && blockState.func_177229_b((Property)DIRECTION) != Direction.UP && (!((LivingEntity)entity).func_190630_a(EquipmentSlotType.HEAD) && entity.func_226278_cu_() - (double)pos.func_177956_o() <= -1.5 || !((LivingEntity)entity).func_190630_a(EquipmentSlotType.CHEST) && entity.func_226278_cu_() - (double)pos.func_177956_o() <= -0.5 || !((LivingEntity)entity).func_190630_a(EquipmentSlotType.LEGS) && entity.func_226278_cu_() - (double)pos.func_177956_o() >= -0.5) || blockState.func_177229_b((Property)DIRECTION) == Direction.UP && !((LivingEntity)entity).func_190630_a(EquipmentSlotType.FEET) && entity.func_226278_cu_() - (double)pos.func_177956_o() >= 0.0)) {
            entity.func_213295_a(blockState, new Vector3d(0.8, 0.75, 0.8));
            if (!(world.field_72995_K || entity.field_70142_S == entity.func_226277_ct_() && entity.field_70136_U == entity.func_226281_cx_())) {
                double d0 = Math.abs(entity.func_226277_ct_() - entity.field_70142_S);
                double d1 = Math.abs(entity.func_226281_cx_() - entity.field_70136_U);
                if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                    entity.func_70097_a(DamageSource.field_76377_j, 1.0f);
                }
            }
        }
    }

    @Nonnull
    public FluidState func_204507_t(BlockState blockState) {
        return (Boolean)blockState.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(blockState);
    }

    @ParametersAreNonnullByDefault
    public boolean func_204510_a(IBlockReader reader, BlockPos pos, BlockState blockState, Fluid fluid) {
        return super.func_204510_a(reader, pos, blockState, fluid);
    }

    @ParametersAreNonnullByDefault
    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState blockState, FluidState fluidState) {
        return super.func_204509_a(world, pos, blockState, fluidState);
    }

    @ParametersAreNonnullByDefault
    public boolean func_196266_a(BlockState blockState, IBlockReader reader, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return reader.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }
}

