/*
 * Decompiled with CFR 0.152.
 */
package roughly_mod.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ClimbingRopeBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty DIRECTION = BlockStateProperties.field_208155_H;
    public static final IntegerProperty DISTANCE = BlockStateProperties.field_208514_aa;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public ClimbingRopeBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_197656_x).func_200948_a(0.5f, 6.0f).func_200947_a(SoundType.field_185848_a).func_200942_a());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DIRECTION, (Comparable)Direction.UP)).func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(1))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DIRECTION, DISTANCE, WATERLOGGED});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Boolean fluid = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        Direction direction = context.func_196000_l();
        BlockState blockstate = (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)DIRECTION, (Comparable)direction)).func_206870_a((Property)WATERLOGGED, (Comparable)fluid);
        if (blockstate.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) {
            return blockstate;
        }
        return null;
    }

    public boolean func_196260_a(BlockState blockState, IWorldReader reader, BlockPos pos) {
        boolean full = reader.func_180495_p(pos.func_177972_a(((Direction)blockState.func_177229_b((Property)DIRECTION)).func_176734_d())).func_224755_d((IBlockReader)reader, pos.func_177972_a(((Direction)blockState.func_177229_b((Property)DIRECTION)).func_176734_d()), (Direction)blockState.func_177229_b((Property)DIRECTION));
        return (Integer)blockState.func_177229_b((Property)DISTANCE) == 2 && blockState.func_177229_b((Property)DIRECTION) == Direction.UP || ((Integer)blockState.func_177229_b((Property)DISTANCE) == 1 ? full && (blockState.func_177229_b((Property)DIRECTION) == Direction.UP || reader.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151579_a || reader.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h) : ((Integer)blockState.func_177229_b((Property)DISTANCE) == 2 ? full && this.getBlock() == reader.func_180495_p(pos.func_177977_b()).func_177230_c() : ((Integer)blockState.func_177229_b((Property)DISTANCE) == 3 ? this.getBlock() == reader.func_180495_p(pos.func_177984_a()).func_177230_c() && this.getBlock() == reader.func_180495_p(pos.func_177977_b()).func_177230_c() : this.getBlock() == reader.func_180495_p(pos.func_177984_a()).func_177230_c())));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld world, BlockPos pos, BlockPos pos2) {
        if (((Boolean)blockState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (!((Integer)blockState.func_177229_b((Property)DISTANCE) != 4 || world.func_180495_p(pos.func_177977_b()).func_185904_a() != Material.field_151579_a && world.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)world, pos.func_177977_b(), Direction.UP))) {
            world.func_180501_a(pos, (BlockState)blockState.func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(5)), 3);
        }
        return !this.func_196260_a(blockState, (IWorldReader)world, pos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(blockState, direction, blockState2, world, pos, pos2);
    }

    @ParametersAreNonnullByDefault
    public void func_180633_a(World world, BlockPos pos, BlockState blockState, @Nullable LivingEntity entity, ItemStack item) {
        if (!world.field_72995_K && (Integer)blockState.func_177229_b((Property)DISTANCE) == 1) {
            Material m;
            world.func_180501_a(pos, (BlockState)blockState.func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(2)), 3);
            for (int i = 0; i < pos.func_177956_o() && ((m = world.func_180495_p(pos.func_177979_c(i + 1)).func_185904_a()) == Material.field_151579_a || m == Material.field_151586_h); ++i) {
                Material m2 = world.func_180495_p(pos.func_177979_c(i + 2)).func_185904_a();
                if (m2 != Material.field_151579_a && m2 != Material.field_151586_h) {
                    world.func_180501_a(pos.func_177979_c(i + 1), (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(!world.func_180495_p(pos.func_177979_c(i + 2)).func_224755_d((IBlockReader)world, pos.func_177979_c(i + 2), Direction.UP) || m2 == Material.field_151587_i ? 5 : 4))).func_206870_a((Property)DIRECTION, blockState.func_177229_b((Property)DIRECTION))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(m == Material.field_151586_h)), 3);
                    break;
                }
                world.func_180501_a(pos.func_177979_c(i + 1), (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(i == pos.func_177956_o() - 1 ? 4 : 3))).func_206870_a((Property)DIRECTION, blockState.func_177229_b((Property)DIRECTION))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(m == Material.field_151586_h)), 3);
            }
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (Integer)blockState.func_177229_b((Property)DISTANCE) == 2 ? (blockState.func_177229_b((Property)DIRECTION) == Direction.UP ? Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0) : (blockState.func_177229_b((Property)DIRECTION) == Direction.DOWN ? Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0) : (blockState.func_177229_b((Property)DIRECTION) == Direction.NORTH ? Block.func_208617_a((double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0, (double)5.0) : (blockState.func_177229_b((Property)DIRECTION) == Direction.SOUTH ? Block.func_208617_a((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)11.0) : (blockState.func_177229_b((Property)DIRECTION) == Direction.EAST ? Block.func_208617_a((double)0.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0) : Block.func_208617_a((double)16.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0)))))) : Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    }

    @ParametersAreNonnullByDefault
    public void func_196262_a(BlockState blockState, World world, BlockPos pos, Entity entity) {
        LivingEntity en;
        if (entity instanceof LivingEntity && !(en = (LivingEntity)entity).func_233570_aj_()) {
            en.func_230245_c_(true);
            en.field_70143_R = 0.0f;
            float f = 0.15f;
            Vector3d v = en.func_213322_ci();
            double d0 = MathHelper.func_151237_a((double)v.field_72450_a, (double)(-f), (double)f);
            double d1 = MathHelper.func_151237_a((double)v.field_72449_c, (double)(-f), (double)f);
            double d2 = Math.max(v.field_72448_b, (double)(-f));
            if (d2 < 0.0 && en.func_225608_bj_() && en instanceof PlayerEntity) {
                d2 = 0.0;
                en.func_70107_b(en.field_70142_S, en.field_70137_T, en.field_70136_U);
            }
            if (d2 < 0.0) {
                en.func_213293_j(d0, d2, d1);
            }
            if (d2 != 0.0 && en.field_70173_aa % 20 == 0) {
                en.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
            }
        }
    }

    @Nonnull
    public FluidState func_204507_t(BlockState blockState) {
        return (Boolean)blockState.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(blockState);
    }

    @ParametersAreNonnullByDefault
    public boolean func_204510_a(IBlockReader reader, BlockPos pos, BlockState blockState, Fluid fluid) {
        return super.func_204510_a(reader, pos, blockState, fluid);
    }

    @ParametersAreNonnullByDefault
    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState blockState, FluidState fluidState) {
        return super.func_204509_a(world, pos, blockState, fluidState);
    }

    @ParametersAreNonnullByDefault
    public boolean func_196266_a(BlockState blockState, IBlockReader reader, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return reader.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }
}

