/*
 * Decompiled with CFR 0.152.
 */
package roughly_mod.block;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class ConveyorBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<SlabType> TYPE = BlockStateProperties.field_208145_at;
    public static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    protected static final VoxelShape BOTTOM_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP_AABB = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public ConveyorBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e).harvestTool(ToolType.PICKAXE));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(TYPE, (Comparable)SlabType.BOTTOM)).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(0))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, TYPE, POWER, POWERED});
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        SlabType slabtype = (SlabType)blockState.func_177229_b(TYPE);
        switch (slabtype) {
            case DOUBLE: {
                return VoxelShapes.func_197868_b();
            }
            case TOP: {
                return TOP_AABB;
            }
        }
        return BOTTOM_AABB;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = context.func_195991_k().func_180495_p(blockpos);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)(Screen.func_231172_r_() ? context.func_195992_f().func_176734_d() : context.func_195992_f()))).func_206870_a(TYPE, (Comparable)(blockstate.func_203425_a((Block)this) ? SlabType.DOUBLE : (!(direction == Direction.DOWN || direction != Direction.UP && context.func_221532_j().field_72448_b - (double)blockpos.func_177956_o() > 0.5) ? SlabType.BOTTOM : SlabType.TOP)))).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(this.power((IWorld)context.func_195991_k(), blockpos)))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(this.power((IWorld)context.func_195991_k(), blockpos) != 0));
    }

    @ParametersAreNonnullByDefault
    public boolean func_196260_a(BlockState blockState, IWorldReader reader, BlockPos pos) {
        return super.func_196260_a(blockState, reader, pos);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld world, BlockPos pos, BlockPos pos2) {
        if (!world.func_201670_d()) {
            int i = this.power(world, pos);
            world.func_180501_a(pos, (BlockState)((BlockState)blockState.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(i))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(i != 0)), 3);
        }
        return super.func_196271_a(blockState, direction, blockState2, world, pos, pos2);
    }

    public boolean func_196253_a(BlockState blockState, BlockItemUseContext context) {
        ItemStack itemstack = context.func_195996_i();
        SlabType slabtype = (SlabType)blockState.func_177229_b(TYPE);
        if (slabtype != SlabType.DOUBLE && itemstack.func_77973_b() == this.func_199767_j()) {
            if (context.func_196012_c()) {
                boolean flag = context.func_221532_j().field_72448_b - (double)context.func_195995_a().func_177956_o() > 0.5;
                Direction direction = context.func_196000_l();
                if (slabtype == SlabType.BOTTOM) {
                    return direction == Direction.UP || flag && direction.func_176740_k().func_176722_c();
                }
                return direction == Direction.DOWN || !flag && direction.func_176740_k().func_176722_c();
            }
            return true;
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean func_149744_f(BlockState blockState) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public int func_180656_a(BlockState blockState, IBlockReader reader, BlockPos pos, Direction direction) {
        return 0;
    }

    public int power(IWorld world, BlockPos pos) {
        int i = 0;
        for (Direction direction : Direction.values()) {
            int j;
            int n = j = world.func_180495_p(pos.func_177972_a(direction)).func_203425_a((Block)this) ? ((Integer)world.func_180495_p(pos.func_177972_a(direction)).func_177229_b((Property)POWER)).intValue() : world.func_180495_p(pos.func_177972_a(direction)).func_185911_a((IBlockReader)world, pos.func_177972_a(direction), direction);
            if (j >= 15) {
                i = 15 - (world.func_180495_p(pos.func_177972_a(direction)).func_185897_m() ? 0 : 1);
                break;
            }
            if (j <= i) continue;
            i = j - (world.func_180495_p(pos.func_177972_a(direction)).func_185897_m() ? 0 : 1);
        }
        return i;
    }

    @ParametersAreNonnullByDefault
    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        int z;
        boolean y;
        BlockState st = world.func_180495_p(pos);
        Vector3d v = entity.func_213322_ci();
        Vector3d p = entity.func_242282_l(0.0f);
        int x = st.func_177229_b((Property)FACING) == Direction.EAST ? 1 : (st.func_177229_b((Property)FACING) == Direction.WEST ? -1 : 0);
        boolean bl = y = entity instanceof ItemEntity;
        int n = st.func_177229_b((Property)FACING) == Direction.NORTH ? -1 : (z = st.func_177229_b((Property)FACING) == Direction.SOUTH ? 1 : 0);
        boolean d = st.func_177229_b(TYPE) == SlabType.DOUBLE || world.func_180495_p(st.func_177229_b(TYPE) == SlabType.BOTTOM ? pos.func_177977_b() : pos.func_177984_a()).func_203425_a((Block)this) && world.func_180495_p(st.func_177229_b(TYPE) == SlabType.BOTTOM ? pos.func_177977_b() : pos.func_177984_a()).func_177229_b(TYPE) == (st.func_177229_b(TYPE) == SlabType.BOTTOM ? SlabType.TOP : SlabType.BOTTOM);
        double pv = (double)((Integer)st.func_177229_b((Property)POWER)).intValue() * 0.02 * (double)(d ? 2 : 1);
        if ((Integer)st.func_177229_b((Property)POWER) > 0) {
            entity.func_213293_j(v.field_72450_a + (double)x * pv, v.field_72448_b, v.field_72449_c + (double)z * pv);
            if (entity instanceof ItemEntity) {
                double d2 = x != 0 ? Math.abs(v.field_72450_a) : Math.abs(v.field_72449_c);
                if (d2 < 0.02) {
                    double d3 = x != 0 ? Math.abs((double)pos.func_177958_n() + 0.5 - p.field_72450_a) : Math.abs((double)pos.func_177952_p() + 0.5 - p.field_72449_c);
                    if (d3 > 0.35) {
                        entity.func_225653_b_(p.field_72450_a, p.field_72448_b + (double)y * 0.6, p.field_72449_c);
                    }
                }
            }
        } else if (!(entity instanceof ItemEntity)) {
            entity.func_213293_j(v.field_72450_a * (Math.abs(v.field_72450_a) < 0.2 && x != 0 ? 1.75 : 1.0), v.field_72448_b, v.field_72449_c * (Math.abs(v.field_72449_c) < 0.2 && z != 0 ? 1.75 : 1.0));
        }
    }
}

