/*
 * Decompiled with CFR 0.152.
 */
package roughly_mod.block;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.fish.CodEntity;
import net.minecraft.entity.passive.fish.SalmonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TrapNetBlock
extends Block
implements IWaterLoggable {
    public static final IntegerProperty FISH_COD = BlockStateProperties.field_208171_X;
    public static final IntegerProperty FISH_SALMON = BlockStateProperties.field_208138_am;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public TrapNetBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151569_G).func_200946_b().func_200942_a().func_200944_c());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FISH_COD, (Comparable)Integer.valueOf(0))).func_206870_a((Property)FISH_SALMON, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FISH_COD, FISH_SALMON, WATERLOGGED});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Boolean fluid = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        BlockState blockstate = (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)fluid);
        if (blockstate.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) {
            return blockstate;
        }
        return null;
    }

    @ParametersAreNonnullByDefault
    public boolean func_196260_a(BlockState blockState, IWorldReader reader, BlockPos pos) {
        return super.func_196260_a(blockState, reader, pos);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    }

    @ParametersAreNonnullByDefault
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState blockState, World world, BlockPos pos, Random random) {
        if (random.nextInt(200) == 0 && (Integer)blockState.func_177229_b((Property)FISH_COD) + (Integer)blockState.func_177229_b((Property)FISH_SALMON) > 0) {
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_204327_f, SoundCategory.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            for (int i = 0; i < (Integer)blockState.func_177229_b((Property)FISH_COD) + (Integer)blockState.func_177229_b((Property)FISH_SALMON); ++i) {
                world.func_195594_a((IParticleData)ParticleTypes.field_218422_X, (double)pos.func_177958_n() + 0.5 + (double)random.nextFloat() - 0.5, (double)pos.func_177956_o() + 0.5 + (double)random.nextFloat() - 0.5, (double)pos.func_177952_p() + 0.5 + (double)random.nextFloat() - 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public void func_225542_b_(BlockState blockState, ServerWorld world, final BlockPos pos, Random random) {
        if (((Boolean)blockState.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            int i = 0;
            ArrayList<Object> pos_list = new ArrayList<BlockPos>(){
                {
                    this.add(pos);
                }
            };
            HashSet<BlockPos> do_pos_set = new HashSet<BlockPos>();
            HashSet<BlockPos> done_pos_set = new HashSet<BlockPos>();
            HashSet entity_set = new HashSet();
            block0: while (pos_list.size() > 0) {
                for (BlockPos blockPos : pos_list) {
                    for (int ix = 0; ix < 3; ++ix) {
                        for (int iz = 0; iz < 3; ++iz) {
                            BlockPos p;
                            BlockPos blockPos2 = ix == 0 && iz == 0 ? blockPos : (p = ix == 1 && iz == 1 ? blockPos.func_177982_a(-1, 0, -1) : blockPos.func_177982_a(ix - 1, 0, iz - 1));
                            if (done_pos_set.contains(p)) continue;
                            done_pos_set.add(p);
                            if (world.func_180495_p(p).func_185904_a() != Material.field_151586_h) continue;
                            entity_set.addAll(world.func_72839_b(null, new AxisAlignedBB(p.func_177982_a(0, 1, 0), p.func_177982_a(1, 1 - pos.func_177956_o(), 1))));
                            if (++i >= 512) break block0;
                            if (ix == 0 && iz == 0) continue;
                            do_pos_set.add(p);
                        }
                    }
                }
                pos_list = new ArrayList(do_pos_set);
                do_pos_set.clear();
            }
            if (!entity_set.isEmpty()) {
                for (Entity entity : entity_set) {
                    if (!(entity instanceof CodEntity) && !(entity instanceof SalmonEntity)) continue;
                    if (entity instanceof CodEntity && (Integer)blockState.func_177229_b((Property)FISH_COD) < 15) {
                        world.func_175656_a(pos, (BlockState)blockState.func_206870_a((Property)FISH_COD, (Comparable)Integer.valueOf((Integer)blockState.func_177229_b((Property)FISH_COD) + 1)));
                    } else if (entity instanceof SalmonEntity && (Integer)blockState.func_177229_b((Property)FISH_SALMON) < 15) {
                        world.func_175656_a(pos, (BlockState)blockState.func_206870_a((Property)FISH_SALMON, (Comparable)Integer.valueOf((Integer)blockState.func_177229_b((Property)FISH_SALMON) + 1)));
                    }
                    world.func_195594_a((IParticleData)ParticleTypes.field_218425_n, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0, 0.0, 0.0);
                    world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_204326_e, SoundCategory.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
                    entity.func_70106_y();
                }
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_204327_f, SoundCategory.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
                world.func_195594_a((IParticleData)ParticleTypes.field_218422_X, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            }
        }
        super.func_225542_b_(blockState, world, pos, random);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        if (!world.field_72995_K && (Integer)blockState.func_177229_b((Property)FISH_COD) + (Integer)blockState.func_177229_b((Property)FISH_SALMON) > 0) {
            ItemStack itemStack;
            if ((Integer)blockState.func_177229_b((Property)FISH_COD) > 0) {
                itemStack = Items.field_196086_aW.func_190903_i();
                itemStack.func_190920_e(((Integer)blockState.func_177229_b((Property)FISH_COD)).intValue());
                world.func_217376_c((Entity)new ItemEntity(world, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), itemStack));
            }
            if ((Integer)blockState.func_177229_b((Property)FISH_SALMON) > 0) {
                itemStack = Items.field_196087_aX.func_190903_i();
                itemStack.func_190920_e(((Integer)blockState.func_177229_b((Property)FISH_SALMON)).intValue());
                world.func_217376_c((Entity)new ItemEntity(world, playerEntity.func_226277_ct_(), playerEntity.func_226278_cu_(), playerEntity.func_226281_cx_(), itemStack));
            }
            world.func_175656_a(pos, (BlockState)((BlockState)blockState.func_206870_a((Property)FISH_COD, (Comparable)Integer.valueOf(0))).func_206870_a((Property)FISH_SALMON, (Comparable)Integer.valueOf(0)));
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_204327_f, SoundCategory.BLOCKS, 0.2f + new Random().nextFloat() * 0.2f, 0.9f + new Random().nextFloat() * 0.15f, false);
            world.func_195594_a((IParticleData)ParticleTypes.field_218422_X, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    @ParametersAreNonnullByDefault
    public void func_196243_a(BlockState blockState, World world, BlockPos pos, BlockState new_blockState, boolean move) {
        if (!world.field_72995_K && (Integer)blockState.func_177229_b((Property)FISH_COD) + (Integer)blockState.func_177229_b((Property)FISH_SALMON) > 0 && blockState.func_177230_c() != new_blockState.func_177230_c()) {
            ItemStack itemStack;
            if ((Integer)blockState.func_177229_b((Property)FISH_COD) > 0) {
                itemStack = Items.field_196086_aW.func_190903_i();
                itemStack.func_190920_e(((Integer)blockState.func_177229_b((Property)FISH_COD)).intValue());
                world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemStack));
            }
            if ((Integer)blockState.func_177229_b((Property)FISH_SALMON) > 0) {
                itemStack = Items.field_196087_aX.func_190903_i();
                itemStack.func_190920_e(((Integer)blockState.func_177229_b((Property)FISH_SALMON)).intValue());
                world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemStack));
            }
        }
        super.func_196243_a(blockState, world, pos, new_blockState, move);
    }

    @Nonnull
    public FluidState func_204507_t(BlockState blockState) {
        return (Boolean)blockState.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(blockState);
    }

    @ParametersAreNonnullByDefault
    public boolean func_204510_a(IBlockReader reader, BlockPos pos, BlockState blockState, Fluid fluid) {
        return super.func_204510_a(reader, pos, blockState, fluid);
    }

    @ParametersAreNonnullByDefault
    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState blockState, FluidState fluidState) {
        return super.func_204509_a(world, pos, blockState, fluidState);
    }

    @ParametersAreNonnullByDefault
    public boolean func_196266_a(BlockState blockState, IBlockReader reader, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return reader.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }
}

