/*
 * Decompiled with CFR 0.152.
 */
package roughly_mod.block.loot_box_block;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import roughly_mod.block.loot_box_block.LootBoxBlockEntity;

public class LootBoxBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty BOTTOM = BlockStateProperties.field_222513_b;
    public static final BooleanProperty ENABLED = BlockStateProperties.field_208180_g;

    public LootBoxBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(2.5f).func_200947_a(SoundType.field_185852_e).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, BOTTOM, ENABLED});
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader world, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)1.0, (double)-2.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[0]);
        if (((Boolean)blockState.func_177229_b((Property)BOTTOM)).booleanValue()) {
            Direction dir = (Direction)blockState.func_177229_b((Property)FACING);
            shape = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)1.0, (double)9.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), (VoxelShape)Block.func_208617_a((double)(dir == Direction.NORTH ? 1.0 : (dir == Direction.SOUTH ? 1.0 : (dir == Direction.EAST ? 1.0 : 5.0))), (double)0.0, (double)(dir == Direction.NORTH ? 5.0 : (dir == Direction.SOUTH ? 1.0 : (dir == Direction.EAST ? 1.0 : 1.0))), (double)(dir == Direction.NORTH ? 15.0 : (dir == Direction.SOUTH ? 15.0 : (dir == Direction.EAST ? 11.0 : 15.0))), (double)9.0, (double)(dir == Direction.NORTH ? 15.0 : (dir == Direction.SOUTH ? 11.0 : (dir == Direction.EAST ? 15.0 : 15.0)))));
        }
        return shape;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World wo = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction direction = context.func_195992_f().func_176734_d();
        BlockState blockstate = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction);
        if (blockstate.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a()) && wo.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a) {
            return blockstate;
        }
        return null;
    }

    @ParametersAreNonnullByDefault
    public void func_180633_a(World world, BlockPos pos, BlockState blockState, @Nullable LivingEntity entity, ItemStack item) {
        if (!world.field_72995_K && ((Boolean)blockState.func_177229_b((Property)BOTTOM)).booleanValue()) {
            world.func_180501_a(pos.func_177984_a(), (BlockState)blockState.func_206870_a((Property)BOTTOM, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld world, BlockPos pos, BlockPos pos2) {
        return (Boolean)blockState.func_177229_b((Property)BOTTOM) != false && world.func_180495_p(pos.func_177984_a()).func_177230_c() != this || (Boolean)blockState.func_177229_b((Property)BOTTOM) == false && world.func_180495_p(pos.func_177977_b()).func_177230_c() != this ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(blockState, direction, blockState2, world, pos, pos2);
    }

    @ParametersAreNonnullByDefault
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState blockState, World world, BlockPos pos, Random random) {
        if (((Boolean)blockState.func_177229_b((Property)BOTTOM)).booleanValue() && ((Boolean)blockState.func_177229_b((Property)ENABLED)).booleanValue()) {
            for (int i = 0; i < 3; ++i) {
                int j = random.nextInt(2) * 2 - 1;
                int k = random.nextInt(2) * 2 - 1;
                double d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                double d1 = (float)pos.func_177956_o() + random.nextFloat();
                double d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)k;
                double d3 = random.nextFloat() * (float)j;
                double d4 = ((double)random.nextFloat() - 0.5) * 0.125;
                double d5 = random.nextFloat() * (float)k;
                world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0, d1, d2, d3, d4, d5);
            }
        }
    }

    public boolean hasTileEntity(BlockState blockState) {
        return (Boolean)blockState.func_177229_b((Property)BOTTOM);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState blockState, IBlockReader reader) {
        return (Boolean)blockState.func_177229_b((Property)BOTTOM) != false ? new LootBoxBlockEntity() : null;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult result) {
        if (playerEntity.func_184586_b(hand).func_77973_b() == Items.field_151166_bC || ((Boolean)blockState.func_177229_b((Property)BOTTOM) != false ? (Boolean)blockState.func_177229_b((Property)ENABLED) : (Boolean)world.func_180495_p(pos.func_177977_b()).func_177229_b((Property)ENABLED)).booleanValue()) {
            if (!world.field_72995_K) {
                if (!((Boolean)blockState.func_177229_b((Property)BOTTOM)).booleanValue()) {
                    pos = pos.func_177977_b();
                }
                if (world.func_175625_s(pos) instanceof LootBoxBlockEntity) {
                    LootBoxBlock.use2(blockState, world, pos, true);
                    if (playerEntity.func_184586_b(hand).func_77973_b() == Items.field_151166_bC && !((Boolean)blockState.func_177229_b((Property)ENABLED)).booleanValue() && !playerEntity.field_71075_bZ.field_75098_d) {
                        playerEntity.func_184586_b(hand).func_190918_g(1);
                    } else if (((Boolean)blockState.func_177229_b((Property)BOTTOM)).booleanValue() && ((Boolean)blockState.func_177229_b((Property)ENABLED)).booleanValue() || !((Boolean)blockState.func_177229_b((Property)BOTTOM)).booleanValue() && ((Boolean)world.func_180495_p(pos).func_177229_b((Property)ENABLED)).booleanValue()) {
                        world.func_180501_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)ENABLED, (Comparable)Boolean.valueOf(false)), 3);
                    }
                }
                return ActionResultType.SUCCESS;
            }
            world.func_184133_a(playerEntity, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.5f, 1.0f);
        }
        return ActionResultType.CONSUME;
    }

    public static Item use2(BlockState blockState, World world, BlockPos pos, Boolean b) {
        LootBoxBlockEntity ten = (LootBoxBlockEntity)world.func_175625_s(pos);
        if (b.booleanValue()) {
            int r = blockState.func_177229_b((Property)FACING) == Direction.NORTH ? 0 : (blockState.func_177229_b((Property)FACING) == Direction.EAST ? 90 : (blockState.func_177229_b((Property)FACING) == Direction.SOUTH ? 180 : 270));
            double r2 = (double)r * (Math.PI / 180);
            ItemEntity ien = new ItemEntity(world, (double)pos.func_177958_n() + 0.5 + Math.sin(r2) * 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5 + Math.cos(r2) * -0.5, Objects.requireNonNull(ten).item.func_190903_i());
            ien.func_213293_j(Math.sin(r2) * 0.25, 0.25, Math.cos(r2) * -0.25);
            world.func_217376_c((Entity)ien);
        }
        return Objects.requireNonNull(ten).item;
    }
}

