/*
 * Decompiled with CFR 0.152.
 */
package roughly_mod.block.sample_block.sample_entity_block;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import roughly_mod.ModUtil;
import roughly_mod.event.entity_container.BlockEntityContainer;

public class SampleBlockEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private final LazyOptional<ItemStackHandler> inventory = LazyOptional.of(() -> new ItemStackHandler(9));
    public int time = 0;

    @Nonnull
    @ParametersAreNonnullByDefault
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction direction) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        return super.getCapability(capability, direction);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("roughly_mod_container");
    }

    @ParametersAreNonnullByDefault
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity playerEntity) {
        return new BlockEntityContainer(id, inventory, this.func_174877_v());
    }

    public SampleBlockEntity(TileEntityType<?> entityType) {
        super(entityType);
    }

    @ParametersAreNonnullByDefault
    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        this.inventory.ifPresent(h -> {
            if (nbt.func_74764_b("inv")) {
                h.deserializeNBT(nbt.func_74775_l("inv"));
            }
        });
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        this.inventory.ifPresent(h -> nbt.func_218657_a("inv", (INBT)h.serializeNBT()));
        return super.func_189515_b(nbt);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        this.func_189515_b(new CompoundNBT());
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager manager, SUpdateTileEntityPacket packet) {
        this.handleUpdateTag(this.func_195044_w(), packet.func_148857_g());
    }

    public void handleUpdateTag(BlockState blockState, CompoundNBT nbt) {
        this.func_230337_a_(blockState, nbt);
    }

    public void func_73660_a() {
        if (!Objects.requireNonNull(this.field_145850_b).field_72995_K) {
            for (ItemEntity itementity : this.field_145850_b.func_217357_a(ItemEntity.class, this.getRenderBoundingBox().func_72314_b(1.0, 0.0, 1.0))) {
                if (itementity.field_70128_L || itementity.func_92059_d().func_190926_b() || itementity.func_174874_s()) continue;
                ItemStack itemstack = itementity.func_92059_d();
                this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).cast().ifPresent(h -> {
                    if (ModUtil.ISHCanAddItem(h, itemstack)) {
                        ItemStack itemstack1 = ModUtil.ISHAddItem(h, itemstack);
                        if (itemstack1.func_190926_b()) {
                            itementity.func_70106_y();
                        } else {
                            itemstack.func_190920_e(itemstack1.func_190916_E());
                        }
                    }
                });
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.time > 100 && this.time < 1000) {
                this.time = 1000;
            }
            if (this.time > 1000) {
                this.time = 0;
                this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).cast().ifPresent(h -> {
                    if (ModUtil.ISHCanAddItem(h, new ItemStack((IItemProvider)Items.field_151034_e, 1))) {
                        ModUtil.ISHAddItem(h, new ItemStack((IItemProvider)Items.field_151034_e, 1));
                    }
                });
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
            }
        }
        if (this.field_145850_b.field_72995_K && this.time >= 1000) {
            this.time = 0;
        }
        ++this.time;
    }
}

