/*
 * Decompiled with CFR 0.152.
 */
package roughly_mod.entity.werewolf_entity;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SCollectItemPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.Logger;
import roughly_mod.ModRegister;
import roughly_mod.ModUtil;
import roughly_mod.entity.werewolf_entity.WerewolfVillagerEntity;

public class WerewolfEntity
extends AgeableEntity
implements IMob,
IVillagerDataHolder {
    public static final DataParameter<VillagerData> DATA_VILLAGER_DATA = EntityDataManager.func_187226_a(WerewolfEntity.class, (IDataSerializer)DataSerializers.field_218813_q);
    public static final DataParameter<Boolean> CONVERSION = EntityDataManager.func_187226_a(WerewolfEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> TARGET = EntityDataManager.func_187226_a(WerewolfEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public CompoundNBT villager_nbt;
    float yr = 0.0f;

    public WerewolfEntity(EntityType<? extends WerewolfEntity> entityType, World world) {
        super(entityType, world);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233819_b_, 48.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 4.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_VILLAGER_DATA, (Object)new VillagerData(VillagerType.field_221175_c, VillagerProfession.field_221151_a, 1));
        this.field_70180_af.func_187214_a(CONVERSION, (Object)false);
        this.field_70180_af.func_187214_a(TARGET, (Object)0);
    }

    @ParametersAreNonnullByDefault
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        VillagerData.field_234554_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.func_213700_eh()).resultOrPartial(arg_0 -> ((Logger)field_184243_a).error(arg_0)).ifPresent(inbt -> nbt.func_218657_a("VillagerData", inbt));
        if (this.villager_nbt != null) {
            nbt.func_218657_a("nbt", (INBT)this.villager_nbt);
        }
        nbt.func_74757_a("Conversion", ((Boolean)this.field_70180_af.func_187225_a(CONVERSION)).booleanValue());
        nbt.func_74768_a("Target", ((Integer)this.field_70180_af.func_187225_a(TARGET)).intValue());
    }

    @ParametersAreNonnullByDefault
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("VillagerData", 10)) {
            DataResult dataresult = VillagerData.field_234554_a_.parse(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)nbt.func_74781_a("VillagerData")));
            dataresult.resultOrPartial(arg_0 -> ((Logger)field_184243_a).error(arg_0)).ifPresent(this::setVillagerData);
        }
        if (nbt.func_74764_b("nbt")) {
            this.villager_nbt = (CompoundNBT)nbt.func_74781_a("nbt");
        }
        if (nbt.func_74764_b("Conversion")) {
            this.field_70180_af.func_187227_b(CONVERSION, (Object)nbt.func_74767_n("Conversion"));
        }
        if (nbt.func_74764_b("Target")) {
            this.field_70180_af.func_187227_b(TARGET, (Object)nbt.func_74762_e("Target"));
        }
    }

    @Nonnull
    public VillagerData func_213700_eh() {
        return (VillagerData)this.field_70180_af.func_187225_a(DATA_VILLAGER_DATA);
    }

    public void setVillagerData(VillagerData villagerData) {
        this.field_70180_af.func_187227_b(DATA_VILLAGER_DATA, (Object)villagerData);
    }

    @ParametersAreNonnullByDefault
    public WerewolfEntity getBreedOffspring(ServerWorld world, AgeableEntity entity) {
        WerewolfEntity werewolfEntity = new WerewolfEntity((EntityType<? extends WerewolfEntity>)((EntityType)ModRegister.WEREWOLF_ENTITY.get()), (World)world);
        werewolfEntity.func_213386_a((IServerWorld)world, world.func_175649_E(werewolfEntity.func_233580_cy_()), SpawnReason.BREEDING, null, null);
        return werewolfEntity;
    }

    @ParametersAreNonnullByDefault
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData entityData, @Nullable CompoundNBT nbt) {
        if (spawnReason == SpawnReason.COMMAND || spawnReason == SpawnReason.SPAWN_EGG || spawnReason == SpawnReason.SPAWNER || spawnReason == SpawnReason.DISPENSER) {
            this.setVillagerData(this.func_213700_eh().func_221134_a(VillagerType.func_242371_a((Optional)world.func_242406_i(this.func_233580_cy_()))));
        }
        if (spawnReason == SpawnReason.CONVERSION) {
            this.func_184212_Q().func_187227_b(CONVERSION, (Object)true);
            world.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_189111_gN, SoundCategory.HOSTILE, this.func_70599_aP(), this.func_70647_i());
        }
        return super.func_213386_a(world, difficultyInstance, spawnReason, entityData, nbt);
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends MobEntity> entityType, IServerWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL && world.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_196658_i);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, IronGolemEntity.class, 16.0f, 1.25, 1.5, entity -> this.field_70170_p.func_241851_ab() < 15000L || this.field_70170_p.func_241851_ab() >= 21000L));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 16.0f, 1.25, 1.5, entity -> {
            if ((this.field_70170_p.func_241851_ab() < 15000L || this.field_70170_p.func_241851_ab() >= 21000L) && entity.func_110143_aJ() > this.func_110143_aJ() && entity == this.func_70638_az() && this.field_70714_bg.func_220888_c().noneMatch(goal -> goal.func_220772_j() instanceof MeleeAttackGoal)) {
                this.func_70624_b(null);
            }
            return (this.field_70170_p.func_241851_ab() < 15000L || this.field_70170_p.func_241851_ab() >= 21000L) && entity.func_110143_aJ() > this.func_110143_aJ();
        }));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, VillagerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.5, true));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 10, true, false, entity -> entity.func_190631_cK() && (entity instanceof PlayerEntity && entity.func_110143_aJ() <= this.func_110143_aJ() || entity instanceof VillagerEntity && !(entity instanceof WerewolfVillagerEntity) || entity instanceof AnimalEntity || entity instanceof PatrollerEntity || entity instanceof AbstractSkeletonEntity)));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70089_S() && !this.field_70170_p.field_72995_K) {
            if (this.field_70714_bg.func_220888_c().anyMatch(goal -> goal.func_220772_j() instanceof AvoidEntityGoal || goal.func_220772_j() instanceof WaterAvoidingRandomWalkingGoal)) {
                this.func_70624_b(null);
            }
            this.field_70180_af.func_187227_b(TARGET, (Object)(this.func_70638_az() != null ? this.func_70638_az().func_145782_y() : 0));
            if (this.yr != 0.0f) {
                this.field_70177_z = this.yr;
                if (this.func_70638_az() == null || this.func_233570_aj_() && this.func_213303_ch().func_82617_b() % 1.0 == 0.0) {
                    float f = this.yr = this.func_70638_az() != null ? (this.field_70177_z = this.field_70759_as) : 0.0f;
                }
            }
            if (this.field_70715_bh.func_220888_c().anyMatch(goal -> goal.func_220772_j() instanceof HurtByTargetGoal || goal.func_220772_j() instanceof NearestAttackableTargetGoal)) {
                this.func_70031_b(true);
                boolean near = this.func_70638_az() != null && this.func_233562_a_((Entity)this.func_70638_az(), 2.0);
                Entity target = ModUtil.LookEntityNearest((LivingEntity)this, 8);
                if (near && this.func_233570_aj_() && this.func_213303_ch().func_82617_b() % 1.0 == 0.0 && this.func_213322_ci().func_82615_a() == 0.0 && this.func_213322_ci().func_82616_c() == 0.0) {
                    this.func_213293_j(-MathHelper.func_76126_a((float)(this.field_70759_as * ((float)Math.PI / 180))) * 0.2f, 0.0, MathHelper.func_76134_b((float)(this.field_70759_as * ((float)Math.PI / 180))) * 0.2f);
                    this.func_70664_aZ();
                } else if (!near && target != null && this.func_233570_aj_() && this.func_213303_ch().func_82617_b() % 1.0 == 0.0 && (target == this.func_70638_az() || Math.abs(this.func_213322_ci().func_82615_a()) + Math.abs(this.func_213322_ci().func_82616_c()) >= 0.2)) {
                    if (target == this.func_70638_az()) {
                        this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-MathHelper.func_76126_a((float)(this.field_70759_as * ((float)Math.PI / 180))) * 0.3f), 0.0, (double)(MathHelper.func_76134_b((float)(this.field_70759_as * ((float)Math.PI / 180))) * 0.3f)));
                    }
                    this.func_213317_d(this.func_213322_ci().func_216372_d(2.0, 1.0, 2.0));
                    this.func_70664_aZ();
                    this.yr = this.field_70177_z;
                }
            } else if (this.field_70714_bg.func_220888_c().anyMatch(goal -> goal.func_220772_j() instanceof AvoidEntityGoal)) {
                this.func_70031_b(true);
            }
            if (this.func_213322_ci().func_82615_a() == 0.0 && this.func_213322_ci().func_82616_c() == 0.0) {
                this.func_70031_b(false);
            }
            if (this.field_70170_p.func_241851_ab() >= 15000L && this.field_70170_p.func_241851_ab() < 21000L) {
                if (!this.func_70644_a(Effects.field_76420_g)) {
                    this.func_195064_c(new EffectInstance(Effects.field_76420_g, 200, 0));
                }
            } else if (this.field_70170_p.func_217362_a((Entity)this, 8.0) == null && this.func_70638_az() == null && ((Boolean)this.field_70180_af.func_187225_a(CONVERSION)).booleanValue() && this.field_70146_Z.nextInt(120) == 0 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)((EntityType)ModRegister.WEREWOLF_VILLAGER_ENTITY.get()), timer -> {})) {
                this.toVillager(true);
            }
            if (this.func_213700_eh().func_221130_b() != VillagerProfession.field_221151_a && this.func_213700_eh().func_221130_b() != VillagerProfession.field_221162_l) {
                Objects.requireNonNull(this.func_110148_a(Attributes.field_233826_i_)).func_111128_a((double)(this.func_213700_eh().func_221132_c() * 4));
            }
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                for (ItemEntity itementity : this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0))) {
                    if (itementity.field_70128_L || itementity.func_92059_d().func_190926_b() || itementity.func_174874_s() || itementity.field_70173_aa <= 20 || itementity.func_92059_d().func_77973_b().func_219967_s() == null || itementity.func_92059_d().func_77973_b().func_219967_s().func_221466_a() <= 0) continue;
                    ItemStack itemstack = itementity.func_92059_d();
                    ((ServerWorld)this.field_70170_p).func_72863_F().func_217218_b((Entity)itementity, (IPacket)new SCollectItemPacket(itementity.func_145782_y(), this.func_145782_y(), itemstack.func_190916_E()));
                    this.func_70691_i((float)itemstack.func_77973_b().func_219967_s().func_221466_a() * (float)itemstack.func_190916_E());
                    itementity.func_70106_y();
                }
            }
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    protected ActionResultType func_230254_b_(PlayerEntity playerEntity, Hand hand) {
        Item item = playerEntity.func_184586_b(hand).func_77973_b();
        if (this.func_70089_S() && !this.field_70170_p.field_72995_K && (item == Items.field_151103_aS || item == Items.field_151153_ao || item == Items.field_151150_bK || item == Items.field_196100_at) && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)((EntityType)ModRegister.WEREWOLF_VILLAGER_ENTITY.get()), timer -> {})) {
            this.toVillager(item == Items.field_151103_aS);
            if (!playerEntity.field_71075_bZ.field_75098_d) {
                playerEntity.func_184586_b(hand).func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.CONSUME;
    }

    public void toVillager(boolean canChange) {
        VillagerEntity entity = canChange ? (VillagerEntity)((EntityType)ModRegister.WEREWOLF_VILLAGER_ENTITY.get()).func_200721_a(this.field_70170_p) : (VillagerEntity)EntityType.field_200756_av.func_200721_a(this.field_70170_p);
        if (entity == null) {
            return;
        }
        if (this.serializeNBT().func_74781_a("nbt") != null) {
            entity.deserializeNBT((CompoundNBT)this.serializeNBT().func_74781_a("nbt"));
        } else if (this.villager_nbt != null) {
            entity.deserializeNBT(this.villager_nbt);
        }
        entity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        entity.func_70606_j(entity.func_110138_aP() <= this.func_110138_aP() - this.func_110143_aJ() ? 1.0f : entity.func_110138_aP() - (this.func_110138_aP() - this.func_110143_aJ()));
        entity.func_82227_f(this.func_70631_g_());
        entity.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(entity.func_233580_cy_()), SpawnReason.CONVERSION, null, null);
        entity.func_94061_f(this.func_175446_cd());
        if (this.func_145818_k_()) {
            entity.func_200203_b(this.func_200201_e());
            entity.func_174805_g(this.func_174833_aM());
        }
        entity.func_110163_bv();
        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)entity);
        ((ServerWorld)this.field_70170_p).func_242417_l((Entity)entity);
        this.func_70106_y();
    }

    public boolean func_213397_c(double distance) {
        return (Boolean)this.func_184212_Q().func_187225_a(CONVERSION) == false && distance > 16384.0 && this.field_70173_aa > 1200;
    }

    protected boolean func_225511_J_() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        return this.func_70638_az() != null ? SoundEvents.field_187861_gG : null;
    }

    @ParametersAreNonnullByDefault
    protected void func_180429_a(@Nonnull BlockPos pos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_187869_gK, this.func_70599_aP(), this.func_70647_i());
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSource) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    protected float func_70647_i() {
        return 0.5f * (this.func_70631_g_() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.5f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    public boolean func_213743_em() {
        return false;
    }
}

