/*
 * Decompiled with CFR 0.152.
 */
package roughly_mod.item;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ToolItem;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class IronSquareShovel
extends ToolItem {
    private static final Set<Material> DIGGABLE_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151575_d, Material.field_237214_y_, Material.field_151585_k, Material.field_151582_l, Material.field_215713_z, Material.field_151572_C, Material.field_151571_B, Material.field_151578_c, Material.field_151577_b, Material.field_151595_p, Material.field_151596_z});
    private static final Set<Block> DIGGABLES = Sets.newHashSet((Object[])new Block[]{Blocks.field_150468_ap, Blocks.field_222420_lI, Blocks.field_196689_eF, Blocks.field_196691_eG, Blocks.field_196693_eH, Blocks.field_196695_eI, Blocks.field_196699_eK, Blocks.field_196697_eJ, Blocks.field_235358_mQ_, Blocks.field_235359_mR_, Blocks.field_150435_aG, Blocks.field_150346_d, Blocks.field_196660_k, Blocks.field_196661_l, Blocks.field_150458_ak, Blocks.field_196658_i, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_196611_F, Blocks.field_196604_cC, Blocks.field_150433_aE, Blocks.field_150425_aM, Blocks.field_185774_da, Blocks.field_196860_iS, Blocks.field_196862_iT, Blocks.field_196864_iU, Blocks.field_196866_iV, Blocks.field_196868_iW, Blocks.field_196870_iX, Blocks.field_196872_iY, Blocks.field_196874_iZ, Blocks.field_196877_ja, Blocks.field_196878_jb, Blocks.field_196879_jc, Blocks.field_196880_jd, Blocks.field_196881_je, Blocks.field_196882_jf, Blocks.field_196883_jg, Blocks.field_196884_jh, Blocks.field_235336_cN_});

    public IronSquareShovel(Item.Properties properties) {
        super(6.0f, -3.1f, (IItemTier)ItemTier.IRON, DIGGABLES, properties.addToolType(ToolType.AXE, 2).addToolType(ToolType.SHOVEL, 2).func_200915_b(500));
    }

    @ParametersAreNonnullByDefault
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        list.add(ITextComponent.func_244388_a((String)"\u65a7\u3068\u30b7\u30e3\u30d9\u30eb\u3001\u4e21\u65b9\u306e\u6a5f\u80fd\u3092\u6301\u3064/Has the functions of both an axe and a shovel"));
        super.func_77624_a(itemStack, world, list, flag);
    }

    public boolean func_150897_b(BlockState blockState) {
        if (blockState.getHarvestTool() == ToolType.AXE || blockState.getHarvestTool() == ToolType.SHOVEL) {
            return this.func_200891_e().func_200925_d() >= blockState.getHarvestLevel();
        }
        Material material = blockState.func_185904_a();
        return DIGGABLE_MATERIALS.contains(material) || blockState.func_203425_a(Blocks.field_150433_aE) || blockState.func_203425_a(Blocks.field_196604_cC);
    }

    @ParametersAreNonnullByDefault
    public float func_150893_a(ItemStack itemStack, BlockState blockState) {
        Material material = blockState.func_185904_a();
        return DIGGABLE_MATERIALS.contains(material) ? this.field_77864_a : super.func_150893_a(itemStack, blockState);
    }

    @ParametersAreNonnullByDefault
    public boolean func_77644_a(ItemStack itemStack, LivingEntity target, LivingEntity entity) {
        itemStack.func_222118_a(1, entity, en -> en.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    @ParametersAreNonnullByDefault
    public boolean func_179218_a(ItemStack itemStack, World world, BlockState blockState, BlockPos pos, LivingEntity entity) {
        if (!world.field_72995_K && blockState.func_185887_b((IBlockReader)world, pos) != 0.0f) {
            itemStack.func_222118_a(1, entity, en -> en.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity playerEntity = context.func_195999_j();
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = world.func_180495_p(blockpos);
        BlockState block = blockstate.getToolModifiedState(world, blockpos, context.func_195999_j(), context.func_195996_i(), ToolType.AXE);
        if (block != null) {
            world.func_184133_a(playerEntity, blockpos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, block, 11);
                if (playerEntity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerEntity, entity -> entity.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        if (context.func_196000_l() == Direction.DOWN) {
            return ActionResultType.PASS;
        }
        BlockState blockstate1 = blockstate.getToolModifiedState(world, blockpos, playerEntity, context.func_195996_i(), ToolType.SHOVEL);
        BlockState blockstate2 = null;
        if (blockstate1 != null && world.func_175623_d(blockpos.func_177984_a())) {
            world.func_184133_a(playerEntity, blockpos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            blockstate2 = blockstate1;
        } else if (blockstate.func_177230_c() instanceof CampfireBlock && ((Boolean)blockstate.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) {
            if (!world.field_72995_K) {
                world.func_217378_a(null, 1009, blockpos, 0);
            }
            CampfireBlock.func_235475_c_((IWorld)world, (BlockPos)blockpos, (BlockState)blockstate);
            blockstate2 = (BlockState)blockstate.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.FALSE);
        }
        if (blockstate2 != null) {
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, blockstate2, 11);
                if (playerEntity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerEntity, entity -> entity.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }
}

