/*
 * Decompiled with CFR 0.152.
 */
package roughly_mod.world.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.Dimension;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import roughly_mod.ModMain;
import roughly_mod.ModRegister;
import roughly_mod.config.ConfigElements;

public class AddModStructures {
    public static void generateStructures(BiomeLoadingEvent event) {
        if ((Integer)ConfigElements.CfgNum_VillagerHut.get() != 0) {
            AddModStructures.condition(event, (StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>>)((Structure)ModRegister.VILLAGER_HUT.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), true, (List<RegistryKey<Dimension>>)new ArrayList<RegistryKey<Dimension>>(){
                {
                    this.add(Dimension.field_236053_b_);
                }
            }, false, (List<RegistryKey<Biome>>)new ArrayList<RegistryKey<Biome>>(){}, true, (List<BiomeDictionary.Type>)new ArrayList<BiomeDictionary.Type>(){
                {
                    this.add(BiomeDictionary.Type.FOREST);
                    this.add(BiomeDictionary.Type.PLAINS);
                }
            });
        }
        if ((Integer)ConfigElements.CfgNum_BearDen.get() != 0) {
            AddModStructures.condition(event, (StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>>)((Structure)ModRegister.BEAR_DEN.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), true, (List<RegistryKey<Dimension>>)new ArrayList<RegistryKey<Dimension>>(){
                {
                    this.add(Dimension.field_236053_b_);
                }
            }, false, (List<RegistryKey<Biome>>)new ArrayList<RegistryKey<Biome>>(){}, true, (List<BiomeDictionary.Type>)new ArrayList<BiomeDictionary.Type>(){
                {
                    this.add(BiomeDictionary.Type.FOREST);
                    this.add(BiomeDictionary.Type.PLAINS);
                    this.add(BiomeDictionary.Type.WASTELAND);
                }
            });
        }
        if ((Integer)ConfigElements.CfgNum_Crater.get() != 0) {
            AddModStructures.condition(event, (StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>>)((Structure)ModRegister.CRATER.get()).func_236391_a_((IFeatureConfig)IFeatureConfig.field_202429_e), true, (List<RegistryKey<Dimension>>)new ArrayList<RegistryKey<Dimension>>(){
                {
                    this.add(Dimension.field_236053_b_);
                }
            }, false, (List<RegistryKey<Biome>>)new ArrayList<RegistryKey<Biome>>(){}, false, (List<BiomeDictionary.Type>)new ArrayList<BiomeDictionary.Type>(){});
        }
    }

    private static void condition(BiomeLoadingEvent event, StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> str, boolean d_set, List<RegistryKey<Dimension>> dimensions, boolean b_set, List<RegistryKey<Biome>> biomes, boolean t_set, List<BiomeDictionary.Type> types) {
        boolean b = dimensions.contains(event.getCategory() != Biome.Category.NETHER && event.getCategory() != Biome.Category.THEEND ? Dimension.field_236053_b_ : (event.getCategory() != Biome.Category.THEEND ? Dimension.field_236054_c_ : Dimension.field_236055_d_));
        boolean bl = b = b == d_set;
        if (b) {
            b = biomes.stream().map(RegistryKey::func_240901_a_).map(Object::toString).anyMatch(s -> s.equals(Objects.requireNonNull(event.getName()).toString()));
            boolean bl2 = b = b == b_set;
            if (b) {
                b = false;
                Set type = BiomeDictionary.getTypes((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Objects.requireNonNull(event.getName())));
                for (BiomeDictionary.Type t : type) {
                    if (!types.contains(t)) continue;
                    b = true;
                    break;
                }
                boolean bl3 = b = b == t_set;
                if (b) {
                    List base = event.getGeneration().getStructures();
                    base.add(() -> str);
                }
            }
        }
    }

    public static void setupStructures() {
        int size;
        int i = (Integer)ConfigElements.CfgNum_VillagerHut.get();
        if (i != 0) {
            size = 1 + MathHelper.func_76143_f((double)(100.0 / ((double)i / 10.0 * ((double)i / 10.0))));
            AddModStructures.setupMapSpacingAndLand((Structure)ModRegister.VILLAGER_HUT.get(), new StructureSeparationSettings(size * 2, size, 3125551), true);
        }
        if ((i = ((Integer)ConfigElements.CfgNum_BearDen.get()).intValue()) != 0) {
            size = 1 + MathHelper.func_76143_f((double)(100.0 / ((double)i / 10.0 * ((double)i / 10.0))));
            AddModStructures.setupMapSpacingAndLand((Structure)ModRegister.BEAR_DEN.get(), new StructureSeparationSettings(size * 2, size, 315311), false);
        }
        if ((i = ((Integer)ConfigElements.CfgNum_Crater.get()).intValue()) != 0) {
            size = 1 + MathHelper.func_76143_f((double)(100.0 / ((double)i / 10.0 * ((double)i / 10.0))));
            AddModStructures.setupMapSpacingAndLand((Structure)ModRegister.CRATER.get(), new StructureSeparationSettings(size * 2, size, 34411), true);
        }
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings Separation, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)Objects.requireNonNull(structure.getRegistryName()).toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)Separation).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, Separation);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, Separation);
            }
        });
    }

    public static void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld wo = (ServerWorld)event.getWorld();
            try {
                Method GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                ResourceLocation cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)wo.func_72863_F().field_186029_c, new Object[0])));
                if (cgRL != null && cgRL.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                ModMain.LOGGER.error("Was unable to check if " + wo.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
            }
            if (wo.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && wo.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(wo.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            Collection str = ModRegister.STRUCTURES.getEntries();
            for (RegistryObject s : str) {
                tempMap.putIfAbsent(s.get(), DimensionStructuresSettings.field_236191_b_.get((Object)s.get()));
            }
            wo.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

