/*
 * Decompiled with CFR 0.152.
 */
package roughly_mod.world.structure;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleEntry;
import net.minecraft.world.gen.feature.template.RuleStructureProcessor;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class Crater
extends Structure<NoFeatureConfig> {
    private static final List<MobSpawnInfo.Spawners> STRUCTURE_MONSTERS = ImmutableList.of();
    private static final List<MobSpawnInfo.Spawners> STRUCTURE_CREATURES = ImmutableList.of();
    public static final StructureProcessorList C_WATER = (StructureProcessorList)WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243655_g, (ResourceLocation)new ResourceLocation("crater_water"), (Object)new StructureProcessorList((List)ImmutableList.of((Object)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150350_a), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_150355_j.func_176223_P()))))));
    public static final JigsawPattern crater = JigsawPatternRegistry.func_244094_a((JigsawPattern)new JigsawPattern(new ResourceLocation("roughly_mod:crater"), new ResourceLocation("empty"), (List)ImmutableList.of((Object)Pair.of((Object)JigsawPiece.func_242861_b((String)"roughly_mod:crater/crater", (StructureProcessorList)C_WATER), (Object)1)), JigsawPattern.PlacementBehaviour.RIGID));

    public Crater() {
        super(NoFeatureConfig.field_236558_a_);
    }

    @Nonnull
    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.VEGETAL_DECORATION;
    }

    @ParametersAreNonnullByDefault
    protected boolean isFeatureChunk(ChunkGenerator generator, BiomeProvider provider, long seed, SharedSeedRandom random, int cX, int cZ, Biome biome, ChunkPos cPos, NoFeatureConfig config) {
        BlockPos pos = new BlockPos(cX * 16, 0, cZ * 16);
        int landHeight = generator.func_222531_c(pos.func_177958_n(), pos.func_177952_p(), Heightmap.Type.OCEAN_FLOOR_WG);
        IBlockReader blockReader = generator.func_230348_a_(pos.func_177958_n(), pos.func_177952_p());
        BlockState st = blockReader.func_180495_p(pos.func_177981_b(landHeight));
        return !st.func_196958_f() && landHeight > 20;
    }

    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return STRUCTURE_MONSTERS;
    }

    public List<MobSpawnInfo.Spawners> getDefaultCreatureSpawnList() {
        return STRUCTURE_CREATURES;
    }

    @Nonnull
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> str, int cX, int cZ, MutableBoundingBox Box, int ref, long seed) {
            super(str, cX, cZ, Box, ref, seed);
        }

        @ParametersAreNonnullByDefault
        public void generatePieces(DynamicRegistries manager, ChunkGenerator generator, TemplateManager template, int cX, int cZ, Biome biome, NoFeatureConfig config) {
            BlockPos pos = new BlockPos(cX * 16, 0, cZ * 16);
            int landHeight = generator.func_222531_c(pos.func_177958_n(), pos.func_177952_p(), Heightmap.Type.OCEAN_FLOOR_WG);
            pos = pos.func_177981_b(landHeight);
            JigsawManager.func_242837_a((DynamicRegistries)manager, (VillageConfig)new VillageConfig(() -> crater, 1), AbstractVillagePiece::new, (ChunkGenerator)generator, (TemplateManager)template, (BlockPos)pos.func_177982_a(0, 0, 0), (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)true, (boolean)false);
            this.field_75075_a.forEach(piece -> piece.func_181138_a(0, -3, 0));
            Vector3i structureCenter = ((StructurePiece)this.field_75075_a.get(0)).func_74874_b().func_215126_f();
            int xOffset = pos.func_177958_n() - structureCenter.func_177958_n();
            int zOffset = pos.func_177952_p() - structureCenter.func_177952_p();
            for (StructurePiece structurePiece : this.field_75075_a) {
                structurePiece.func_181138_a(xOffset, 0, zOffset);
            }
            this.func_202500_a();
        }
    }
}

