/*
 * Decompiled with CFR 0.152.
 */
package roughly_mod.world.structure;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.logging.log4j.Level;
import roughly_mod.ModMain;
import roughly_mod.ModRegister;

public class SampleStructure
extends Structure<NoFeatureConfig> {
    private static final List<MobSpawnInfo.Spawners> STRUCTURE_MONSTERS = ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_200764_D, 100, 4, 9), (Object)new MobSpawnInfo.Spawners(EntityType.field_200758_ax, 100, 4, 9), (Object)new MobSpawnInfo.Spawners((EntityType)ModRegister.BEAR_ENTITY.get(), 10, 1, 2));
    private static final List<MobSpawnInfo.Spawners> STRUCTURE_CREATURES = ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_200737_ac, 30, 10, 15), (Object)new MobSpawnInfo.Spawners(EntityType.field_200769_I, 300, 5, 10));

    public SampleStructure() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    protected boolean isFeatureChunk(ChunkGenerator generator, BiomeProvider provider, long seed, SharedSeedRandom random, int cX, int cZ, Biome biome, ChunkPos cPos, NoFeatureConfig config) {
        BlockPos pos = new BlockPos(cX * 16, 0, cZ * 16);
        int landHeight = generator.func_222531_c(pos.func_177958_n(), pos.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
        IBlockReader columnOfBlocks = generator.func_230348_a_(pos.func_177958_n(), pos.func_177952_p());
        BlockState st = columnOfBlocks.func_180495_p(pos.func_177981_b(landHeight));
        return st.func_204520_s().func_206888_e();
    }

    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return STRUCTURE_MONSTERS;
    }

    public List<MobSpawnInfo.Spawners> getDefaultCreatureSpawnList() {
        return STRUCTURE_CREATURES;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> str, int cX, int cZ, MutableBoundingBox Box, int ref, long seed) {
            super(str, cX, cZ, Box, ref, seed);
        }

        public void generatePieces(DynamicRegistries manager, ChunkGenerator generator, TemplateManager template, int cX, int cZ, Biome biome, NoFeatureConfig config) {
            int x = cX * 16;
            int z = cZ * 16;
            BlockPos pos = new BlockPos(x, 0, z);
            JigsawManager.func_242837_a((DynamicRegistries)manager, (VillageConfig)new VillageConfig(() -> SnowyVillagePools.field_244129_a, 36), AbstractVillagePiece::new, (ChunkGenerator)generator, (TemplateManager)template, (BlockPos)pos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)true, (boolean)true);
            this.field_75075_a.forEach(piece -> piece.func_181138_a(0, 1, 0));
            this.field_75075_a.forEach(piece -> piece.func_74874_b().field_78895_b -= 0);
            Vector3i structureCenter = ((StructurePiece)this.field_75075_a.get(0)).func_74874_b().func_215126_f();
            int xOffset = pos.func_177958_n() - structureCenter.func_177958_n();
            int zOffset = pos.func_177952_p() - structureCenter.func_177952_p();
            for (StructurePiece structurePiece : this.field_75075_a) {
                structurePiece.func_181138_a(xOffset, 0, zOffset);
            }
            this.func_202500_a();
            ModMain.LOGGER.log(Level.DEBUG, "Rundown House at " + ((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78897_a + " " + ((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78895_b + " " + ((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78896_c);
        }
    }
}

