/*
 * Decompiled with CFR 0.152.
 */
package io.github.worldsaladdev.minecards.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CardItem
extends Item {
    private final String flavorText;
    private final String cardIdentity;
    private static final String TAG_FOIL = "Foil";
    private static final String TAG_QUALITY = "Quality";

    public CardItem(Item.Properties properties, String _flavorText, String _cardIdentity) {
        super(properties);
        this.flavorText = _flavorText;
        this.cardIdentity = _cardIdentity;
    }

    public CardItem(Item.Properties properties, String _flavorText) {
        super(properties);
        this.flavorText = _flavorText;
        this.cardIdentity = null;
    }

    public boolean m_5812_(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null && compoundtag.m_128471_(TAG_FOIL);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        CompoundTag compoundtag = stack.m_41783_();
        super.m_7373_(stack, level, components, flag);
        if (!Screen.m_96638_()) {
            components.add((Component)Component.m_237115_((String)"minecards.tooltip.hold_l_shift").m_130940_(ChatFormatting.GRAY));
        } else {
            components.add((Component)Component.m_237115_((String)this.flavorText).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
            if (this.cardIdentity != null) {
                components.add((Component)Component.m_237115_((String)this.cardIdentity).m_130940_(ChatFormatting.GRAY));
            }
        }
        if (!Screen.m_96637_()) {
            components.add((Component)Component.m_237115_((String)"minecards.tooltip.hold_l_control").m_130940_(ChatFormatting.GRAY));
        } else if (compoundtag != null && compoundtag.m_128441_(TAG_FOIL) && compoundtag.m_128441_(TAG_QUALITY)) {
            switch (compoundtag.m_128451_(TAG_QUALITY)) {
                case 0: {
                    components.add((Component)Component.m_237115_((String)"minecards.tooltip.quality.0").m_130940_(ChatFormatting.WHITE));
                    break;
                }
                case 1: {
                    components.add((Component)Component.m_237115_((String)"minecards.tooltip.quality.1").m_130940_(ChatFormatting.GREEN));
                    break;
                }
                case 2: {
                    components.add((Component)Component.m_237115_((String)"minecards.tooltip.quality.2").m_130940_(ChatFormatting.AQUA));
                    break;
                }
                case 3: {
                    components.add((Component)Component.m_237115_((String)"minecards.tooltip.quality.3").m_130940_(ChatFormatting.GOLD));
                    break;
                }
                default: {
                    components.add((Component)Component.m_237115_((String)"minecards.tooltip.quality.illegal").m_130940_(ChatFormatting.RED));
                }
            }
            if (compoundtag.m_128471_(TAG_FOIL)) {
                components.add((Component)Component.m_237115_((String)"minecards.tooltip.foil").m_130940_(ChatFormatting.DARK_PURPLE));
            }
        } else {
            components.add((Component)Component.m_237113_((String)"Bad NBT Tag").m_130940_(ChatFormatting.RED));
        }
    }

    public void setFoil(ItemStack stack, boolean isFoil) {
        CompoundTag compoundtag = stack.m_41784_();
        compoundtag.m_128379_(TAG_FOIL, isFoil);
    }

    public void setQuality(ItemStack stack, int quality) {
        if (quality < 0 || quality > 3) {
            throw new IllegalArgumentException("Quality must be between 0 and 3");
        }
        CompoundTag compoundtag = stack.m_41784_();
        compoundtag.m_128405_(TAG_QUALITY, quality);
    }

    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(TAG_FOIL, false);
        tag.m_128405_(TAG_QUALITY, 3);
        return stack;
    }
}

