/*
 * Decompiled with CFR 0.152.
 */
package ccr4ft3r.appetite;

import ccr4ft3r.appetite.config.MainConfig;
import ccr4ft3r.appetite.config.ProfileConfig;
import ccr4ft3r.appetite.events.CompatibilityHandler;
import ccr4ft3r.appetite.events.ExhaustionHandler;
import ccr4ft3r.appetite.network.PacketHandler;
import ccr4ft3r.appetite.registry.ModItems;
import ccr4ft3r.appetite.registry.ModMobEffects;
import ccr4ft3r.appetite.registry.ModPotions;
import com.mojang.logging.LogUtils;
import fr.raksrinana.fallingtree.forge.event.FallingTreeBlockBreakEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="appetite")
public class Main {
    public Main() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::onConfigLoading);
        eventBus.addListener(this::onConfigReloading);
        Main.registerConfigs();
        Main.registerObjects();
        PacketHandler.registerMessages();
        Main.addCompatibilitiesListener();
    }

    private static void registerObjects() {
        ModMobEffects.register();
        ModPotions.register();
        ModItems.register();
    }

    private static void registerConfigs() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MainConfig.CONFIG, "appetite-common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ProfileConfig.CONFIG_PECKISH, "appetite/peckish-profile.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ProfileConfig.CONFIG_HUNGRY, "appetite/hungry-profile.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ProfileConfig.CONFIG_STARVING, "appetite/starving-profile.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ProfileConfig.CONFIG_CUSTOM, "appetite/custom-profile.toml");
    }

    private static void addCompatibilitiesListener() {
        if (ModList.get().isLoaded("paraglider")) {
            MinecraftForge.EVENT_BUS.addListener(CompatibilityHandler::onParagliding);
        }
        if (ModList.get().isLoaded("goprone") && Main.existsClass("tictim.paraglider.capabilities.PlayerMovement") && Main.existsClass("tictim.paraglider.capabilities.Caps")) {
            MinecraftForge.EVENT_BUS.addListener(CompatibilityHandler::onCrawling);
        }
        if (ModList.get().isLoaded("grapplemod") && Main.existsClass("com.yyon.grapplinghook.server.ServerControllerManager")) {
            MinecraftForge.EVENT_BUS.addListener(CompatibilityHandler::onPullingUp);
        }
        if (ModList.get().isLoaded("fallingtree") && Main.existsClass("fr.raksrinana.fallingtree.forge.event.FallingTreeBlockBreakEvent")) {
            ExhaustionHandler.INCLUDE_EVENT_PER_CLASS.put(FallingTreeBlockBreakEvent.class, () -> (Boolean)ProfileConfig.getProfile().enableChoppingTrees.get());
        }
        if (ModList.get().isLoaded("treechop") && Main.existsClass("ht.treechop.api.ChopEvent$FinishChopEvent")) {
            MinecraftForge.EVENT_BUS.addListener(CompatibilityHandler::onChoppingTree);
        }
    }

    private static boolean existsClass(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @SubscribeEvent
    public void onConfigLoading(ModConfigEvent.Loading configEvent) {
        LogUtils.getLogger().info("Loaded config {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public void onConfigReloading(ModConfigEvent.Reloading configEvent) {
        LogUtils.getLogger().info("Reloaded config {}", (Object)configEvent.getConfig().getFileName());
        ProfileConfig.updateChoosedProfile();
    }
}

