/*
 * Decompiled with CFR 0.152.
 */
package ccr4ft3r.appetite.config;

import ccr4ft3r.appetite.config.AppetiteProfile;
import ccr4ft3r.appetite.config.MainConfig;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;

public class ProfileConfig {
    private static final ForgeConfigSpec.Builder BUILDER_PECKISH = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder BUILDER_HUNGRY = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder BUILDER_STARVING = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder BUILDER_CUSTOM = new ForgeConfigSpec.Builder();
    private static final Data PROFILE_PECKISH = new Data(BUILDER_PECKISH, AppetiteProfile.PECKISH);
    private static final Data PROFILE_HUNGRY = new Data(BUILDER_HUNGRY, AppetiteProfile.HUNGRY);
    private static final Data PROFILE_STARVING = new Data(BUILDER_STARVING, AppetiteProfile.STARVING);
    private static final Data PROFILE_CUSTOM = new Data(BUILDER_CUSTOM, AppetiteProfile.CUSTOM);
    public static final ForgeConfigSpec CONFIG_PECKISH = BUILDER_PECKISH.build();
    public static final ForgeConfigSpec CONFIG_HUNGRY = BUILDER_HUNGRY.build();
    public static final ForgeConfigSpec CONFIG_STARVING = BUILDER_STARVING.build();
    public static final ForgeConfigSpec CONFIG_CUSTOM = BUILDER_CUSTOM.build();
    private static Data CURRENT_PROFILE;

    public static Data getProfile() {
        if (CURRENT_PROFILE == null) {
            ProfileConfig.updateChoosedProfile();
        }
        return CURRENT_PROFILE;
    }

    public static void updateChoosedProfile() {
        AppetiteProfile profile = (AppetiteProfile)((Object)MainConfig.CONFIG_DATA.profileToUse.get());
        switch (profile) {
            case CUSTOM: {
                CURRENT_PROFILE = PROFILE_CUSTOM;
                break;
            }
            case PECKISH: {
                CURRENT_PROFILE = PROFILE_PECKISH;
                break;
            }
            case HUNGRY: {
                CURRENT_PROFILE = PROFILE_HUNGRY;
                break;
            }
            case STARVING: {
                CURRENT_PROFILE = PROFILE_STARVING;
            }
        }
        LogUtils.getLogger().info("Exhaustion profile {} will be used for adding exhaustion.", (Object)profile);
    }

    public static class Data {
        public static final String ENABLE_WHILE = "Enable exhaustion while ";
        public static final String ENABLE_AT = "Enable exhaustion for ";
        public static final String AFTER_ACTION = "Decrease saturation or food bar value by 1 after ";
        public static final String AFTER_TIME = "Decrease saturation or food bar value by 1 after %s for X ticks";
        public ForgeConfigSpec.BooleanValue enableForShovelMineables;
        public ForgeConfigSpec.BooleanValue enableForAxeMineables;
        public ForgeConfigSpec.BooleanValue enableForPickaxeMineables;
        public ForgeConfigSpec.BooleanValue enableForTillingDirt;
        public ForgeConfigSpec.BooleanValue enableForPathingDirt;
        public ForgeConfigSpec.BooleanValue enableForStrippingLogs;
        public ForgeConfigSpec.BooleanValue enableForFishing;
        public ForgeConfigSpec.BooleanValue enableForAttacking;
        public ForgeConfigSpec.BooleanValue enableForBlocking;
        public ForgeConfigSpec.BooleanValue enableForPlacingBlocks;
        public ForgeConfigSpec.BooleanValue enableForTakingDamage;
        public ForgeConfigSpec.BooleanValue enableForShootingArrows;
        public ForgeConfigSpec.IntValue afterBreakingShovelMineables;
        public ForgeConfigSpec.IntValue afterBreakingAxeMineables;
        public ForgeConfigSpec.IntValue afterBreakingPickaxeMineables;
        public ForgeConfigSpec.IntValue afterTillingDirt;
        public ForgeConfigSpec.IntValue afterPathingDirt;
        public ForgeConfigSpec.IntValue afterStrippingLogs;
        public ForgeConfigSpec.IntValue afterFishing;
        public ForgeConfigSpec.IntValue afterAttacking;
        public ForgeConfigSpec.IntValue afterBlocking;
        public ForgeConfigSpec.IntValue afterPlacingBlocks;
        public ForgeConfigSpec.IntValue afterTakingDamage;
        public ForgeConfigSpec.IntValue afterShootingArrows;
        public ForgeConfigSpec.BooleanValue enableResting;
        public ForgeConfigSpec.BooleanValue enableSneaking;
        public ForgeConfigSpec.BooleanValue enableWalking;
        public ForgeConfigSpec.BooleanValue enableSwimming;
        public ForgeConfigSpec.BooleanValue enableSprinting;
        public ForgeConfigSpec.BooleanValue enablePaddling;
        public ForgeConfigSpec.BooleanValue enableClimbing;
        public ForgeConfigSpec.BooleanValue enableJumping;
        public ForgeConfigSpec.BooleanValue enableWalkingUp;
        public ForgeConfigSpec.IntValue afterResting;
        public ForgeConfigSpec.IntValue afterSwimming;
        public ForgeConfigSpec.IntValue afterSprinting;
        public ForgeConfigSpec.IntValue afterWalking;
        public ForgeConfigSpec.IntValue afterPaddling;
        public ForgeConfigSpec.IntValue afterSneaking;
        public ForgeConfigSpec.IntValue afterClimbing;
        public ForgeConfigSpec.IntValue afterJumping;
        public ForgeConfigSpec.IntValue afterWalkingUp;
        public ForgeConfigSpec.BooleanValue enableFreezing;
        public ForgeConfigSpec.IntValue afterFreezing;
        public ForgeConfigSpec.BooleanValue enableOpenClosing;
        public ForgeConfigSpec.IntValue afterOpenClosing;
        public ForgeConfigSpec.DoubleValue coldBiomeMultiplier;
        public ForgeConfigSpec.DoubleValue hotBiomeMultiplier;
        public ForgeConfigSpec.BooleanValue enableArmorImpactOnExhaustion;
        public ForgeConfigSpec.DoubleValue armorLogarithmicImpact;
        public ForgeConfigSpec.BooleanValue enableParagliding;
        public ForgeConfigSpec.IntValue afterParagliding;
        public ForgeConfigSpec.BooleanValue enableCrawling;
        public ForgeConfigSpec.IntValue afterCrawling;
        public ForgeConfigSpec.BooleanValue enablePullingUp;
        public ForgeConfigSpec.IntValue afterPullingUp;
        public ForgeConfigSpec.BooleanValue enableChoppingTrees;
        public ForgeConfigSpec.BooleanValue enableCarry;
        public ForgeConfigSpec.DoubleValue carryMultiplier;
        public ForgeConfigSpec.BooleanValue enableHungerLeveling;
        public ForgeConfigSpec.IntValue initialHungerbarMaximum;
        public ForgeConfigSpec.IntValue raisingHungerbarAfter;
        public ForgeConfigSpec.BooleanValue enableFoodRestore;
        public ForgeConfigSpec.IntValue minFoodLevelAfterRestore;
        public ForgeConfigSpec.IntValue foodLevelAfterDeath;
        public ForgeConfigSpec.BooleanValue hunger2LevelRelation;
        public ForgeConfigSpec.BooleanValue enableExhaustionAtTimeOfDay;
        public ForgeConfigSpec.ConfigValue<List<String>> exhaustionAtTimes;
        private Map<Long, Integer> exhaustionByTime;
        private final AppetiteProfile profile;
        private final ForgeConfigSpec.Builder builder;

        public int getInitalHungerbarMaximum() {
            return (Boolean)this.enableHungerLeveling.get() != false ? (Integer)this.initialHungerbarMaximum.get() : 10;
        }

        public Map<Long, Integer> getExhaustionByTime() {
            if (this.exhaustionByTime == null) {
                this.exhaustionByTime = ((List)this.exhaustionAtTimes.get()).stream().collect(Collectors.toMap(e -> Long.parseLong(e.split(":")[0]), e -> Integer.parseInt(e.split(":")[1]), (e1, e2) -> e1));
            }
            return this.exhaustionByTime;
        }

        public Data(ForgeConfigSpec.Builder builder, AppetiteProfile profile) {
            this.builder = builder;
            this.profile = profile;
            builder.comment("When setting the values, keep in mind that 20 ticks last one second (in the best case).\nSo if you want to drop the hunger bar by 1 after 10 seconds of walking, you have to specify 200 (10 seconds * 20 ticks/second = 200 ticks)");
            builder.push("Exhaustion for breaking blocks");
            this.enableForShovelMineables = this.define("Enable exhaustion for breaking blocks tagged with mineable/shovel (like dirt, sand, ...)", "enableForShovelMineables", true, true, true);
            this.enableForAxeMineables = this.define("Enable exhaustion for breaking blocks tagged with mineable/axe (like logs, planks, ...)", "enableForAxeMineables", true, true, true);
            this.enableForPickaxeMineables = this.define("Enable exhaustion for breaking blocks tagged with mineable/pickaxe (like stone, ores, ...)", "enableForPickaxeMineables", true, true, true);
            this.afterBreakingShovelMineables = this.defineRange("Decrease saturation or food bar value by 1 after breaking X blocks tagged with mineable/shovel (like dirt, sand, ...)", "afterBreakingShovelMineables", 1, 1600, 120, 80, 60);
            this.afterBreakingAxeMineables = this.defineRange("Decrease saturation or food bar value by 1 after breaking X blocks tagged with mineable/axe (like logs, planks, ...)", "afterBreakingAxeMineables", 1, 1600, 100, 70, 50);
            this.afterBreakingPickaxeMineables = this.defineRange("Decrease saturation or food bar value by 1 after breaking X blocks tagged with mineable/pickaxe (like stone, ores, ...)", "afterBreakingPickaxeMineables", 1, 1600, 80, 60, 40);
            builder.pop();
            builder.push("Exhaustion for modifying blocks");
            this.enableForTillingDirt = this.define("Enable exhaustion for tilling dirt blocks", "enableForTillingDirt", true, true, true);
            this.enableForPathingDirt = this.define("Enable exhaustion for pathing dirt blocks", "enableForPathingDirt", true, true, true);
            this.enableForStrippingLogs = this.define("Enable exhaustion for stripping logs", "enableForStrippingLogs", true, true, true);
            this.afterTillingDirt = this.define("Decrease saturation or food bar value by 1 after tilling X dirt blocks", "afterTillingDirt", 120, 100, 80);
            this.afterPathingDirt = this.define("Decrease saturation or food bar value by 1 after pathing X dirt blocks", "afterPathingDirt", 120, 100, 80);
            this.afterStrippingLogs = this.define("Decrease saturation or food bar value by 1 after stripping X logs", "afterStrippingLogs", 120, 100, 80);
            builder.pop();
            builder.push("Exhaustion for Fights");
            this.enableForAttacking = this.define("Enable exhaustion for attacking entities", "enableForAttackingEntities", false, true, true);
            this.enableForBlocking = this.define("Enable exhaustion for blocking an attack with a shield", "enableForBlockingAttacks", false, true, true);
            this.enableForTakingDamage = this.define("Enable exhaustion for taking damage", "enableForTakingDamage", false, true, true);
            this.enableForShootingArrows = this.define("Enable exhaustion for shooting arrows", "enableForShootingArrows", true, true, true);
            this.afterAttacking = this.defineRange("Decrease saturation or food bar value by 1 after landing X attacks on entities", "afterAttackingEntities", 1, 80, 100, 75, 50);
            this.afterBlocking = this.define("Decrease saturation or food bar value by 1 after blocking X attacks with shield", "afterBlockingAttacks", 100, 75, 50);
            this.afterTakingDamage = this.defineRange("Decrease saturation or food bar value by 1 after taking damage X times", "afterTakingDamage", 1, 80, 100, 75, 50);
            this.afterShootingArrows = this.define("Decrease saturation or food bar value by 1 after shooting X arrows", "afterShootingArrows", 120, 75, 50);
            builder.pop();
            builder.push("Exhaustion for Interaction");
            this.afterPlacingBlocks = this.define("Decrease saturation or food bar value by 1 after placing X blocks", "afterPlacingBlocks", 200, 100, 75);
            this.enableForPlacingBlocks = this.define("Enable exhaustion for placing blocks", "enableForPlacingBlocks", false, true, true);
            this.enableForFishing = this.define("Enable exhaustion for fishing items", "enableForFishing", true, true, true);
            this.afterFishing = this.define("Decrease saturation or food bar value by 1 after fishing X items", "afterFishing", 60, 40, 20);
            this.enableOpenClosing = this.define("Enable exhaustion for open and closing doors/trapdoors/gates/chests (without closing chests)", "enableForOpenAndClosing", false, true, true);
            this.afterOpenClosing = this.define("Decrease saturation or food bar value by 1 after open and closing X doors/trapdoors/gates/chests", "afterOpenAndClosing", 180, 90, 60);
            builder.pop();
            builder.push("Exhaustion for Movement");
            this.enableResting = this.define("Enable exhaustion while resting (standing still, sitting, ...)", "enableWhileResting", false, false, true);
            this.enableSneaking = this.define("Enable exhaustion while sneaking", "enableWhileSneaking", true, true, true);
            this.enableWalking = this.define("Enable exhaustion while walking", "enableWhileWalking", false, true, true);
            this.enableSwimming = this.define("Enable exhaustion while swimming", "enableWhileSwimming", true, true, true);
            this.enableSprinting = this.define("Enable exhaustion while sprinting", "enableWhileSprinting", true, true, true);
            this.enablePaddling = this.define("Enable exhaustion while paddling", "enableWhilePaddling", false, true, true);
            this.enableClimbing = this.define("Enable exhaustion while climbing", "enableWhileClimbing", true, true, true);
            this.enableJumping = this.define("Enable exhaustion while jumping", "enableForJumping", true, true, true);
            this.enableWalkingUp = this.define("Enable exhaustion while walking up (stairs & slabs)", "enableWhileWalkingUp", true, true, true);
            this.afterResting = this.defineTime(AFTER_TIME.formatted("resting"), "afterResting", 2400, 1200, 600);
            this.afterSneaking = this.defineTime(AFTER_TIME.formatted("sneaking"), "afterSneaking", 480, 240, 120);
            this.afterWalking = this.defineTime(AFTER_TIME.formatted("walking"), "afterWalking", 360, 160, 90);
            this.afterSwimming = this.defineTime(AFTER_TIME.formatted("swimming"), "afterSwimming", 240, 100, 60);
            this.afterSprinting = this.defineTimeRange(AFTER_TIME.formatted("sprinting"), "afterSprinting", 1, 14, 14, 12, 10);
            this.afterPaddling = this.defineTime(AFTER_TIME.formatted("paddling"), "afterPaddling", 180, 120, 80);
            this.afterClimbing = this.defineTime(AFTER_TIME.formatted("climbing"), "afterClimbing", 120, 80, 40);
            this.afterJumping = this.defineRange("Decrease saturation or food bar value by 1 after jumping X times", "afterJumping", 1, 160, 160, 80, 40);
            this.afterWalkingUp = this.defineTime(AFTER_TIME.formatted("walking up (stairs & slabs)"), "afterWalkingUp", 240, 120, 70);
            builder.pop();
            builder.push("Exhaustion for States");
            this.enableFreezing = this.define("Enable exhaustion while freezing (while being inside powder snow)", "enableWhileFreezing", false, false, true);
            this.afterFreezing = this.defineTime(AFTER_TIME.formatted("freezing (while being inside powder snow)"), "afterFreezing", 60, 30, 15);
            builder.pop();
            builder.push("Exhaustion for other mods");
            this.enableParagliding = this.define("Enable exhaustion while paragliding (Paragliders Mod)", "enableWhileParagliding", true, true, true);
            this.afterParagliding = this.defineTime(AFTER_TIME.formatted("paragliding (Paragliders Mod)"), "afterParagliding", 180, 120, 90);
            this.enableCrawling = this.define("Enable exhaustion while crawling (GoProne Mod)", "enableWhileCrawling", true, true, true);
            this.afterCrawling = this.defineTime(AFTER_TIME.formatted("crawling (GoProne Mod)"), "afterCrawling", 150, 90, 60);
            this.enablePullingUp = this.define(AFTER_TIME.formatted("pulling yourself up (Grappling Hook Mod)"), "enableWhilePullingUp", true, true, true);
            this.afterPullingUp = this.defineTime(AFTER_TIME.formatted("pulling yourself up (Grappling Hook Mod"), "afterPullingUp", 28, 14, 7);
            this.enableChoppingTrees = this.define("Enable exhaustion for chopping trees (Falling Tree Mod, HT's TreeChop mod). For changing the exhaustion see: afterBreakingAxeMineables", "enableForChoppingTrees", true, true, true);
            this.enableCarry = this.define("Enable exhaustion while carrying objects (Carry on Mod", "enableForCarryingObjects", true, true, true);
            this.carryMultiplier = this.defineRange("Sets the multiplier for exhaustion when carrying objects (Carry On Mod)", "carryMultiplier", 1.0, 10.0, 1.5, 2.0, 2.75);
            builder.pop();
            builder.push("Hunger leveling");
            this.enableHungerLeveling = this.define("Provides the option to lower the initial maximum of the player's hunger bar. The defined maximum can be increased by leveling up (by gaining experience).", "enableHungerLeveling", false, true, true);
            this.initialHungerbarMaximum = this.defineRange("Determines the hunger indicator (drumstick amount) each player starts with when joining a world for the first time (vanilla's default is 10).", "initialHungerbarMaximum", 1, 10, 10, 7, 5);
            this.raisingHungerbarAfter = this.defineRange("Determines what level delta is needed to increase the initialHungerbarMaximum by one drumstick.", "raisingHungerbarAfter", 1, 20, 3, 6, 7);
            this.hunger2LevelRelation = this.define("Determines whether a level decrease down to the latest level, that caused a hunger bar increase, should lead to a hunger bar decrease.", "hunger2LevelRelation", false, false, true);
            builder.pop();
            builder.push("Exhaustion by time of day");
            this.enableExhaustionAtTimeOfDay = this.define("Determines whether players should receive exhaustion at a certain time of day", "enableExhaustionAtTimeOfDay", false, false, false);
            this.exhaustionAtTimes = builder.comment("Defines the points in time (in ticks) at which players should get a constant exhaustion (hunger points). If you want to force players to have a breakfast, you can add the following entry: 1000:6 -> This will drop the hunger bar by 3 drumsticks (6 hunger points) each day at 07:00 am (at 1000 ticks).").define("exhaustionAtTimes", new ArrayList(), s -> s instanceof List && ((List)s).stream().allMatch(d -> d != null && d.toString().matches("^\\d{1,5}:\\d{1,2}$")));
            builder.pop();
            builder.push("Advanced Settings");
            this.enableFoodRestore = this.define("Defines whether food stats (exhaustion, saturation, food level, ...) should be restored after death.", "enableFoodRestore", false, true, true);
            this.minFoodLevelAfterRestore = this.defineRange("Defines the minimum food level that players get after their death. Only takes place if enableFoodRestore is enabled.", "minFoodLevelAfterRestore", 1, 20, 18, 10, 8);
            this.foodLevelAfterDeath = this.defineRange("Defines the food level that players get after their death. When set, minFoodLevelAfterRestore will be ignored. Setting this option to -1 disables it.", "foodLevelAfterDeath", -1, 20, -1, -1, -1);
            this.coldBiomeMultiplier = this.defineRange("Sets the multiplier for exhaustion caused by the rules of Appetite when the player is in a cold biome", "coldBiomeMultiplier", 1.0, 10.0, 1.0, 1.0, 1.0);
            this.hotBiomeMultiplier = this.defineRange("Sets the multiplier for exhaustion caused by the rules of Appetite when the player is in a hot biome", "hotBiomeMultiplier", 1.0, 10.0, 1.0, 1.0, 1.0);
            this.enableArmorImpactOnExhaustion = this.define("Determines that each armor wil have an individual impact on the added exhaustion. Lighter armor will have an lower impact and heavier armor an higher impact. When enabling this option keep in mind that each exhaustion rule will consider the logarithmic multiplier and therefore will slightly differ from the specified value.", "ArmorImpactOnExhaustion", false, false, false);
            this.armorLogarithmicImpact = this.defineRange("Appetite is using the logarithm as a multiplier to modify the exhaustion defined by the rules, depending on the armor defense points. This value defines the logarithmic base whereas the defense points will be used as the numerus. The higher the value the higher the reward (lower exhaustion) for wearing lighter armor but the lower the additional exhaustion for heavier armor. The lower the value the higher the exhaustion for wearing heavy armor but the lower the reward for wearing lighter armor.\nExample for rewarding the player (default mode): Wearing leather armor (numerus = 7) for the defined impact of 12 (base) leads to an multiplier of 0.78 (22% fewer exhaustion). Wearing diamond armor (numerus = 20) for the same impact leads to a multiplier of 1.2 (20% higher exhaustion). A calculated multiplier for leather armor lower than 1 is also used when the player is wearing no armor.\nExample for higher difficulty: Wearing leather armor for the defined impact of 6 leads to an multiplier of 1.09 (9% more exhaustion). Wearing diamond armor for the same impact leads to a multiplier of 1.67 (67% higher exhaustion).", "armorLogarithmicImpact", 6.0, 20.0, 15.0, 12.0, 7.0);
        }

        private ForgeConfigSpec.BooleanValue define(String comment, String property, boolean ... profileValues) {
            return this.builder.comment(comment).define(property, this.get(profileValues));
        }

        private ForgeConfigSpec.IntValue defineRange(String comment, String property, Integer min, Integer max, Integer ... profileValues) {
            return this.builder.comment(comment).defineInRange(property, this.get(profileValues).intValue(), min.intValue(), max.intValue());
        }

        private ForgeConfigSpec.IntValue define(String comment, String property, Integer ... profileValues) {
            return this.defineRange(comment, property, 1, Integer.MAX_VALUE, profileValues);
        }

        private ForgeConfigSpec.DoubleValue define(String comment, String property, Double ... profileValues) {
            return this.defineRange(comment, property, 1.0, (Double)Double.MAX_VALUE, profileValues);
        }

        private ForgeConfigSpec.DoubleValue defineRange(String comment, String property, Double min, Double max, Double ... profileValues) {
            return this.builder.comment(comment).defineInRange(property, this.get(profileValues).doubleValue(), min.doubleValue(), max.doubleValue());
        }

        private ForgeConfigSpec.IntValue defineTime(String comment, String property, Integer ... seconds) {
            return this.builder.comment(comment).defineInRange(property, this.get(seconds) * 20, 20, Integer.MAX_VALUE);
        }

        private ForgeConfigSpec.IntValue defineTimeRange(String comment, String property, Integer min, Integer max, Integer ... seconds) {
            return this.builder.comment(comment).defineInRange(property, this.get(seconds) * 20, min * 20, max * 20);
        }

        private boolean get(boolean ... profileValues) {
            return profileValues.length <= this.profile.ordinal() ? profileValues[1] : profileValues[this.profile.ordinal()];
        }

        @SafeVarargs
        private <T> T get(T ... profileValues) {
            return profileValues.length <= this.profile.ordinal() ? profileValues[1] : profileValues[this.profile.ordinal()];
        }
    }
}

