/*
 * Decompiled with CFR 0.152.
 */
package ccr4ft3r.appetite.data.capabilities;

import ccr4ft3r.appetite.config.MainConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;

public class FrozenAppetiteCapability
implements INBTSerializable<CompoundTag> {
    private int dayToCheck;
    private int amountAddedToday;
    private boolean shouldEffectBeRemoved;

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("dayToCheck", (Tag)IntTag.m_128679_((int)this.dayToCheck));
        tag.m_128365_("amountAddedToday", (Tag)IntTag.m_128679_((int)this.amountAddedToday));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.dayToCheck = tag.m_128451_("dayToCheck");
        this.amountAddedToday = tag.m_128451_("amountAddedToday");
    }

    public void effectUsed(Level level) {
        if (this.amountAddedToday >= (Integer)MainConfig.CONFIG_DATA.frozenAppetitePerDay.get() || !this.isCheckingForToday(level)) {
            this.amountAddedToday = 0;
            this.dayToCheck = (int)(level.m_46468_() / 24000L);
        }
        ++this.amountAddedToday;
    }

    private boolean isCheckingForToday(Level level) {
        return level.m_46468_() / 24000L == (long)this.dayToCheck;
    }

    public boolean canUse(Level level) {
        return (this.amountAddedToday < (Integer)MainConfig.CONFIG_DATA.frozenAppetitePerDay.get() || !this.isCheckingForToday(level)) && (Boolean)MainConfig.CONFIG_DATA.allowFrozenAppetite.get() != false;
    }

    public boolean shouldEffectBeRemoved() {
        return this.shouldEffectBeRemoved;
    }

    public void setShouldEffectBeRemoved(boolean shouldEffectBeRemoved) {
        this.shouldEffectBeRemoved = shouldEffectBeRemoved;
    }
}

