/*
 * Decompiled with CFR 0.152.
 */
package ccr4ft3r.appetite.data.capabilities;

import ccr4ft3r.appetite.IFoodData;
import ccr4ft3r.appetite.config.ProfileConfig;
import ccr4ft3r.appetite.network.ClientboundCapabilityPacket;
import ccr4ft3r.appetite.network.PacketHandler;
import net.minecraft.advancements.Advancement;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.common.util.INBTSerializable;

public class HungerLevelingCapability
implements INBTSerializable<CompoundTag> {
    private int currentFoodMaximum = ProfileConfig.getProfile().getInitalHungerbarMaximum();
    private int lastLevelOfIncrease;

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("currentFoodMaximum", (Tag)IntTag.m_128679_((int)this.currentFoodMaximum));
        tag.m_128365_("lastLevelOfIncrease", (Tag)IntTag.m_128679_((int)this.lastLevelOfIncrease));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.currentFoodMaximum = tag.m_128451_("currentFoodMaximum");
        this.lastLevelOfIncrease = tag.m_128451_("lastLevelOfIncrease");
    }

    public void setCurrentFoodMaximum(int currentFoodMaximum) {
        this.currentFoodMaximum = currentFoodMaximum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFoodMax(ServerPlayer player, int levelDelta) {
        try {
            if (!((Boolean)ProfileConfig.getProfile().enableHungerLeveling.get()).booleanValue()) {
                return;
            }
            boolean hungerChanged = false;
            if (levelDelta == 1) {
                if (player.f_36078_ >= this.lastLevelOfIncrease + (Integer)ProfileConfig.getProfile().raisingHungerbarAfter.get() && this.getCurrentFoodMaximum() < 10) {
                    ++this.currentFoodMaximum;
                    this.lastLevelOfIncrease = player.f_36078_;
                    hungerChanged = true;
                }
            } else if (player.f_36078_ + levelDelta < this.lastLevelOfIncrease && this.currentFoodMaximum > (Integer)ProfileConfig.getProfile().initialHungerbarMaximum.get()) {
                --this.currentFoodMaximum;
                this.lastLevelOfIncrease = player.f_36078_ - (Integer)ProfileConfig.getProfile().raisingHungerbarAfter.get();
                hungerChanged = true;
                this.updateFoodMax(player, levelDelta);
            }
            if (hungerChanged) {
                PlayerAdvancements advancements = player.m_8960_();
                Advancement levelUpAdvancement = player.m_20203_().getAdvancement(new ResourceLocation("appetite", levelDelta > 0 ? "level_up" : "level_down"));
                advancements.m_135996_(levelUpAdvancement).m_8209_("requirement");
                advancements.m_135988_(levelUpAdvancement, "requirement");
            }
        }
        finally {
            FoodData foodData = player.m_36324_();
            if (foodData instanceof IFoodData) {
                IFoodData iFoodData = (IFoodData)foodData;
                iFoodData.setFoodbarMax(this.getCurrentFoodMaximum());
                PacketHandler.sendToPlayer(new ClientboundCapabilityPacket(this), player);
            }
        }
    }

    public int getCurrentFoodMaximum() {
        return (Boolean)ProfileConfig.getProfile().enableHungerLeveling.get() != false ? this.currentFoodMaximum : ProfileConfig.getProfile().getInitalHungerbarMaximum();
    }
}

