/*
 * Decompiled with CFR 0.152.
 */
package ccr4ft3r.appetite.events;

import ccr4ft3r.appetite.config.ProfileConfig;
import ccr4ft3r.appetite.data.ServerData;
import ccr4ft3r.appetite.data.ServerPlayerData;
import ccr4ft3r.appetite.util.PlayerUtil;
import com.yyon.grapplinghook.server.ServerControllerManager;
import ht.treechop.api.ChopEvent;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import tictim.paraglider.capabilities.Caps;
import tictim.paraglider.capabilities.PlayerMovement;

public class CompatibilityHandler {
    private static boolean shouldSkipTick(TickEvent.PlayerTickEvent event, Player player) {
        return player.f_19797_ % 20 != 0 || event.phase != TickEvent.Phase.END || player.m_9236_().m_5776_();
    }

    @SubscribeEvent
    public static void onParagliding(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (CompatibilityHandler.shouldSkipTick(event, player)) {
            return;
        }
        LazyOptional movement = player.getCapability(Caps.playerMovement);
        boolean isParagliding = movement.map(PlayerMovement::isParagliding).orElse(false);
        ServerData.getPlayerData(player).setParagliding(isParagliding);
        PlayerUtil.exhaust(event.player, ProfileConfig.getProfile().enableParagliding, isParagliding, ProfileConfig.getProfile().afterParagliding, 20L, 0.0f);
    }

    @SubscribeEvent
    public static void onCrawling(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (CompatibilityHandler.shouldSkipTick(event, player)) {
            return;
        }
        boolean hasCrawlPos = !player.m_20077_() && !player.m_20069_() && player.m_20089_() == Pose.SWIMMING;
        ServerPlayerData playerData = ServerData.getPlayerData(player);
        boolean isCrawling = hasCrawlPos && playerData.isMoving() && !player.m_20182_().equals((Object)playerData.getLastPosition());
        ServerData.getPlayerData(player).setCrawling(isCrawling);
        PlayerUtil.exhaust(event.player, ProfileConfig.getProfile().enableCrawling, isCrawling, ProfileConfig.getProfile().afterCrawling, 20L, 0.0f);
    }

    @SubscribeEvent
    public static void onPullingUp(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (CompatibilityHandler.shouldSkipTick(event, player)) {
            return;
        }
        ServerPlayerData playerData = ServerData.getPlayerData(player);
        boolean isUpward = playerData.isMoving() && playerData.getLastPosition() != null && player.m_20182_().f_82480_ > playerData.getLastPosition().f_82480_;
        boolean isPullingUp = isUpward && ServerControllerManager.attached.contains(player.m_19879_());
        ServerData.getPlayerData(player).setPullingUp(isPullingUp);
        PlayerUtil.exhaust(player, ProfileConfig.getProfile().enablePullingUp, isPullingUp, ProfileConfig.getProfile().afterPullingUp, 20L, 0.0f);
    }

    @SubscribeEvent
    public static void onChoppingTree(ChopEvent.FinishChopEvent event) {
        if (event.getLevel().m_5776_() || event.getPlayer() == null || event.getFelled()) {
            return;
        }
        PlayerUtil.exhaust(event.getPlayer(), ProfileConfig.getProfile().enableChoppingTrees, true, ProfileConfig.getProfile().afterBreakingAxeMineables, 1L, 0.0f);
    }
}

