/*
 * Decompiled with CFR 0.152.
 */
package ccr4ft3r.appetite.events;

import ccr4ft3r.appetite.IFoodData;
import ccr4ft3r.appetite.config.MainConfig;
import ccr4ft3r.appetite.config.ProfileConfig;
import ccr4ft3r.appetite.data.ServerData;
import ccr4ft3r.appetite.data.ServerPlayerData;
import ccr4ft3r.appetite.util.PlayerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="appetite")
public class ExhaustionHandler {
    public static final Map<Class<?>, BooleanSupplier> INCLUDE_EVENT_PER_CLASS = new HashMap();

    @SubscribeEvent
    public static void onPlayerBreakBlock(BlockEvent.BreakEvent event) {
        if (PlayerUtil.cannotBeExhausted(event.getPlayer()) || event.isCanceled() || !INCLUDE_EVENT_PER_CLASS.getOrDefault(event.getClass(), () -> true).getAsBoolean()) {
            return;
        }
        BlockState blockState = event.getState();
        PlayerUtil.exhaust(event.getPlayer(), ProfileConfig.getProfile().enableForShovelMineables, blockState.m_204336_(BlockTags.f_144283_), ProfileConfig.getProfile().afterBreakingShovelMineables, 1L, 0.005f);
        PlayerUtil.exhaust(event.getPlayer(), ProfileConfig.getProfile().enableForAxeMineables, blockState.m_204336_(BlockTags.f_144280_), ProfileConfig.getProfile().afterBreakingAxeMineables, 1L, 0.005f);
        PlayerUtil.exhaust(event.getPlayer(), ProfileConfig.getProfile().enableForPickaxeMineables, blockState.m_204336_(BlockTags.f_144282_), ProfileConfig.getProfile().afterBreakingPickaxeMineables, 1L, 0.005f);
    }

    @SubscribeEvent
    public static void onArrowShooted(ArrowLooseEvent event) {
        PlayerUtil.exhaust(event.getEntity(), ProfileConfig.getProfile().enableForShootingArrows, true, ProfileConfig.getProfile().afterShootingArrows, 1L, 0.0f);
    }

    @SubscribeEvent
    public static void onPlayerModifiyBlock(BlockEvent.BlockToolModificationEvent event) {
        if (PlayerUtil.cannotBeExhausted(event.getPlayer()) || event.isCanceled()) {
            return;
        }
        PlayerUtil.exhaust(event.getPlayer(), ProfileConfig.getProfile().enableForTillingDirt, event.getHeldItemStack().m_41720_() instanceof HoeItem && event.getState().m_204336_(BlockTags.f_144274_), ProfileConfig.getProfile().afterTillingDirt, 1L, 0.0f);
        PlayerUtil.exhaust(event.getPlayer(), ProfileConfig.getProfile().enableForPathingDirt, event.getHeldItemStack().m_41720_() instanceof ShovelItem && event.getState().m_204336_(BlockTags.f_144274_), ProfileConfig.getProfile().afterPathingDirt, 1L, 0.0f);
        PlayerUtil.exhaust(event.getPlayer(), ProfileConfig.getProfile().enableForStrippingLogs, event.getHeldItemStack().m_41720_() instanceof AxeItem && event.getState().m_204336_(BlockTags.f_13106_), ProfileConfig.getProfile().afterStrippingLogs, 1L, 0.0f);
    }

    @SubscribeEvent
    public static void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        block3: {
            block2: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (!event.isCanceled()) break block3;
            }
            return;
        }
        PlayerUtil.exhaust(player, ProfileConfig.getProfile().enableJumping, !player.m_20069_() && !player.m_6147_(), ProfileConfig.getProfile().afterJumping, 1L, 0.05f);
    }

    @SubscribeEvent
    public static void onPlayerFishedItem(ItemFishedEvent event) {
        if (event.isCanceled()) {
            return;
        }
        PlayerUtil.exhaust(event.getEntity(), ProfileConfig.getProfile().enableForFishing, !event.getDrops().isEmpty(), ProfileConfig.getProfile().afterFishing, 1L, 0.0f);
    }

    @SubscribeEvent
    public static void onPlayerBlocks(ShieldBlockEvent event) {
        Player player;
        block3: {
            block2: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (!event.isCanceled()) break block3;
            }
            return;
        }
        PlayerUtil.exhaust(player, ProfileConfig.getProfile().enableForBlocking, true, ProfileConfig.getProfile().afterBlocking, 1L, 0.0f);
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        if (event.isCanceled()) {
            return;
        }
        PlayerUtil.exhaust(event.getEntity(), ProfileConfig.getProfile().enableForAttacking, true, ProfileConfig.getProfile().afterAttacking, 1L, 0.1f);
    }

    @SubscribeEvent
    public static void onPlayerPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        Player player;
        block5: {
            block4: {
                Entity entity = event.getEntity();
                if (!(entity instanceof Player)) break block4;
                player = (Player)entity;
                if (!event.isCanceled()) break block5;
            }
            return;
        }
        if (player.m_21205_().m_41720_() instanceof DiggerItem) {
            return;
        }
        PlayerUtil.exhaust(player, ProfileConfig.getProfile().enableForPlacingBlocks, true, ProfileConfig.getProfile().afterPlacingBlocks, 1L, 0.0f);
    }

    @SubscribeEvent
    public static void onPlayerHurted(LivingHurtEvent event) {
        Player player;
        block3: {
            block2: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (event.getAmount() != 0.0f && !event.isCanceled()) break block3;
            }
            return;
        }
        PlayerUtil.exhaust(player, ProfileConfig.getProfile().enableForTakingDamage, true, ProfileConfig.getProfile().afterTakingDamage, 1L, 0.1f);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Integer exhaustion;
        Player player = event.player;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (((Boolean)ProfileConfig.getProfile().enableExhaustionAtTimeOfDay.get()).booleanValue() && !PlayerUtil.cannotBeExhaustedOverTime(player) && (exhaustion = ProfileConfig.getProfile().getExhaustionByTime().get(player.f_19853_.m_46468_())) != null && PlayerUtil.canApplyExhaustion(player)) {
            player.m_36399_((float)exhaustion.intValue() * (4.0f * ((float)((IFoodData)player.m_36324_()).getFoodbarMax() / 10.0f)));
        }
        if (player.f_19797_ % 20 != 0) {
            return;
        }
        if (!PlayerUtil.cannotBeExhaustedOverTime(player)) {
            PlayerUtil.exhaust(player, (Integer)MainConfig.CONFIG_DATA.generalExhaustionAfterTicks.get() != 0, MainConfig.CONFIG_DATA.generalExhaustionAfterTicks, 20L, 0.0f, true);
        }
        if (PlayerUtil.cannotBeExhausted(player)) {
            return;
        }
        ServerPlayerData playerData = ServerData.getPlayerData(player);
        boolean isMoving = playerData.isMoving() && !player.m_20182_().equals((Object)playerData.getLastPosition());
        boolean isUpward = playerData.getLastPosition() != null && player.m_20182_().f_82480_ > playerData.getLastPosition().f_82480_;
        playerData.setLastPosition(player.m_20182_());
        if (player.m_203117_()) {
            PlayerUtil.exhaust(player, ProfileConfig.getProfile().enableFreezing, true, ProfileConfig.getProfile().afterFreezing, 20L, 0.0f);
        } else {
            PlayerUtil.exhaust(player, ProfileConfig.getProfile().enableResting, !isMoving, ProfileConfig.getProfile().afterResting, 20L, 0.0f);
        }
        if (!isMoving || playerData.isCrawling() || playerData.isParagliding() || playerData.isPullingUp()) {
            return;
        }
        boolean isInVehicle = player.m_20202_() != null;
        boolean isClimbing = player.m_6147_();
        boolean isPaddling = isInVehicle && player.m_20202_() instanceof Boat;
        boolean isSwimming = player.m_20069_() && !isInVehicle && !isClimbing;
        boolean isSneaking = player.m_6047_() && !isClimbing;
        boolean isSprinting = player.m_20142_() && !isSwimming && !isInVehicle && !isSneaking && !isClimbing;
        boolean isWalking = !isSwimming && !isInVehicle && !isSneaking && !isSprinting && !isClimbing;
        boolean isWalkingUp = isWalking && isUpward;
        PlayerUtil.exhaust(player, ProfileConfig.getProfile().enableSneaking, isSneaking, ProfileConfig.getProfile().afterSneaking, 20L, 0.0f);
        PlayerUtil.exhaust(player, ProfileConfig.getProfile().enableWalking, isWalking && !isWalkingUp, ProfileConfig.getProfile().afterWalking, 20L, 0.0f);
        PlayerUtil.exhaust(player, ProfileConfig.getProfile().enableWalkingUp, isWalkingUp, ProfileConfig.getProfile().afterWalkingUp, 20L, 0.0f);
        PlayerUtil.exhaust(player, ProfileConfig.getProfile().enableSwimming, isSwimming, ProfileConfig.getProfile().afterSwimming, 20L, 0.01f);
        PlayerUtil.exhaust(player, ProfileConfig.getProfile().enableSprinting, isSprinting, ProfileConfig.getProfile().afterSprinting, 20L, 0.5714286f);
        PlayerUtil.exhaust(player, ProfileConfig.getProfile().enablePaddling, isPaddling, ProfileConfig.getProfile().afterPaddling, 20L, 0.0f);
        PlayerUtil.exhaust(player, ProfileConfig.getProfile().enableClimbing, isClimbing, ProfileConfig.getProfile().afterClimbing, 20L, 0.0f);
    }
}

