/*
 * Decompiled with CFR 0.152.
 */
package ccr4ft3r.appetite.events;

import ccr4ft3r.appetite.config.MainConfig;
import ccr4ft3r.appetite.items.FrozenFoodItem;
import ccr4ft3r.appetite.registry.ModItems;
import ccr4ft3r.appetite.registry.ModTags;
import ccr4ft3r.appetite.util.BiomeUtil;
import ccr4ft3r.appetite.util.PlayerUtil;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="appetite")
public class ItemEventHandler {
    @SubscribeEvent
    public static void onItemExpire(ItemExpireEvent event) {
        if (!((Boolean)MainConfig.CONFIG_DATA.enableFishFreezing.get()).booleanValue()) {
            return;
        }
        Level level = event.getEntity().m_9236_();
        if (event.isCanceled() || level.m_5776_()) {
            return;
        }
        ItemEntity itemEntity = event.getEntity();
        Item item = itemEntity.m_32055_().m_41720_();
        boolean isCold = BiomeUtil.isCold((Entity)itemEntity);
        RegistryObject<FrozenFoodItem> frozenFood = ModItems.FROZEN_FOOD_PER_FOOD_ITEM.get(item);
        if (frozenFood != null && isCold) {
            ItemEventHandler.replaceExpiredItem(event, itemEntity, (Item)frozenFood.get());
            level.m_5594_(null, itemEntity.m_20183_(), SoundEvents.f_12534_, SoundSource.BLOCKS, 0.5f, 1.0f);
        } else if (item instanceof FrozenFoodItem) {
            FrozenFoodItem frozenFoodItem = (FrozenFoodItem)item;
            if (!isCold) {
                ItemEventHandler.replaceExpiredItem(event, itemEntity, frozenFoodItem.getUnfrozenItem());
                level.m_5594_(null, itemEntity.m_20183_(), SoundEvents.f_12534_, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onItemDropped(EntityJoinLevelEvent event) {
        if (!((Boolean)MainConfig.CONFIG_DATA.enableFishFreezing.get()).booleanValue()) {
            return;
        }
        if (event.isCanceled() || event.getLevel().m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        Item item = itemEntity.m_32055_().m_41720_();
        boolean isCold = BiomeUtil.isCold((Entity)itemEntity);
        if (ModItems.FROZEN_FOOD_PER_FOOD_ITEM.get(item) != null && isCold || item instanceof FrozenFoodItem && !isCold) {
            itemEntity.lifespan = (Integer)MainConfig.CONFIG_DATA.ticksToFreezeOrMelt.get();
        }
    }

    @SubscribeEvent
    public static void onCompletedUsingItem(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (!event.getItem().m_204117_(ModTags.IS_FROZEN_FOOD)) {
            return;
        }
        PlayerUtil.initiateFrozenFoodEffect((Player)player);
    }

    private static void replaceExpiredItem(ItemExpireEvent event, ItemEntity itemEntity, Item replaceWith) {
        itemEntity.m_32045_(new ItemStack((ItemLike)replaceWith, itemEntity.m_32055_().m_41613_()));
        event.setExtraLife(6000);
        event.setCanceled(true);
    }
}

