/*
 * Decompiled with CFR 0.152.
 */
package ccr4ft3r.appetite.events;

import ccr4ft3r.appetite.config.MainConfig;
import ccr4ft3r.appetite.config.ProfileConfig;
import ccr4ft3r.appetite.data.ServerData;
import ccr4ft3r.appetite.data.capabilities.AppetiteCapabilityProvider;
import ccr4ft3r.appetite.data.capabilities.FrozenAppetiteCapability;
import ccr4ft3r.appetite.data.capabilities.HungerLevelingCapability;
import ccr4ft3r.appetite.data.capabilities.HungerLevelingProvider;
import ccr4ft3r.appetite.mixins.PlayerAccessor;
import ccr4ft3r.appetite.registry.ModMobEffects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import tschipp.carryon.common.carry.CarryOnDataManager;

@Mod.EventBusSubscriber(modid="appetite")
public class PlayerEventHandler {
    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        ServerData.forgetAbout(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerData.addMe(player);
        player.getCapability(HungerLevelingProvider.HUNGER_LEVELING_CAP).ifPresent(cap -> cap.updateFoodMax((ServerPlayer)player, 1));
        try {
            Class.forName("tschipp.carryon.common.carry.CarryOnDataManager");
            if (ModList.get().isLoaded("carryon")) {
                ServerData.getPlayerData(player).setCarrying(CarryOnDataManager.getCarryData((Player)player).isCarrying());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        event.getEntity().getCapability(HungerLevelingProvider.HUNGER_LEVELING_CAP).ifPresent(cap -> cap.updateFoodMax((ServerPlayer)event.getEntity(), 1));
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(FrozenAppetiteCapability.class);
        event.register(HungerLevelingCapability.class);
    }

    @SubscribeEvent
    public static void onAttachPlayerCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Player player;
        Object object = event.getObject();
        if (!(object instanceof Player) || (player = (Player)object).m_9236_().m_5776_()) {
            return;
        }
        if (!player.getCapability(AppetiteCapabilityProvider.FROZEN_APPETITE_CAP).isPresent()) {
            event.addCapability(new ResourceLocation("appetite", "appetite"), (ICapabilityProvider)new AppetiteCapabilityProvider());
        }
        if (!player.getCapability(HungerLevelingProvider.HUNGER_LEVELING_CAP).isPresent()) {
            event.addCapability(new ResourceLocation("appetite", "hunger_leveling"), (ICapabilityProvider)new HungerLevelingProvider());
        }
    }

    @SubscribeEvent
    public static void onFrozenAppetiteAdded(MobEffectEvent.Added event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_9236_().m_5776_() || event.getEffectInstance().m_19544_() != ModMobEffects.FROZEN_APPETITE.get()) {
            return;
        }
        ServerData.getPlayerData(player).setFoodData(player.m_36324_());
        player.getCapability(AppetiteCapabilityProvider.FROZEN_APPETITE_CAP, null).ifPresent(c -> {
            if (c.canUse(player.m_9236_())) {
                c.effectUsed(player.m_9236_());
            } else {
                c.setShouldEffectBeRemoved(true);
            }
        });
    }

    @SubscribeEvent
    public static void onCloned(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        if (((Boolean)ProfileConfig.getProfile().enableFoodRestore.get()).booleanValue()) {
            ((PlayerAccessor)event.getEntity()).setFoodData(event.getOriginal().m_36324_());
            ((PlayerAccessor)event.getEntity()).getFoodData().m_38705_(((Integer)ProfileConfig.getProfile().minFoodLevelAfterRestore.get()).intValue());
        }
        if ((Integer)ProfileConfig.getProfile().foodLevelAfterDeath.get() > -1) {
            ((PlayerAccessor)event.getEntity()).getFoodData().m_38705_(((Integer)ProfileConfig.getProfile().foodLevelAfterDeath.get()).intValue());
        }
        event.getEntity().getCapability(HungerLevelingProvider.HUNGER_LEVELING_CAP).ifPresent(o -> {
            event.getOriginal().reviveCaps();
            o.setCurrentFoodMaximum(event.getOriginal().getCapability(HungerLevelingProvider.HUNGER_LEVELING_CAP).map(HungerLevelingCapability::getCurrentFoodMaximum).orElse((Integer)ProfileConfig.getProfile().initialHungerbarMaximum.get()));
            event.getOriginal().invalidateCaps();
        });
    }

    @SubscribeEvent
    public static void onLevelingUp(PlayerXpEvent.PickupXp event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        event.getEntity().getCapability(HungerLevelingProvider.HUNGER_LEVELING_CAP).ifPresent(cap -> cap.updateFoodMax((ServerPlayer)event.getEntity(), 1));
    }

    @SubscribeEvent
    public static void onLevelChange(PlayerXpEvent.LevelChange event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (!((Boolean)ProfileConfig.getProfile().hunger2LevelRelation.get()).booleanValue()) {
            return;
        }
        if (event.getLevels() < 0) {
            event.getEntity().getCapability(HungerLevelingProvider.HUNGER_LEVELING_CAP).ifPresent(cap -> cap.updateFoodMax((ServerPlayer)event.getEntity(), event.getLevels()));
        }
    }

    @SubscribeEvent
    public static void onBrainFreezed(MobEffectEvent.Added event) {
        Player player;
        block7: {
            block6: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block6;
                player = (Player)livingEntity;
                if (event.getEffectInstance().m_19544_() == ModMobEffects.BRAIN_FREEZE.get() && !player.m_9236_().m_5776_()) break block7;
            }
            return;
        }
        boolean isFrozenAppetiteAlreadyAdded = player.m_21023_((MobEffect)ModMobEffects.FROZEN_APPETITE.get());
        boolean isFrozenAppetiteAllowed = (Boolean)MainConfig.CONFIG_DATA.allowFrozenAppetite.get();
        if (isFrozenAppetiteAlreadyAdded) {
            player.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new TranslatableContents("effect.appetite.brain_freeze.message2")), true);
        } else if (isFrozenAppetiteAllowed) {
            player.m_5661_((Component)MutableComponent.m_237204_((ComponentContents)new TranslatableContents("effect.appetite.brain_freeze.message1", new Object[]{"" + MainConfig.CONFIG_DATA.frozenAppetitePerDay.get()})), true);
        }
    }
}

