/*
 * Decompiled with CFR 0.152.
 */
package ccr4ft3r.appetite.network;

import ccr4ft3r.appetite.IFoodData;
import ccr4ft3r.appetite.data.ServerData;
import ccr4ft3r.appetite.data.capabilities.HungerLevelingCapability;
import ccr4ft3r.appetite.events.ClientHandler;
import ccr4ft3r.appetite.network.ClientboundCapabilityPacket;
import ccr4ft3r.appetite.network.ServerboundPacket;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = "1.0.0";
    private static final SimpleChannel SIMPLE_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("appetite", "main"), () -> "1.0.0", "1.0.0"::equals, "1.0.0"::equals);

    public static void registerMessages() {
        SIMPLE_CHANNEL.registerMessage(0, ServerboundPacket.class, ServerboundPacket::encodeOnClientSide, ServerboundPacket::new, PacketHandler::handle);
        SIMPLE_CHANNEL.registerMessage(1, ClientboundCapabilityPacket.class, ClientboundCapabilityPacket::encode, ClientboundCapabilityPacket::new, PacketHandler::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static void sendToServer(ServerboundPacket packet) {
        SIMPLE_CHANNEL.sendToServer((Object)packet);
    }

    public static void sendToPlayer(ClientboundCapabilityPacket packet, ServerPlayer player) {
        SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    private static void handle(ServerboundPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            switch (packet.getAction()) {
                case PLAYER_MOVING: {
                    ServerData.getPlayerData((Player)sender).setMoving(true);
                    break;
                }
                case PLAYER_STOP_MOVING: {
                    ServerData.getPlayerData((Player)sender).setMoving(false);
                }
            }
            context.setPacketHandled(true);
        });
    }

    public static void handle(ClientboundCapabilityPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            HungerLevelingCapability cap = new HungerLevelingCapability();
            cap.deserializeNBT(packet.getCapData());
            ClientHandler.PLAYER_DATA.setHungerbarMaximum(cap.getCurrentFoodMaximum());
            FoodData foodData = Minecraft.m_91087_().f_91074_.m_36324_();
            if (foodData instanceof IFoodData) {
                IFoodData iFoodData = (IFoodData)foodData;
                iFoodData.setFoodbarMax(cap.getCurrentFoodMaximum());
            }
            context.setPacketHandled(true);
        });
    }
}

