/*
 * Decompiled with CFR 0.152.
 */
package ccr4ft3r.appetite.util;

import ccr4ft3r.appetite.IFoodData;
import ccr4ft3r.appetite.config.MainConfig;
import ccr4ft3r.appetite.config.ProfileConfig;
import ccr4ft3r.appetite.data.ServerData;
import ccr4ft3r.appetite.data.capabilities.AppetiteCapabilityProvider;
import ccr4ft3r.appetite.data.capabilities.FrozenAppetiteCapability;
import ccr4ft3r.appetite.registry.ModMobEffects;
import ccr4ft3r.appetite.util.BiomeUtil;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerUtil {
    public static void exhaust(Player player, boolean onlyIf, ForgeConfigSpec.IntValue exhaustionAfter, long multiplier, float vanillaExhaustion, boolean canBeExhaustedAlreadyChecked) {
        if (!canBeExhaustedAlreadyChecked && PlayerUtil.cannotBeExhausted(player)) {
            return;
        }
        if (onlyIf && PlayerUtil.canApplyExhaustion(player)) {
            float appetiteExhaustion = 8.0f * ((float)((IFoodData)player.m_36324_()).getFoodbarMax() / 10.0f) * (float)multiplier * PlayerUtil.getExhaustionMultiplier(player) / (float)((Integer)exhaustionAfter.get()).intValue();
            float exhaustion = Math.max(appetiteExhaustion - vanillaExhaustion, 0.0f);
            if (((Boolean)MainConfig.CONFIG_DATA.enableExtendedLogging.get()).booleanValue()) {
                LogUtils.getLogger().info("Adding {} exhaustion to player '{}' due to rule '{}'", new Object[]{Float.valueOf(exhaustion), player.m_6302_(), String.join((CharSequence)".", exhaustionAfter.getPath())});
            }
            player.m_36399_(exhaustion);
        }
    }

    public static boolean canApplyExhaustion(Player player) {
        return PlayerUtil.getFrozenAppetiteEffect(player).map(FrozenAppetiteCapability::shouldEffectBeRemoved).orElse(false) == false;
    }

    public static LazyOptional<FrozenAppetiteCapability> getFrozenAppetiteEffect(Player player) {
        return player.getCapability(AppetiteCapabilityProvider.FROZEN_APPETITE_CAP, null);
    }

    public static void exhaust(Player player, ForgeConfigSpec.BooleanValue optionEnabled, boolean onlyIf, ForgeConfigSpec.IntValue exhaustionAfter, long multiplier, float vanillaExhaustion) {
        if (!((Boolean)optionEnabled.get()).booleanValue()) {
            return;
        }
        PlayerUtil.exhaust(player, onlyIf, exhaustionAfter, multiplier, vanillaExhaustion, false);
    }

    private static float getExhaustionMultiplier(Player player) {
        float logBase;
        float multiplier = 1.0f;
        if (BiomeUtil.isHot((Entity)player)) {
            multiplier *= ((Double)ProfileConfig.getProfile().hotBiomeMultiplier.get()).floatValue();
        }
        if (BiomeUtil.isCold((Entity)player)) {
            multiplier *= ((Double)ProfileConfig.getProfile().coldBiomeMultiplier.get()).floatValue();
        }
        if (ServerData.getPlayerData(player).isCarrying() && ((Boolean)ProfileConfig.getProfile().enableCarry.get()).booleanValue()) {
            multiplier *= ((Double)ProfileConfig.getProfile().carryMultiplier.get()).floatValue();
        }
        if (((Boolean)ProfileConfig.getProfile().enableArmorImpactOnExhaustion.get()).booleanValue() && (logBase = ((Double)ProfileConfig.getProfile().armorLogarithmicImpact.get()).floatValue()) > 0.0f) {
            double logDivisor = Math.log(logBase);
            int armorValue = player.m_21230_();
            if (logDivisor != 0.0 && armorValue >= 0) {
                multiplier = (float)((double)multiplier * (Math.log(armorValue == 0 ? 7.0 : (double)armorValue) / logDivisor));
            }
        }
        return multiplier == 0.0f ? 1.0f : multiplier;
    }

    public static boolean cannotBeExhaustedOverTime(Player player) {
        return player instanceof FakePlayer || player.m_9236_().m_5776_() || !player.isAddedToWorld() || player.m_7500_() || player.m_5833_() || !player.m_6084_() || ((List)MainConfig.CONFIG_DATA.dimensionBlacklist.get()).contains(player.m_9236_().m_46472_().m_135782_().toString());
    }

    public static boolean cannotBeExhausted(Player player) {
        return player instanceof FakePlayer || player.m_9236_().m_5776_() || !player.isAddedToWorld() || player.m_7500_() || player.m_5833_() || player.m_5803_() || !player.m_6084_() || ((List)MainConfig.CONFIG_DATA.dimensionBlacklist.get()).contains(player.m_9236_().m_46472_().m_135782_().toString()) || (Boolean)MainConfig.CONFIG_DATA.enablesRules.get() == false;
    }

    public static void initiateFrozenFoodEffect(Player player) {
        boolean shouldBeBrainfreezed;
        boolean isFrozenAppetiteAllowed = (Boolean)MainConfig.CONFIG_DATA.allowFrozenAppetite.get();
        boolean isFrozenAppetiteAlreadyAdded = player.m_21023_((MobEffect)ModMobEffects.FROZEN_APPETITE.get());
        boolean canFrozenAppetiteBeUsed = player.getCapability(AppetiteCapabilityProvider.FROZEN_APPETITE_CAP).map(c -> c.canUse(player.m_9236_())).orElse(false);
        boolean bl = shouldBeBrainfreezed = isFrozenAppetiteAlreadyAdded || !canFrozenAppetiteBeUsed;
        if (shouldBeBrainfreezed) {
            player.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.BRAIN_FREEZE.get(), 160));
        } else if (isFrozenAppetiteAllowed) {
            player.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.FROZEN_APPETITE.get(), 1200));
        }
    }
}

