/*
 * Decompiled with CFR 0.152.
 */
package de.nehlen.dungeons.more_spawners.block.logic;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1317;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1952;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class MoreSpawnerLogic {
    public static final String SPAWN_DATA_KEY = "SpawnData";
    private static final Logger LOGGER = LogUtils.getLogger();
    private int spawnDelay = 20;
    private class_6005<class_1952> spawnPotentials = class_6005.method_34971().method_34974();
    @Nullable
    private class_1952 spawnEntry;
    private double rotation;
    private double lastRotation;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    @Nullable
    private class_1297 renderedEntity;
    private int maxNearbyEntities = 6;
    private int requiredPlayerRange = 16;
    private int spawnRange = 4;

    public void setEntityId(class_1299<?> type, @Nullable class_1937 world, class_5819 random, class_2338 pos) {
        this.getSpawnEntry(world, random, pos).method_38093().method_10582("id", class_7923.field_41177.method_10221(type).toString());
    }

    private boolean isPlayerInRange(class_1937 world, class_2338 pos) {
        return world.method_18458((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, (double)this.getRequiredPlayerRange());
    }

    public void clientTick(class_1937 world, class_2338 pos) {
        if (!this.isPlayerInRange(world, pos)) {
            this.lastRotation = this.rotation;
        } else if (this.renderedEntity != null) {
            class_5819 random = world.method_8409();
            double d = (double)pos.method_10263() + random.method_43058();
            double e = (double)pos.method_10264() + random.method_43058();
            double f = (double)pos.method_10260() + random.method_43058();
            world.method_8406((class_2394)class_2398.field_11251, d, e, f, 0.0, 0.0, 0.0);
            world.method_8406((class_2394)class_2398.field_11240, d, e, f, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.lastRotation = this.rotation;
            this.rotation = (this.rotation + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void serverTick(class_3218 world, class_2338 pos) {
        if (!this.isPlayerInRange((class_1937)world, pos)) {
            return;
        }
        if (this.spawnDelay == -1) {
            this.updateSpawns((class_1937)world, pos);
        }
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
            return;
        }
        boolean bl = false;
        class_5819 random = world.method_8409();
        class_1952 mobSpawnerEntry = this.getSpawnEntry((class_1937)world, random, pos);
        for (int i = 0; i < this.getSpawnCount(); ++i) {
            class_1952.class_6542 customSpawnRules;
            class_2487 nbtCompound = mobSpawnerEntry.method_38093();
            Optional optional = class_1299.method_17684((class_2487)nbtCompound);
            if (optional.isEmpty()) {
                this.updateSpawns((class_1937)world, pos);
                return;
            }
            class_2499 nbtList = nbtCompound.method_10554("Pos", 6);
            int j = nbtList.size();
            double d = j >= 1 ? nbtList.method_10611(0) : (double)pos.method_10263() + (random.method_43058() - random.method_43058()) * (double)this.getSpawnRange() + 0.5;
            double e = j >= 2 ? nbtList.method_10611(1) : (double)(pos.method_10264() + random.method_43048(3) - 1);
            double f = j >= 3 ? nbtList.method_10611(2) : (double)pos.method_10260() + (random.method_43058() - random.method_43058()) * (double)this.getSpawnRange() + 0.5;
            double d2 = f;
            if (!world.method_18026(((class_1299)optional.get()).method_17683(d, e, f))) continue;
            class_2338 blockPos = class_2338.method_49637((double)d, (double)e, (double)f);
            if (mobSpawnerEntry.method_38097().isPresent() ? !((class_1299)optional.get()).method_5891().method_6136() && world.method_8407() == class_1267.field_5801 || !(customSpawnRules = (class_1952.class_6542)mobSpawnerEntry.method_38097().get()).comp_66().method_37955((Comparable)Integer.valueOf(world.method_8314(class_1944.field_9282, blockPos))) || !customSpawnRules.comp_67().method_37955((Comparable)Integer.valueOf(world.method_8314(class_1944.field_9284, blockPos))) : !class_1317.method_20638((class_1299)((class_1299)optional.get()), (class_5425)world, (class_3730)class_3730.field_16469, (class_2338)blockPos, (class_5819)world.method_8409())) continue;
            class_1297 entity2 = class_1299.method_17842((class_2487)nbtCompound, (class_1937)world, entity -> {
                entity.method_5808(d, e, f, entity.method_36454(), entity.method_36455());
                return entity;
            });
            if (entity2 == null) {
                this.updateSpawns((class_1937)world, pos);
                return;
            }
            int k = world.method_18467(entity2.getClass(), new class_238((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)(pos.method_10263() + 1), (double)(pos.method_10264() + 1), (double)(pos.method_10260() + 1)).method_1014((double)this.getSpawnRange())).size();
            if (k >= this.getMaxNearbyEntities()) {
                this.updateSpawns((class_1937)world, pos);
                return;
            }
            entity2.method_5808(entity2.method_23317(), entity2.method_23318(), entity2.method_23321(), random.method_43057() * 360.0f, 0.0f);
            if (entity2 instanceof class_1308) {
                class_1308 mobEntity = (class_1308)entity2;
                if (mobSpawnerEntry.method_38097().isEmpty() && !mobEntity.method_5979((class_1936)world, class_3730.field_16469) || !mobEntity.method_5957((class_4538)world)) continue;
                if (mobSpawnerEntry.method_38093().method_10546() == 1 && mobSpawnerEntry.method_38093().method_10573("id", 8)) {
                    ((class_1308)entity2).method_5943((class_5425)world, world.method_8404(entity2.method_24515()), class_3730.field_16469, null, null);
                }
            }
            if (!world.method_30736(entity2)) {
                this.updateSpawns((class_1937)world, pos);
                return;
            }
            world.method_20290(2004, pos, 0);
            world.method_33596(entity2, class_5712.field_28738, blockPos);
            if (entity2 instanceof class_1308) {
                ((class_1308)entity2).method_5990();
            }
            bl = true;
        }
        if (bl) {
            this.updateSpawns((class_1937)world, pos);
        }
    }

    private void updateSpawns(class_1937 world, class_2338 pos) {
        class_5819 random = world.field_9229;
        this.spawnDelay = this.getMaxSpawnDelay() <= this.getMinSpawnDelay() ? this.getMinSpawnDelay() : this.getMinSpawnDelay() + random.method_43048(this.getMaxSpawnDelay() - this.getMinSpawnDelay());
        this.spawnPotentials.method_34992(random).ifPresent(spawnPotential -> this.setSpawnEntry(world, pos, (class_1952)spawnPotential.method_34983()));
        this.sendStatus(world, pos, 1);
    }

    public void readNbt(@Nullable class_1937 world, class_2338 pos, class_2487 nbt) {
        this.spawnDelay = nbt.method_10568("Delay");
        boolean bl = nbt.method_10573(SPAWN_DATA_KEY, 10);
        if (bl) {
            class_1952 mobSpawnerEntry = class_1952.field_34460.parse((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562(SPAWN_DATA_KEY)).resultOrPartial(string -> LOGGER.warn("Invalid SpawnData: {}", string)).orElseGet(class_1952::new);
            this.setSpawnEntry(world, pos, mobSpawnerEntry);
        }
        if (nbt.method_10573("MinSpawnDelay", 99)) {
            this.minSpawnDelay = nbt.method_10568("MinSpawnDelay");
            this.maxSpawnDelay = nbt.method_10568("MaxSpawnDelay");
            this.spawnCount = nbt.method_10568("SpawnCount");
        }
        if (nbt.method_10573("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = nbt.method_10568("MaxNearbyEntities");
            this.requiredPlayerRange = nbt.method_10568("RequiredPlayerRange");
        }
        if (nbt.method_10573("SpawnRange", 99)) {
            this.spawnRange = nbt.method_10568("SpawnRange");
        }
        this.renderedEntity = null;
    }

    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10575("Delay", (short)this.spawnDelay);
        nbt.method_10575("MinSpawnDelay", (short)this.getMinSpawnDelay());
        nbt.method_10575("MaxSpawnDelay", (short)this.getMaxSpawnDelay());
        nbt.method_10575("SpawnCount", (short)this.getSpawnCount());
        nbt.method_10575("MaxNearbyEntities", (short)this.getMaxNearbyEntities());
        nbt.method_10575("RequiredPlayerRange", (short)this.getRequiredPlayerRange());
        nbt.method_10575("SpawnRange", (short)this.getSpawnRange());
        if (this.spawnEntry != null) {
            nbt.method_10566(SPAWN_DATA_KEY, (class_2520)class_1952.field_34460.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.spawnEntry).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
        }
        nbt.method_10566("SpawnPotentials", (class_2520)class_1952.field_34461.encodeStart((DynamicOps)class_2509.field_11560, this.spawnPotentials).result().orElseThrow());
        return nbt;
    }

    @Nullable
    public class_1297 getRenderedEntity(class_1937 world, class_5819 random, class_2338 pos) {
        if (this.renderedEntity == null) {
            class_2487 nbtCompound = this.getSpawnEntry(world, random, pos).method_38093();
            if (!nbtCompound.method_10573("id", 8)) {
                return null;
            }
            this.renderedEntity = class_1299.method_17842((class_2487)nbtCompound, (class_1937)world, Function.identity());
            if (nbtCompound.method_10546() != 1 || this.renderedEntity instanceof class_1308) {
                // empty if block
            }
        }
        return this.renderedEntity;
    }

    public boolean handleStatus(class_1937 world, int status) {
        if (status == 1) {
            if (world.field_9236) {
                this.spawnDelay = this.getMinSpawnDelay();
            }
            return true;
        }
        return false;
    }

    protected void setSpawnEntry(@Nullable class_1937 world, class_2338 pos, class_1952 spawnEntry) {
        this.spawnEntry = spawnEntry;
    }

    private class_1952 getSpawnEntry(@Nullable class_1937 world, class_5819 random, class_2338 pos) {
        if (this.spawnEntry != null) {
            return this.spawnEntry;
        }
        this.setSpawnEntry(world, pos, this.spawnPotentials.method_34992(random).map(class_6008.class_6010::method_34983).orElseGet(class_1952::new));
        return this.spawnEntry;
    }

    public abstract void sendStatus(class_1937 var1, class_2338 var2, int var3);

    public double getRotation() {
        return this.rotation;
    }

    public double getLastRotation() {
        return this.lastRotation;
    }

    public int getSpawnRange() {
        return this.spawnRange;
    }

    public int getRequiredPlayerRange() {
        return this.requiredPlayerRange;
    }

    public int getMaxNearbyEntities() {
        return this.maxNearbyEntities;
    }

    public int getSpawnCount() {
        return this.spawnCount;
    }

    public int getMaxSpawnDelay() {
        return this.maxSpawnDelay;
    }

    public int getMinSpawnDelay() {
        return this.minSpawnDelay;
    }
}

