/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.level.block.Block;

public class BlockPack {
    private final int maxMaterial;
    private final Map<Block, Float> priceMap;
    private final List<Block> blocks;
    public static Map<Block, Integer> revBlock = new HashMap<Block, Integer>();
    public static List<BlockPack> blockPacks = new ArrayList<BlockPack>();
    public String id;

    public BlockPack(int pMaxMaterial, String id) {
        this.maxMaterial = pMaxMaterial;
        this.priceMap = new HashMap<Block, Float>();
        this.blocks = new ArrayList<Block>();
        this.id = id;
        blockPacks.add(this);
    }

    public int getMaxMaterial() {
        return this.maxMaterial;
    }

    public float getPrice(Block block) {
        return this.priceMap.getOrDefault(block, Float.valueOf(-1.0f)).floatValue();
    }

    public BlockPack put(Block block, float price) {
        this.put(block, price, false);
        return this;
    }

    public BlockPack put(Block block, float price, boolean acceptOnly) {
        this.priceMap.put(block, Float.valueOf(price));
        if (!acceptOnly) {
            this.blocks.add(block);
            revBlock.put(block, this.blocks.size() - 1);
        }
        return this;
    }

    public Block getBlock(int n) {
        return this.blocks.get(n);
    }

    public int getBlockIndex(Block block) {
        return revBlock.getOrDefault(block, -1);
    }

    public int length() {
        return this.blocks.size();
    }
}

