/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks;

import com.bobvarioa.buildingpacks.BlockPack;
import com.bobvarioa.buildingpacks.BlockPackPacketHandler;
import com.bobvarioa.buildingpacks.BlockPackRenderer;
import com.bobvarioa.buildingpacks.BuildingPacks;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.network.PacketDistributor;

public class BlockPackItem
extends Item {
    public BlockPackItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public Component m_7626_(ItemStack pStack) {
        ResourceLocation id = ResourceLocation.m_135820_((String)pStack.m_41784_().m_128461_("id"));
        if (id == null) {
            return Component.m_237115_((String)"item.buildingpacks.pack");
        }
        return Component.m_237115_((String)("item.buildingpacks.pack." + id.m_214298_()));
    }

    public static BlockPack getData(ItemStack stack) {
        ResourceLocation id = ResourceLocation.m_135820_((String)stack.m_41784_().m_128461_("id"));
        if (id != null) {
            BlockPack blockPack = (BlockPack)BuildingPacks.BLOCK_PACKS.getValue(id);
            return blockPack;
        }
        return null;
    }

    public static int getMaxMaterial(ItemStack stack) {
        BlockPack blockPack = BlockPackItem.getData(stack);
        if (blockPack == null) {
            return 0;
        }
        return blockPack.getMaxMaterial();
    }

    public static float getMaterial(ItemStack stack) {
        return stack.m_41784_().m_128457_("material");
    }

    public boolean m_142522_(ItemStack pStack) {
        return true;
    }

    public static float addMaterial(ItemStack stack, float amount) {
        CompoundTag tag = stack.m_41784_();
        float mat = tag.m_128457_("material");
        float change = Mth.m_14036_((float)(mat + amount), (float)0.0f, (float)BlockPackItem.getMaxMaterial(stack));
        tag.m_128350_("material", change);
        return change;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return BlockPackRenderer.getInstance();
            }
        });
    }

    public static void handleScroll(InputEvent.MouseScrollingEvent event) {
        int sign = (int)Math.signum(event.getScrollDelta());
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (player.m_6047_() && stack.m_41720_() instanceof BlockPackItem) {
            CompoundTag tag = stack.m_41784_();
            int index = tag.m_128451_("index");
            if (sign > 0) {
                if (--index < 0) {
                    index = BlockPackItem.getData(stack).length() - 1;
                }
            } else if (sign < 0 && ++index >= BlockPackItem.getData(stack).length()) {
                index = 0;
            }
            tag.m_128405_("index", index);
            BlockPackPacketHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new BlockPackPacketHandler.IndexUpdatePacket(index));
            event.setCanceled(true);
        }
    }

    public static void pickBlock(InputEvent.InteractionKeyMappingTriggered event) {
        if (!event.isPickBlock()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof BlockPackItem) {
            CompoundTag tag = stack.m_41784_();
            HitResult hitResult = Minecraft.m_91087_().f_91077_;
            HitResult.Type hitresult$type = hitResult.m_6662_();
            if (hitresult$type == HitResult.Type.BLOCK) {
                BlockPos blockpos = ((BlockHitResult)hitResult).m_82425_();
                Level level = player.m_9236_();
                BlockState blockstate = level.m_8055_(blockpos);
                if (blockstate.m_60795_()) {
                    return;
                }
                Block block = blockstate.m_60734_();
                Inventory inventory = player.m_150109_();
                for (int i = 0; i < inventory.f_35974_.size(); ++i) {
                    BlockPack data;
                    int index;
                    ItemStack itemStack = (ItemStack)inventory.f_35974_.get(i);
                    if (!Inventory.m_36045_((int)i) || !(itemStack.m_41720_() instanceof BlockPackItem) || (index = (data = BlockPackItem.getData(itemStack)).getBlockIndex(block)) == -1) continue;
                    inventory.f_35977_ = i;
                    tag.m_128405_("index", index);
                    BlockPackPacketHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new BlockPackPacketHandler.IndexUpdatePacket(index));
                    event.setCanceled(true);
                    break;
                }
            }
        }
    }

    public static void pickupItem(EntityItemPickupEvent event) {
        Player player = event.getEntity();
        Inventory inventory = player.m_150109_();
        ItemStack stack = event.getItem().m_32055_();
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            Block block = item2.m_40614_();
            block0: for (int i = 0; i < inventory.f_35974_.size(); ++i) {
                ItemStack itemStack = (ItemStack)inventory.f_35974_.get(i);
                if (!(itemStack.m_41720_() instanceof BlockPackItem)) continue;
                BlockPack data = BlockPackItem.getData(itemStack);
                float mat = BlockPackItem.getMaterial(itemStack);
                float price = data.getPrice(block);
                if (price == -1.0f) continue;
                for (int j = 1; j < stack.m_41613_() + 1; ++j) {
                    if (!(mat + price <= (float)data.getMaxMaterial())) {
                        stack.m_41764_(0);
                        event.setCanceled(true);
                        break block0;
                    }
                    mat = BlockPackItem.addMaterial(itemStack, price);
                }
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack stack = pContext.m_43722_();
        BlockPack data = BlockPackItem.getData(stack);
        float mat = BlockPackItem.getMaterial(stack);
        Level level = pContext.m_43725_();
        CompoundTag tag = stack.m_41784_();
        if (pContext.m_43724_() == InteractionHand.MAIN_HAND) {
            int index;
            BlockPos pos;
            BlockState block;
            float price;
            Player player = pContext.m_43723_();
            if (player == null) {
                return InteractionResult.PASS;
            }
            if (player.m_6047_() && (price = data.getPrice((block = level.m_8055_(pos = pContext.m_8083_())).m_60734_())) != -1.0f) {
                if (player.m_7500_() || mat + price <= (float)data.getMaxMaterial()) {
                    level.m_46961_(pos, false);
                    BlockPackItem.addMaterial(stack, price);
                }
                return InteractionResult.SUCCESS;
            }
            if (mat > 0.0f && (index = tag.m_128451_("index")) >= 0 && index < data.length()) {
                block = data.getBlock(index);
                price = data.getPrice((Block)block);
                BlockItem item = (BlockItem)block.m_5456_();
                if (mat - price >= 0.0f) {
                    BlockPlaceContext cxt = new BlockPlaceContext(pContext.m_43725_(), pContext.m_43723_(), pContext.m_43724_(), new ItemStack((ItemLike)item), new BlockHitResult(pContext.m_43720_(), pContext.m_43719_(), pContext.m_8083_(), pContext.m_43721_()));
                    InteractionResult res = item.m_40576_(cxt);
                    if (!player.m_7500_() && !level.m_5776_() && res != InteractionResult.FAIL) {
                        BlockPackItem.addMaterial(stack, -price);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public int m_142158_(ItemStack pStack) {
        float maxMaterial = BlockPackItem.getMaxMaterial(pStack);
        float material = maxMaterial - BlockPackItem.getMaterial(pStack);
        return Math.round(13.0f - material * 13.0f / maxMaterial);
    }

    public int m_142159_(ItemStack pStack) {
        float maxMaterial = BlockPackItem.getMaxMaterial(pStack);
        float material = BlockPackItem.getMaterial(pStack);
        float f = Math.max(0.0f, (maxMaterial - material) / maxMaterial);
        return Mth.m_14169_((float)((239.0f - 36.0f * f) / 360.0f), (float)0.67f, (float)0.82f);
    }
}

