/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class BlockPackPacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static SimpleChannel INSTANCE;

    public static void commonSetup(FMLCommonSetupEvent event) {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("buildingpacks", "main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        INSTANCE.registerMessage(100, IndexUpdatePacket.class, IndexUpdatePacket::encode, IndexUpdatePacket::decode, BlockPackPacketHandler::onMessageReceived);
    }

    public static void onMessageReceived(IndexUpdatePacket message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.SERVER) {
            return;
        }
        ServerPlayer sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            return;
        }
        ctx.enqueueWork(() -> BlockPackPacketHandler.processMessage(message, sendingPlayer));
    }

    public static void processMessage(IndexUpdatePacket packet, ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("index", packet.index);
    }

    public record IndexUpdatePacket(int index) {
        public static IndexUpdatePacket decode(FriendlyByteBuf buf) {
            return new IndexUpdatePacket(buf.readInt());
        }

        public static void encode(IndexUpdatePacket packet, FriendlyByteBuf buf) {
            buf.writeInt(packet.index);
        }
    }
}

