/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks;

import com.bobvarioa.buildingpacks.BlockPack;
import com.bobvarioa.buildingpacks.BlockPackItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="buildingpacks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BlockPackRenderer
extends BlockEntityWithoutLevelRenderer {
    private static BlockPackRenderer instance;
    private ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
    private static ResourceLocation toolboxModel;

    public static BlockPackRenderer getInstance() {
        if (instance == null) {
            instance = new BlockPackRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
        }
        return instance;
    }

    public BlockPackRenderer(BlockEntityRenderDispatcher pBlockEntityRenderDispatcher, EntityModelSet pEntityModelSet) {
        super(pBlockEntityRenderDispatcher, pEntityModelSet);
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        ModelResourceLocation location = new ModelResourceLocation("buildingpacks", "block_pack", "inventory");
        event.getModels().put(location, new BlockPackBakedModel((BakedModel)event.getModels().get(location)));
    }

    @SubscribeEvent
    public static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
        event.register(toolboxModel);
    }

    public void m_108829_(ItemStack pStack, ItemDisplayContext pTransformType, PoseStack poseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        CompoundTag tag = pStack.m_41783_();
        if (tag == null) {
            return;
        }
        BlockPack data = BlockPackItem.getData(pStack);
        if (data == null) {
            return;
        }
        Block block = data.getBlock(tag.m_128451_("index"));
        if (block == null) {
            return;
        }
        ItemStack bi = new ItemStack((ItemLike)block.m_5456_());
        Minecraft mc = Minecraft.m_91087_();
        if (pTransformType == ItemDisplayContext.GUI) {
            BakedModel base = mc.m_91304_().getModel(toolboxModel);
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, -5.0f);
            this.renderItem(poseStack, pBuffer, pPackedLight, pPackedOverlay, false, base, bi);
            poseStack.m_85849_();
        }
        poseStack.m_85836_();
        BakedModel bakedModel = this.itemRenderer.m_174264_(bi, null, null, 0);
        if (pTransformType == ItemDisplayContext.GUI) {
            poseStack.m_85841_(0.5f, 0.5f, 1.0f);
            poseStack.m_252880_(1.5f, 1.5f, 0.0f);
            this.itemRenderer.m_115143_(bi, pTransformType, false, poseStack, pBuffer, pPackedLight, pPackedOverlay, bakedModel);
        } else {
            bakedModel = bakedModel.applyTransform(pTransformType, poseStack, false);
            if (!pTransformType.m_269069_()) {
                poseStack.m_252880_(0.0f, 1.0f, 0.0f);
                poseStack.m_85841_(1.9f, 1.9f, 1.9f);
                poseStack.m_252880_(0.0f, -0.5f, 0.0f);
            } else {
                poseStack.m_252880_(-1.0f, 1.0f, 1.0f);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(25.0f));
                poseStack.m_252781_(Axis.f_252393_.m_252977_(25.0f));
                poseStack.m_252781_(Axis.f_252392_.m_252977_(10.0f));
                poseStack.m_85841_(1.2f, 1.2f, 1.2f);
            }
            boolean flag1 = !pTransformType.m_269069_() ? !(block instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
            this.renderItem(poseStack, pBuffer, pPackedLight, pPackedOverlay, flag1, bakedModel, bi);
        }
        poseStack.m_85849_();
    }

    private void renderItem(PoseStack poseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay, boolean flag1, BakedModel bakedModel, ItemStack bi) {
        for (BakedModel model : bakedModel.getRenderPasses(bi, flag1)) {
            for (RenderType rendertype : model.getRenderTypes(bi, flag1)) {
                VertexConsumer vertexconsumer = flag1 ? ItemRenderer.m_115222_((MultiBufferSource)pBuffer, (RenderType)rendertype, (boolean)true, (boolean)bi.m_41790_()) : ItemRenderer.m_115211_((MultiBufferSource)pBuffer, (RenderType)rendertype, (boolean)true, (boolean)bi.m_41790_());
                this.itemRenderer.m_115189_(bakedModel, bi, pPackedLight, pPackedOverlay, poseStack, vertexconsumer);
            }
        }
    }

    static {
        toolboxModel = new ResourceLocation("buildingpacks", "item/toolbox");
    }

    public static class BlockPackBakedModel
    extends BakedModelWrapper<BakedModel> {
        public BlockPackBakedModel(BakedModel originalModel) {
            super(originalModel);
        }

        public boolean m_7521_() {
            return true;
        }

        public boolean m_7539_() {
            return true;
        }

        public BakedModel applyTransform(ItemDisplayContext cameraTransformType, PoseStack poseStack, boolean applyLeftHandTransform) {
            super.applyTransform(cameraTransformType, poseStack, applyLeftHandTransform);
            return this;
        }
    }
}

