/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks;

import com.bobvarioa.buildingpacks.BlockPack;
import com.bobvarioa.buildingpacks.BlockPackItem;
import com.bobvarioa.buildingpacks.BlockPackPacketHandler;
import com.mojang.logging.LogUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="buildingpacks")
public class BuildingPacks {
    public static final String MODID = "buildingpacks";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static IForgeRegistry<BlockPack> BLOCK_PACKS;
    public static final DeferredRegister<Item> ITEMS;
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS;
    public static final RegistryObject<Item> BLOCK_PACK;
    public static final RegistryObject<CreativeModeTab> EXAMPLE_TAB;

    private static ItemStack blockPackOf(String id) {
        ItemStack item = new ItemStack((ItemLike)BLOCK_PACK.get());
        CompoundTag tag = item.m_41784_();
        tag.m_128359_("id", id);
        ResourceLocation res = ResourceLocation.m_135820_((String)id);
        if (res == null) {
            return item;
        }
        BlockPack blockPack = (BlockPack)BLOCK_PACKS.getValue(res);
        if (blockPack == null) {
            return item;
        }
        tag.m_128405_("material", blockPack.getMaxMaterial());
        return item;
    }

    public BuildingPacks() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::createRegistry);
        modEventBus.addListener(this::onRegister);
        modEventBus.addListener(BlockPackPacketHandler::commonSetup);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(BlockPackItem::handleScroll);
        MinecraftForge.EVENT_BUS.addListener(BlockPackItem::pickBlock);
        MinecraftForge.EVENT_BUS.addListener(BlockPackItem::pickupItem);
    }

    private void createRegistry(NewRegistryEvent event) {
        RegistryBuilder builder = new RegistryBuilder();
        builder.setName(new ResourceLocation("buildingpacks:block_packs"));
        event.create(builder, reg -> {
            BLOCK_PACKS = reg;
        });
    }

    private void onRegister(RegisterEvent event) {
        event.register(ResourceKey.m_135788_((ResourceLocation)new ResourceLocation(MODID, "block_packs")), helper -> {
            helper.register("oak_wood", (Object)new BlockPack(512, "buildingpacks:oak_wood").put(Blocks.f_50705_, 1.0f).put(Blocks.f_49999_, 4.0f, true).put(Blocks.f_50010_, 4.0f, true).put(Blocks.f_50011_, 1.4f, true).put(Blocks.f_50044_, 1.4f, true).put(Blocks.f_50086_, 1.0f).put(Blocks.f_50398_, 0.5f).put(Blocks.f_50132_, 1.7f).put(Blocks.f_50192_, 4.0f).put(Blocks.f_50154_, 2.0f).put(Blocks.f_50167_, 2.0f).put(Blocks.f_50251_, 1.0f).put(Blocks.f_50095_, 2.2f).put(Blocks.f_50216_, 3.0f));
            helper.register("spruce_wood", (Object)new BlockPack(512, "buildingpacks:spruce_wood").put(Blocks.f_50741_, 1.0f).put(Blocks.f_50000_, 4.0f, true).put(Blocks.f_50005_, 4.0f, true).put(Blocks.f_50012_, 1.4f, true).put(Blocks.f_50045_, 1.4f, true).put(Blocks.f_50269_, 1.0f).put(Blocks.f_50399_, 0.5f).put(Blocks.f_50479_, 1.7f).put(Blocks.f_50474_, 4.0f).put(Blocks.f_50484_, 2.0f).put(Blocks.f_50168_, 2.0f).put(Blocks.f_50252_, 1.0f).put(Blocks.f_50149_, 2.2f).put(Blocks.f_50217_, 3.0f));
            helper.register("acacia_wood", (Object)new BlockPack(512, "buildingpacks:acacia_wood").put(Blocks.f_50744_, 1.0f).put(Blocks.f_50003_, 4.0f, true).put(Blocks.f_50008_, 4.0f, true).put(Blocks.f_50011_, 1.4f, true).put(Blocks.f_50048_, 1.4f, true).put(Blocks.f_50372_, 1.0f).put(Blocks.f_50402_, 0.5f).put(Blocks.f_50482_, 1.7f).put(Blocks.f_50477_, 4.0f).put(Blocks.f_50487_, 2.0f).put(Blocks.f_50171_, 2.0f).put(Blocks.f_50308_, 1.0f).put(Blocks.f_50151_, 2.2f).put(Blocks.f_50220_, 3.0f));
            helper.register("birch_wood", (Object)new BlockPack(512, "buildingpacks:birch_wood").put(Blocks.f_50742_, 1.0f).put(Blocks.f_50001_, 4.0f, true).put(Blocks.f_50006_, 4.0f, true).put(Blocks.f_50011_, 1.4f, true).put(Blocks.f_50046_, 1.4f, true).put(Blocks.f_50270_, 1.0f).put(Blocks.f_50400_, 0.5f).put(Blocks.f_50480_, 1.7f).put(Blocks.f_50475_, 4.0f).put(Blocks.f_50485_, 2.0f).put(Blocks.f_50169_, 2.0f).put(Blocks.f_50253_, 1.0f).put(Blocks.f_50150_, 2.2f).put(Blocks.f_50218_, 3.0f));
            helper.register("dark_oak_wood", (Object)new BlockPack(512, "buildingpacks:dark_oak_wood").put(Blocks.f_50745_, 1.0f).put(Blocks.f_50004_, 4.0f, true).put(Blocks.f_50009_, 4.0f, true).put(Blocks.f_50011_, 1.4f, true).put(Blocks.f_50049_, 1.4f, true).put(Blocks.f_50373_, 1.0f).put(Blocks.f_50403_, 0.5f).put(Blocks.f_50483_, 1.7f).put(Blocks.f_50478_, 4.0f).put(Blocks.f_50488_, 2.0f).put(Blocks.f_50172_, 2.0f).put(Blocks.f_50309_, 1.0f).put(Blocks.f_50153_, 2.2f).put(Blocks.f_50221_, 3.0f));
            helper.register("jungle_wood", (Object)new BlockPack(512, "buildingpacks:jungle_wood").put(Blocks.f_50743_, 1.0f).put(Blocks.f_50002_, 4.0f, true).put(Blocks.f_50007_, 4.0f, true).put(Blocks.f_50011_, 1.4f, true).put(Blocks.f_50047_, 1.4f, true).put(Blocks.f_50271_, 1.0f).put(Blocks.f_50401_, 0.5f).put(Blocks.f_50481_, 1.7f).put(Blocks.f_50476_, 4.0f).put(Blocks.f_50486_, 2.0f).put(Blocks.f_50170_, 2.0f).put(Blocks.f_50254_, 1.0f).put(Blocks.f_50152_, 2.2f).put(Blocks.f_50219_, 3.0f));
            helper.register("mangrove_wood", (Object)new BlockPack(512, "buildingpacks:mangrove_wood").put(Blocks.f_220865_, 1.0f).put(Blocks.f_220832_, 4.0f, true).put(Blocks.f_220835_, 4.0f, true).put(Blocks.f_50011_, 1.4f, true).put(Blocks.f_220837_, 1.4f, true).put(Blocks.f_220848_, 1.0f).put(Blocks.f_220851_, 0.5f).put(Blocks.f_220852_, 1.7f).put(Blocks.f_220850_, 4.0f).put(Blocks.f_220853_, 2.0f).put(Blocks.f_220840_, 2.0f).put(Blocks.f_220846_, 1.0f).put(Blocks.f_220841_, 2.2f).put(Blocks.f_220842_, 3.0f));
            helper.register("cherry_wood", (Object)new BlockPack(512, "buildingpacks:cherry_wood").put(Blocks.f_271304_, 1.0f).put(Blocks.f_271170_, 4.0f, true).put(Blocks.f_271326_, 4.0f, true).put(Blocks.f_50011_, 1.4f, true).put(Blocks.f_271145_, 1.4f, true).put(Blocks.f_271206_, 1.0f).put(Blocks.f_271301_, 0.5f).put(Blocks.f_271219_, 1.7f).put(Blocks.f_271274_, 4.0f).put(Blocks.f_271169_, 2.0f).put(Blocks.f_271227_, 2.0f).put(Blocks.f_271396_, 1.0f).put(Blocks.f_271516_, 2.2f).put(Blocks.f_271350_, 3.0f));
            helper.register("crimson_wood", (Object)new BlockPack(512, "buildingpacks:crimson_wood").put(Blocks.f_50655_, 1.0f).put(Blocks.f_50695_, 4.0f, true).put(Blocks.f_50696_, 4.0f, true).put(Blocks.f_50697_, 1.4f, true).put(Blocks.f_50698_, 1.4f, true).put(Blocks.f_50667_, 1.0f).put(Blocks.f_50657_, 0.5f).put(Blocks.f_50661_, 1.7f).put(Blocks.f_50665_, 4.0f).put(Blocks.f_50671_, 2.0f).put(Blocks.f_50659_, 2.0f).put(Blocks.f_50669_, 1.0f).put(Blocks.f_50673_, 2.2f).put(Blocks.f_50663_, 3.0f));
            helper.register("warped_wood", (Object)new BlockPack(512, "buildingpacks:warped_wood").put(Blocks.f_50656_, 1.0f).put(Blocks.f_50686_, 4.0f, true).put(Blocks.f_50687_, 4.0f, true).put(Blocks.f_50688_, 1.4f, true).put(Blocks.f_50689_, 1.4f, true).put(Blocks.f_50668_, 1.0f).put(Blocks.f_50658_, 0.5f).put(Blocks.f_50662_, 1.7f).put(Blocks.f_50666_, 4.0f).put(Blocks.f_50672_, 2.0f).put(Blocks.f_50660_, 2.0f).put(Blocks.f_50670_, 1.0f).put(Blocks.f_50674_, 2.2f).put(Blocks.f_50664_, 3.0f));
            helper.register("bamboo_wood", (Object)new BlockPack(512, "buildingpacks:bamboo_wood").put(Blocks.f_256831_, 2.0f, true).put(Blocks.f_244477_, 1.0f).put(Blocks.f_243755_, 1.0f).put(Blocks.f_244004_, 0.5f).put(Blocks.f_244641_, 1.7f).put(Blocks.f_244313_, 4.0f).put(Blocks.f_244648_, 2.0f).put(Blocks.f_244183_, 2.0f).put(Blocks.f_244625_, 1.0f).put(Blocks.f_244433_, 2.2f).put(Blocks.f_244549_, 3.0f));
            helper.register("stone", (Object)new BlockPack(512, "buildingpacks:stone").put(Blocks.f_50069_, 1.0f).put(Blocks.f_50635_, 1.0f).put(Blocks.f_50404_, 0.5f).put(Blocks.f_50165_, 2.0f).put(Blocks.f_50124_, 1.0f).put(Blocks.f_50222_, 1.0f).put(Blocks.f_50224_, 1.0f).put(Blocks.f_50194_, 1.0f).put(Blocks.f_50411_, 0.5f).put(Blocks.f_50609_, 1.0f).put(Blocks.f_50225_, 1.0f).put(Blocks.f_50470_, 1.0f).put(Blocks.f_50405_, 0.5f));
            helper.register("deepslate", (Object)new BlockPack(512, "buildingpacks:deepslate").put(Blocks.f_152550_, 1.0f).put(Blocks.f_152589_, 1.0f).put(Blocks.f_152594_, 1.0f).put(Blocks.f_152590_, 1.0f).put(Blocks.f_152591_, 0.5f).put(Blocks.f_152592_, 1.0f).put(Blocks.f_152559_, 1.0f).put(Blocks.f_152561_, 0.5f).put(Blocks.f_152560_, 1.0f).put(Blocks.f_152562_, 1.0f).put(Blocks.f_152551_, 1.0f).put(Blocks.f_152553_, 0.5f).put(Blocks.f_152552_, 1.0f).put(Blocks.f_152554_, 1.0f).put(Blocks.f_152555_, 1.0f).put(Blocks.f_152556_, 1.0f).put(Blocks.f_152557_, 0.5f));
            helper.register("cobblestone", (Object)new BlockPack(512, "buildingpacks:cobblestone").put(Blocks.f_50652_, 1.0f).put(Blocks.f_50157_, 1.0f).put(Blocks.f_50409_, 0.5f).put(Blocks.f_50274_, 1.0f));
            helper.register("blackstone", (Object)new BlockPack(512, "buildingpacks:blackstone").put(Blocks.f_50730_, 1.0f).put(Blocks.f_50731_, 1.0f).put(Blocks.f_50733_, 0.5f).put(Blocks.f_50734_, 1.0f).put(Blocks.f_50707_, 1.0f).put(Blocks.f_50708_, 0.5f).put(Blocks.f_50711_, 1.0f).put(Blocks.f_50710_, 1.0f).put(Blocks.f_50709_, 1.0f).put(Blocks.f_50735_, 1.0f).put(Blocks.f_50736_, 1.0f).put(Blocks.f_50739_, 1.0f).put(Blocks.f_50738_, 0.5f).put(Blocks.f_50740_, 1.0f).put(Blocks.f_50737_, 1.0f));
            helper.register("end_stone", (Object)new BlockPack(512, "buildingpacks:end_stone").put(Blocks.f_50259_, 1.0f).put(Blocks.f_50443_, 1.0f).put(Blocks.f_50634_, 1.0f).put(Blocks.f_50648_, 0.5f).put(Blocks.f_50614_, 1.0f));
            helper.register("granite", (Object)new BlockPack(512, "buildingpacks:granite").put(Blocks.f_50122_, 1.0f).put(Blocks.f_50638_, 1.0f).put(Blocks.f_50651_, 0.5f).put(Blocks.f_50608_, 1.0f).put(Blocks.f_50175_, 1.0f).put(Blocks.f_50629_, 1.0f).put(Blocks.f_50643_, 0.5f));
            helper.register("diorite", (Object)new BlockPack(512, "buildingpacks:diorite").put(Blocks.f_50228_, 1.0f).put(Blocks.f_50642_, 1.0f).put(Blocks.f_50603_, 0.5f).put(Blocks.f_50615_, 1.0f).put(Blocks.f_50281_, 1.0f).put(Blocks.f_50632_, 1.0f).put(Blocks.f_50646_, 0.5f));
            helper.register("andesite", (Object)new BlockPack(512, "buildingpacks:andesite").put(Blocks.f_50334_, 1.0f).put(Blocks.f_50639_, 1.0f).put(Blocks.f_50600_, 0.5f).put(Blocks.f_50611_, 1.0f).put(Blocks.f_50387_, 1.0f).put(Blocks.f_50641_, 1.0f).put(Blocks.f_50602_, 0.5f));
            helper.register("netherbrick", (Object)new BlockPack(512, "buildingpacks:netherbrick").put(Blocks.f_50197_, 1.0f).put(Blocks.f_50713_, 1.0f).put(Blocks.f_50199_, 1.0f).put(Blocks.f_50412_, 0.5f).put(Blocks.f_50610_, 1.0f).put(Blocks.f_50198_, 1.7f).put(Blocks.f_50712_, 1.0f));
            helper.register("red_netherbrick", (Object)new BlockPack(512, "buildingpacks:red_netherbrick").put(Blocks.f_50452_, 1.0f).put(Blocks.f_50640_, 1.0f).put(Blocks.f_50601_, 0.5f).put(Blocks.f_50612_, 1.0f));
            helper.register("sandstone", (Object)new BlockPack(512, "buildingpacks:sandstone").put(Blocks.f_50062_, 1.0f).put(Blocks.f_50263_, 1.0f).put(Blocks.f_50406_, 0.5f).put(Blocks.f_50613_, 1.0f).put(Blocks.f_50064_, 1.0f).put(Blocks.f_50063_, 1.0f).put(Blocks.f_50407_, 0.5f));
            helper.register("red_sandstone", (Object)new BlockPack(512, "buildingpacks:red_sandstone").put(Blocks.f_50394_, 1.0f).put(Blocks.f_50397_, 1.0f).put(Blocks.f_50467_, 0.5f).put(Blocks.f_50606_, 1.0f).put(Blocks.f_50396_, 1.0f).put(Blocks.f_50395_, 1.0f).put(Blocks.f_50468_, 0.5f));
            helper.register("quartz", (Object)new BlockPack(512, "buildingpacks:quartz").put(Blocks.f_50333_, 1.0f).put(Blocks.f_50714_, 1.0f).put(Blocks.f_50283_, 1.0f).put(Blocks.f_50284_, 1.0f).put(Blocks.f_50413_, 0.5f).put(Blocks.f_50472_, 1.0f).put(Blocks.f_50637_, 1.0f).put(Blocks.f_50650_, 0.5f).put(Blocks.f_50282_, 1.0f));
            helper.register("purpur", (Object)new BlockPack(512, "buildingpacks:purpur").put(Blocks.f_50492_, 1.0f).put(Blocks.f_50442_, 1.0f).put(Blocks.f_50469_, 0.5f).put(Blocks.f_50441_, 1.0f));
            helper.register("prismarine", (Object)new BlockPack(512, "buildingpacks:prismarine").put(Blocks.f_50377_, 1.0f).put(Blocks.f_50380_, 1.0f).put(Blocks.f_50383_, 0.5f).put(Blocks.f_50605_, 1.0f));
            helper.register("prismarine_bricks", (Object)new BlockPack(512, "buildingpacks:prismarine_bricks").put(Blocks.f_50378_, 1.0f).put(Blocks.f_50381_, 1.0f).put(Blocks.f_50384_, 0.5f));
            helper.register("dark_prismarine", (Object)new BlockPack(512, "buildingpacks:dark_prismarine").put(Blocks.f_50379_, 1.0f).put(Blocks.f_50382_, 1.0f).put(Blocks.f_50385_, 0.5f));
        });
    }

    static {
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MODID);
        CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)MODID);
        BLOCK_PACK = ITEMS.register("block_pack", () -> new BlockPackItem(new Item.Properties().m_41487_(1)));
        EXAMPLE_TAB = CREATIVE_MODE_TABS.register("block_packs", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256797_}).m_257737_(() -> BuildingPacks.blockPackOf("buildingpacks:oak_wood")).m_257501_((parameters, output) -> BlockPack.blockPacks.forEach(key -> output.m_246342_(BuildingPacks.blockPackOf(key.id)))).m_257941_((Component)Component.m_237115_((String)"creative.block_packs")).m_257652_());
    }
}

