/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.craftnoyaiba.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.craftnoyaiba.CraftNoYaibaMod;
import net.mcreator.craftnoyaiba.procedures.FormSelect1Procedure;
import net.mcreator.craftnoyaiba.procedures.FormSelect2Procedure;
import net.mcreator.craftnoyaiba.procedures.FormSelect3Procedure;
import net.mcreator.craftnoyaiba.procedures.FormSelect4Procedure;
import net.mcreator.craftnoyaiba.world.inventory.SelectFormMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SelectFormButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SelectFormButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SelectFormButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SelectFormButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SelectFormButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SelectFormButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = SelectFormMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            FormSelect1Procedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            FormSelect2Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            FormSelect3Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            FormSelect4Procedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CraftNoYaibaMod.addNetworkMessage(SelectFormButtonMessage.class, SelectFormButtonMessage::buffer, SelectFormButtonMessage::new, SelectFormButtonMessage::handler);
    }
}

