/*
 * Decompiled with CFR 0.152.
 */
package net.teamneon.mystic.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.teamneon.mystic.MysticMod;
import net.teamneon.mystic.procedures.Button1SelectProcedure;
import net.teamneon.mystic.procedures.Button2SelectProcedure;
import net.teamneon.mystic.procedures.Button3SelectProcedure;
import net.teamneon.mystic.procedures.InscribeCraftProcedureProcedure;
import net.teamneon.mystic.procedures.InscriptionTableUpdateTickProcedure;
import net.teamneon.mystic.world.inventory.InscriptionTableGUIMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class InscriptionTableGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public InscriptionTableGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public InscriptionTableGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(InscriptionTableGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(InscriptionTableGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            InscriptionTableGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = InscriptionTableGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Button1SelectProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            Button2SelectProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            Button3SelectProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            InscribeCraftProcedureProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            InscriptionTableUpdateTickProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MysticMod.addNetworkMessage(InscriptionTableGUIButtonMessage.class, InscriptionTableGUIButtonMessage::buffer, InscriptionTableGUIButtonMessage::new, InscriptionTableGUIButtonMessage::handler);
    }
}

