/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.animatedmobsmod.network;

import java.util.function.Supplier;
import net.mcreator.animatedmobsmod.AnimatedmobsmodMod;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AnimatedmobsmodModVariables {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        AnimatedmobsmodMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "animatedmobsmod_mapvars";
        public boolean nohealing = false;
        public double musis = 0.0;
        public boolean music = false;
        public boolean onlyone = false;
        public double magic = 0.0;
        public boolean soul = false;
        public boolean mmm = false;
        public boolean aaaaa = false;
        public boolean redsoul = false;
        public boolean cc = false;
        public boolean lighton = false;
        public boolean truly = false;
        public boolean mmmm = false;
        public boolean transform = false;
        public boolean returns = false;
        public boolean smoketransfer = false;
        public boolean rushy = false;
        public boolean particle = false;
        public boolean slow = false;
        public boolean hbghost = false;
        public boolean rangehw = false;
        public boolean part = false;
        public boolean windy = false;
        public boolean fiend_riding = false;
        public boolean fiendstatus = false;
        public boolean facing_direction = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.nohealing = nbt.m_128471_("nohealing");
            this.musis = nbt.m_128459_("musis");
            this.music = nbt.m_128471_("music");
            this.onlyone = nbt.m_128471_("onlyone");
            this.magic = nbt.m_128459_("magic");
            this.soul = nbt.m_128471_("soul");
            this.mmm = nbt.m_128471_("mmm");
            this.aaaaa = nbt.m_128471_("aaaaa");
            this.redsoul = nbt.m_128471_("redsoul");
            this.cc = nbt.m_128471_("cc");
            this.lighton = nbt.m_128471_("lighton");
            this.truly = nbt.m_128471_("truly");
            this.mmmm = nbt.m_128471_("mmmm");
            this.transform = nbt.m_128471_("transform");
            this.returns = nbt.m_128471_("returns");
            this.smoketransfer = nbt.m_128471_("smoketransfer");
            this.rushy = nbt.m_128471_("rushy");
            this.particle = nbt.m_128471_("particle");
            this.slow = nbt.m_128471_("slow");
            this.hbghost = nbt.m_128471_("hbghost");
            this.rangehw = nbt.m_128471_("rangehw");
            this.part = nbt.m_128471_("part");
            this.windy = nbt.m_128471_("windy");
            this.fiend_riding = nbt.m_128471_("fiend_riding");
            this.fiendstatus = nbt.m_128471_("fiendstatus");
            this.facing_direction = nbt.m_128471_("facing_direction");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("nohealing", this.nohealing);
            nbt.m_128347_("musis", this.musis);
            nbt.m_128379_("music", this.music);
            nbt.m_128379_("onlyone", this.onlyone);
            nbt.m_128347_("magic", this.magic);
            nbt.m_128379_("soul", this.soul);
            nbt.m_128379_("mmm", this.mmm);
            nbt.m_128379_("aaaaa", this.aaaaa);
            nbt.m_128379_("redsoul", this.redsoul);
            nbt.m_128379_("cc", this.cc);
            nbt.m_128379_("lighton", this.lighton);
            nbt.m_128379_("truly", this.truly);
            nbt.m_128379_("mmmm", this.mmmm);
            nbt.m_128379_("transform", this.transform);
            nbt.m_128379_("returns", this.returns);
            nbt.m_128379_("smoketransfer", this.smoketransfer);
            nbt.m_128379_("rushy", this.rushy);
            nbt.m_128379_("particle", this.particle);
            nbt.m_128379_("slow", this.slow);
            nbt.m_128379_("hbghost", this.hbghost);
            nbt.m_128379_("rangehw", this.rangehw);
            nbt.m_128379_("part", this.part);
            nbt.m_128379_("windy", this.windy);
            nbt.m_128379_("fiend_riding", this.fiend_riding);
            nbt.m_128379_("fiendstatus", this.fiendstatus);
            nbt.m_128379_("facing_direction", this.facing_direction);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                AnimatedmobsmodMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "animatedmobsmod_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                AnimatedmobsmodMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_);
                if (mapdata != null) {
                    AnimatedmobsmodMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    AnimatedmobsmodMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_)) != null) {
                AnimatedmobsmodMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

