/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.coolrain.mixin;

import com.leclowndu93150.coolrain.CoolRainSounds;
import com.leclowndu93150.coolrain.tags.ModTags;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class RainMixin {
    @Shadow
    private int f_109450_;
    @Shadow
    @Final
    private Minecraft f_109461_;

    @Shadow(remap=false)
    public abstract int getTicks();

    @Inject(method={"tickRain"}, at={@At(value="HEAD")}, cancellable=true)
    public void tickRain(Camera camera, CallbackInfo ci) {
        ClientLevel world = this.f_109461_.f_91073_;
        if (world == null) {
            return;
        }
        float rainLevel = world.m_46722_(1.0f) / (Minecraft.m_91405_() ? 1.0f : 2.0f);
        if (rainLevel <= 0.0f) {
            return;
        }
        RandomSource random = RandomSource.m_216335_((long)((long)this.getTicks() * 312987231L));
        ClientLevel levelReader = world;
        BlockPos cameraPos = BlockPos.m_274446_((Position)camera.m_90583_());
        BlockPos soundPos = null;
        int particleCount = (int)(100.0f * rainLevel * rainLevel) / (this.f_109461_.f_91066_.m_231929_().m_231551_() == ParticleStatus.DECREASED ? 2 : 1);
        for (int i = 0; i < particleCount; ++i) {
            Biome biome;
            int offsetZ;
            int offsetX = random.m_188503_(21) - 10;
            BlockPos heightmapPos = levelReader.m_5452_(Heightmap.Types.MOTION_BLOCKING, cameraPos.m_7918_(offsetX, 0, offsetZ = random.m_188503_(21) - 10));
            if (heightmapPos.m_123342_() <= levelReader.m_141937_() || heightmapPos.m_123342_() > cameraPos.m_123342_() + 10 || heightmapPos.m_123342_() < cameraPos.m_123342_() - 10 || (biome = (Biome)levelReader.m_204166_(heightmapPos).m_203334_()).m_264600_(heightmapPos) != Biome.Precipitation.RAIN) continue;
            soundPos = heightmapPos.m_7495_();
            if (this.f_109461_.f_91066_.m_231929_().m_231551_() == ParticleStatus.MINIMAL) break;
            double particleX = random.m_188500_();
            double particleZ = random.m_188500_();
            BlockState blockState = levelReader.m_8055_(soundPos);
            FluidState fluidState = levelReader.m_6425_(soundPos);
            VoxelShape shape = blockState.m_60812_((BlockGetter)levelReader, soundPos);
            double shapeHeight = shape.m_83290_(Direction.Axis.Y, particleX, particleZ);
            double fluidHeight = fluidState.m_76155_((BlockGetter)levelReader, soundPos);
            double maxHeight = Math.max(shapeHeight, fluidHeight);
            ParticleOptions particleType = this.getParticleType(blockState, fluidState);
            this.f_109461_.f_91073_.m_7106_(particleType, (double)soundPos.m_123341_() + particleX, (double)soundPos.m_123342_() + maxHeight, (double)soundPos.m_123343_() + particleZ, 0.0, 0.0, 0.0);
        }
        if (soundPos != null && random.m_188503_(3) < this.f_109450_++) {
            this.f_109450_ = 0;
            BlockState blockState = levelReader.m_8055_(soundPos);
            boolean isMuffled = this.isMuffledSound((LevelReader)levelReader, soundPos, cameraPos);
            this.playRainSound(world, soundPos, blockState, random, isMuffled);
        }
        ci.cancel();
    }

    @Unique
    private ParticleOptions getParticleType(BlockState blockState, FluidState fluidState) {
        return !fluidState.m_205070_(FluidTags.f_13132_) && !blockState.m_60713_(Blocks.f_50450_) && !CampfireBlock.m_51319_((BlockState)blockState) ? ParticleTypes.f_123761_ : ParticleTypes.f_123762_;
    }

    @Unique
    private boolean isMuffledSound(LevelReader world, BlockPos soundPos, BlockPos cameraPos) {
        return soundPos.m_123342_() > cameraPos.m_123342_() + 1 && world.m_5452_(Heightmap.Types.MOTION_BLOCKING, cameraPos).m_123342_() > Mth.m_14143_((float)cameraPos.m_123342_());
    }

    @Unique
    private void playRainSound(ClientLevel world, BlockPos pos, BlockState blockState, RandomSource random, boolean isMuffled) {
        SoundEvent sound = this.getRainSoundForBlock(blockState);
        float volume = this.getRainSoundVolume(blockState, isMuffled);
        float pitch = this.getRainSoundPitch(blockState, random);
        boolean shouldAttenuate = this.shouldAttenuateSound(blockState);
        if (sound == CoolRainSounds.RAIN_SOUNDS_AMETHYST.get() || sound == CoolRainSounds.RAIN_SOUNDS_NOTEBLOCK.get()) {
            world.m_245747_(pos, SoundEvents.f_12541_, SoundSource.WEATHER, 0.2f, 1.0f, false);
        }
        if (sound == CoolRainSounds.RAIN_SOUNDS_LAVA.get()) {
            world.m_245747_(pos, SoundEvents.f_12541_, SoundSource.WEATHER, 0.1f, pitch, false);
        }
        world.m_245747_(pos, sound, SoundSource.WEATHER, volume, pitch, shouldAttenuate);
    }

    @Unique
    private SoundEvent getRainSoundForBlock(BlockState blockState) {
        if (blockState.m_60713_(Blocks.f_49991_) || blockState.m_60713_(Blocks.f_50450_) || blockState.m_60713_(Blocks.f_50683_) || blockState.m_60713_(Blocks.f_50684_) || blockState.m_204336_(ModTags.Blocks.LAVA_BLOCKS)) {
            return (SoundEvent)CoolRainSounds.RAIN_SOUNDS_LAVA.get();
        }
        if (blockState.m_60713_(Blocks.f_49990_) || blockState.m_204336_(ModTags.Blocks.WATER_BLOCKS)) {
            return (SoundEvent)CoolRainSounds.RAIN_SOUNDS_WATER.get();
        }
        if (blockState.m_60713_(Blocks.f_152490_) || blockState.m_60713_(Blocks.f_152492_) || blockState.m_60713_(Blocks.f_152491_) || blockState.m_60713_(Blocks.f_152495_) || blockState.m_60713_(Blocks.f_152494_) || blockState.m_60713_(Blocks.f_152493_) || blockState.m_204336_(ModTags.Blocks.AMETHYST_BLOCKS)) {
            return (SoundEvent)CoolRainSounds.RAIN_SOUNDS_AMETHYST.get();
        }
        if (blockState.m_60713_(Blocks.f_50065_) || blockState.m_204336_(ModTags.Blocks.NOTEBLOCK_BLOCKS)) {
            return (SoundEvent)CoolRainSounds.RAIN_SOUNDS_NOTEBLOCK.get();
        }
        if (blockState.m_204336_(ModTags.Blocks.METAL_BLOCKS) || blockState.m_204336_(ModTags.Blocks.FORGE_STORAGE_BLOCKS_IRON) || blockState.m_204336_(ModTags.Blocks.FORGE_STORAGE_BLOCKS_COPPER) || blockState.m_204336_(ModTags.Blocks.FORGE_STORAGE_BLOCKS_GOLD) || blockState.m_204336_(ModTags.Blocks.FORGE_STORAGE_BLOCKS_NETHERITE) || blockState.m_60713_(Blocks.f_50075_) || blockState.m_60713_(Blocks.f_50074_) || blockState.m_60713_(Blocks.f_50721_) || blockState.m_60713_(Blocks.f_152504_) || blockState.m_60713_(Blocks.f_152598_) || blockState.m_60713_(Blocks.f_152599_) || blockState.m_60713_(Blocks.f_152600_) || blockState.m_60713_(Blocks.f_50681_) || blockState.m_60713_(Blocks.f_50682_) || blockState.m_60713_(Blocks.f_50376_)) {
            return (SoundEvent)CoolRainSounds.RAIN_SOUNDS_METAL.get();
        }
        if (blockState.m_204336_(ModTags.Blocks.GLASS_BLOCKS) || blockState.m_204336_(ModTags.Blocks.FORGE_GLASS_BLOCKS) || blockState.m_204336_(ModTags.Blocks.FORGE_GLASS_PANES) || blockState.m_60713_(Blocks.f_50058_) || blockState.m_60713_(Blocks.f_152498_) || blockState.m_60713_(Blocks.f_50126_) || blockState.m_60713_(Blocks.f_50568_) || blockState.m_60713_(Blocks.f_50354_)) {
            return (SoundEvent)CoolRainSounds.RAIN_SOUNDS_GLASS.get();
        }
        if (blockState.m_204336_(ModTags.Blocks.FABRIC_BLOCKS) || blockState.m_204336_(BlockTags.f_13089_) || blockState.m_204336_(BlockTags.f_215838_) || blockState.m_204336_(BlockTags.f_13038_)) {
            return (SoundEvent)CoolRainSounds.RAIN_SOUNDS_FABRIC.get();
        }
        if (blockState.m_204336_(ModTags.Blocks.FOLIAGE_BLOCKS) || blockState.m_204336_(BlockTags.f_13035_)) {
            return (SoundEvent)CoolRainSounds.RAIN_SOUNDS_FOLIAGE.get();
        }
        return SoundEvents.f_12541_;
    }

    @Unique
    private float getRainSoundVolume(BlockState blockState, boolean isMuffled) {
        SoundEvent sound = this.getRainSoundForBlock(blockState);
        if (sound == CoolRainSounds.RAIN_SOUNDS_FABRIC.get()) {
            return 0.75f;
        }
        if (sound == CoolRainSounds.RAIN_SOUNDS_WATER.get()) {
            return 0.175f;
        }
        if (sound == CoolRainSounds.RAIN_SOUNDS_AMETHYST.get()) {
            return 0.3f;
        }
        if (sound == CoolRainSounds.RAIN_SOUNDS_NOTEBLOCK.get()) {
            return 0.2f;
        }
        if (sound == CoolRainSounds.RAIN_SOUNDS_LAVA.get()) {
            return 0.2f;
        }
        if (sound == SoundEvents.f_12542_) {
            return 0.1f;
        }
        if (sound == SoundEvents.f_12541_) {
            return 0.2f;
        }
        return 0.5f;
    }

    @Unique
    private float getRainSoundPitch(BlockState blockState, RandomSource random) {
        SoundEvent sound = this.getRainSoundForBlock(blockState);
        if (sound == CoolRainSounds.RAIN_SOUNDS_FOLIAGE.get() || sound == CoolRainSounds.RAIN_SOUNDS_LAVA.get()) {
            return 1.0f;
        }
        if (sound == SoundEvents.f_12542_) {
            return 0.75f;
        }
        if (sound == SoundEvents.f_12541_) {
            return 1.0f;
        }
        return (float)random.m_216332_(8, 12) * 0.1f;
    }

    @Unique
    private boolean shouldAttenuateSound(BlockState blockState) {
        SoundEvent sound = this.getRainSoundForBlock(blockState);
        return sound != CoolRainSounds.RAIN_SOUNDS_AMETHYST.get() && sound != CoolRainSounds.RAIN_SOUNDS_NOTEBLOCK.get() && sound != SoundEvents.f_12542_ && sound != SoundEvents.f_12541_;
    }
}

