/*
 * Decompiled with CFR 0.152.
 */
package com.lschroma.thepillagerlegion.init;

import com.google.common.collect.ImmutableSet;
import com.lschroma.thepillagerlegion.ThePillagerLegionMod;
import com.lschroma.thepillagerlegion.init.ThePillagerLegionModBlocks;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ThePillagerLegionModVillagerProfessions {
    private static final Map<String, ProfessionPoiType> POI_TYPES = new HashMap<String, ProfessionPoiType>();
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((ResourceKey)Registries.VILLAGER_PROFESSION, (String)"the_pillager_legion_");
    public static final DeferredHolder<VillagerProfession, VillagerProfession> LEGION_BANKER = ThePillagerLegionModVillagerProfessions.registerProfession("legion_banker", () -> (Block)ThePillagerLegionModBlocks.LEGION_COIN_TABLE.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.villager.work_toolsmith")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> LEGION_MASON = ThePillagerLegionModVillagerProfessions.registerProfession("legion_mason", () -> (Block)ThePillagerLegionModBlocks.LEGION_BLOCK_TABLE.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.villager.work_mason")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> LEGION_SANDSTONE_MASON = ThePillagerLegionModVillagerProfessions.registerProfession("legion_sandstone_mason", () -> (Block)ThePillagerLegionModBlocks.LEGION_SAND_STONE_BLOCK_TABLE.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.villager.work_mason")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> LEGION_NETHER_MASON = ThePillagerLegionModVillagerProfessions.registerProfession("legion_nether_mason", () -> (Block)ThePillagerLegionModBlocks.LEGION_NETHER_BLOCK_TABLE.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.villager.work_mason")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> LEGION_ARMORER = ThePillagerLegionModVillagerProfessions.registerProfession("legion_armorer", () -> (Block)ThePillagerLegionModBlocks.LEGION_ARMOR_TABLE.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.villager.work_mason")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> LEGION_WEAPONSMITH = ThePillagerLegionModVillagerProfessions.registerProfession("legion_weaponsmith", () -> (Block)ThePillagerLegionModBlocks.LEGION_WEAPON_TABLE.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.villager.work_weaponsmith")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> LEGION_TOOLSMITH = ThePillagerLegionModVillagerProfessions.registerProfession("legion_toolsmith", () -> (Block)ThePillagerLegionModBlocks.LEGION_TOOL_TABLE.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.villager.work_toolsmith")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> LEGION_SELLER = ThePillagerLegionModVillagerProfessions.registerProfession("legion_seller", () -> (Block)ThePillagerLegionModBlocks.LEGION_SHOPPING_STAND.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.villager.work_librarian")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> LEGION_BUYER = ThePillagerLegionModVillagerProfessions.registerProfession("legion_buyer", () -> (Block)ThePillagerLegionModBlocks.LEGION_SALES_STAND.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.villager.work_librarian")));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> LEGION_TAVERN_KEEPER = ThePillagerLegionModVillagerProfessions.registerProfession("legion_tavern_keeper", () -> (Block)ThePillagerLegionModBlocks.LEGION_TAVERN_WORK_STATION.get(), () -> (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.villager.work_toolsmith")));

    private static DeferredHolder<VillagerProfession, VillagerProfession> registerProfession(String name, Supplier<Block> block, Supplier<SoundEvent> soundEvent) {
        POI_TYPES.put(name, new ProfessionPoiType(block, null));
        return PROFESSIONS.register(name, () -> {
            Predicate<Holder> poiPredicate = poiTypeHolder -> ThePillagerLegionModVillagerProfessions.POI_TYPES.get((Object)name).poiType != null && poiTypeHolder.value() == ThePillagerLegionModVillagerProfessions.POI_TYPES.get((Object)name).poiType.value();
            return new VillagerProfession("the_pillager_legion_:" + name, poiPredicate, poiPredicate, ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)soundEvent.get());
        });
    }

    @SubscribeEvent
    public static void registerProfessionPointsOfInterest(RegisterEvent event) {
        event.register(Registries.POINT_OF_INTEREST_TYPE, registerHelper -> {
            for (Map.Entry<String, ProfessionPoiType> entry : POI_TYPES.entrySet()) {
                Block block = entry.getValue().block.get();
                String name = entry.getKey();
                Optional existingCheck = PoiTypes.forState((BlockState)block.defaultBlockState());
                if (existingCheck.isPresent()) {
                    ThePillagerLegionMod.LOGGER.error("Skipping villager profession " + name + " that uses POI block " + String.valueOf(block) + " that is already in use by " + String.valueOf(existingCheck));
                    continue;
                }
                PoiType poiType = new PoiType((Set)ImmutableSet.copyOf((Collection)block.getStateDefinition().getPossibleStates()), 1, 1);
                registerHelper.register(ResourceLocation.fromNamespaceAndPath((String)"the_pillager_legion_", (String)name), (Object)poiType);
                entry.getValue().poiType = BuiltInRegistries.POINT_OF_INTEREST_TYPE.wrapAsHolder((Object)poiType);
            }
        });
    }

    private static class ProfessionPoiType {
        final Supplier<Block> block;
        Holder<PoiType> poiType;

        ProfessionPoiType(Supplier<Block> block, Holder<PoiType> poiType) {
            this.block = block;
            this.poiType = poiType;
        }
    }
}

