/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.client.render.entity;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.client.model.MurkEntityModel;
import com.faboslav.variantsandventures.common.client.render.entity.state.MurkEntityRenderState;
import com.faboslav.variantsandventures.common.entity.mob.MurkEntity;
import com.faboslav.variantsandventures.common.init.VariantsAndVenturesModelLayers;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AbstractSkeletonRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.SkeletonRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.AbstractSkeleton;

public class MurkEntityRenderer
extends AbstractSkeletonRenderer<MurkEntity, MurkEntityRenderState> {
    public static final Map<MurkEntity.Variant, ResourceLocation> TEXTURES = (Map)Util.make((Object)Maps.newHashMap(), textures -> {
        for (MurkEntity.Variant variant : MurkEntity.Variant.VARIANTS) {
            textures.put(variant, VariantsAndVentures.makeID(String.format(Locale.ROOT, "textures/entity/murk/murk_%s.png", variant.getName())));
        }
    });

    public MurkEntityRenderer(EntityRendererProvider.Context context) {
        super(context, ModelLayers.BOGGED_INNER_ARMOR, ModelLayers.BOGGED_OUTER_ARMOR, (SkeletonModel)new MurkEntityModel(context.bakeLayer(VariantsAndVenturesModelLayers.MURK)));
    }

    public MurkEntityRenderState createRenderState() {
        return new MurkEntityRenderState();
    }

    public void extractRenderState(MurkEntity murk, MurkEntityRenderState murkRenderState, float partialTick) {
        super.extractRenderState((AbstractSkeleton)murk, (SkeletonRenderState)murkRenderState, partialTick);
        murkRenderState.variant = murk.getVariant();
        murkRenderState.sheared = murk.isSheared();
    }

    public ResourceLocation getTextureLocation(MurkEntityRenderState renderState) {
        return TEXTURES.get((Object)renderState.variant);
    }
}

